//
//  UtilUITool.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/13.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "UtilUITool.h"

@implementation UtilUITool

#pragma mark - 贝塞尔曲线
+ (UIBezierPath *)loadingBezierPath {
    UIBezierPath* bezierPath = UIBezierPath.bezierPath;
    [bezierPath moveToPoint: CGPointMake(15, 38.5)];
    [bezierPath addCurveToPoint: CGPointMake(15, 38.5) controlPoint1: CGPointMake(13.89, 38.03) controlPoint2: CGPointMake(14.39, 38.5)];
    [bezierPath addCurveToPoint: CGPointMake(16.13, 37.43) controlPoint1: CGPointMake(15.61, 38.5) controlPoint2: CGPointMake(16.11, 38.03)];
    [bezierPath addCurveToPoint: CGPointMake(19.55, 29.77) controlPoint1: CGPointMake(16.65, 34.59) controlPoint2: CGPointMake(17.85, 31.98)];
    [bezierPath addCurveToPoint: CGPointMake(19.57, 29.72) controlPoint1: CGPointMake(19.56, 29.75) controlPoint2: CGPointMake(19.56, 29.74)];
    [bezierPath addCurveToPoint: CGPointMake(23.32, 25.56) controlPoint1: CGPointMake(20.21, 28.8) controlPoint2: CGPointMake(22.56, 26.39)];
    [bezierPath addCurveToPoint: CGPointMake(24.79, 23.91) controlPoint1: CGPointMake(23.66, 25.18) controlPoint2: CGPointMake(24.29, 24.52)];
    [bezierPath addCurveToPoint: CGPointMake(24.81, 23.88) controlPoint1: CGPointMake(24.8, 23.9) controlPoint2: CGPointMake(24.8, 23.89)];
    [bezierPath addCurveToPoint: CGPointMake(27.97, 15.93) controlPoint1: CGPointMake(27.81, 20.48) controlPoint2: CGPointMake(27.97, 16.74)];
    [bezierPath addCurveToPoint: CGPointMake(28, 15.24) controlPoint1: CGPointMake(27.98, 15.7) controlPoint2: CGPointMake(28, 15.47)];
    [bezierPath addCurveToPoint: CGPointMake(15.05, 2.5) controlPoint1: CGPointMake(28, 8.2) controlPoint2: CGPointMake(22.2, 2.5)];
    [bezierPath addCurveToPoint: CGPointMake(15, 2.5) controlPoint1: CGPointMake(15.03, 2.5) controlPoint2: CGPointMake(15.02, 2.5)];
    [bezierPath addCurveToPoint: CGPointMake(14.95, 2.5) controlPoint1: CGPointMake(14.98, 2.5) controlPoint2: CGPointMake(14.97, 2.5)];
    [bezierPath addCurveToPoint: CGPointMake(2, 15.24) controlPoint1: CGPointMake(7.8, 2.5) controlPoint2: CGPointMake(2, 8.2)];
    [bezierPath addCurveToPoint: CGPointMake(2.03, 15.93) controlPoint1: CGPointMake(2, 15.47) controlPoint2: CGPointMake(2.02, 15.7)];
    [bezierPath addCurveToPoint: CGPointMake(5.19, 23.88) controlPoint1: CGPointMake(2.03, 16.74) controlPoint2: CGPointMake(2.19, 20.48)];
    [bezierPath addCurveToPoint: CGPointMake(5.21, 23.91) controlPoint1: CGPointMake(5.2, 23.89) controlPoint2: CGPointMake(5.2, 23.9)];
    [bezierPath addCurveToPoint: CGPointMake(6.68, 25.56) controlPoint1: CGPointMake(5.71, 24.52) controlPoint2: CGPointMake(6.34, 25.18)];
    [bezierPath addCurveToPoint: CGPointMake(10.43, 29.72) controlPoint1: CGPointMake(7.44, 26.39) controlPoint2: CGPointMake(9.79, 28.8)];
    [bezierPath addCurveToPoint: CGPointMake(10.45, 29.77) controlPoint1: CGPointMake(10.44, 29.74) controlPoint2: CGPointMake(10.44, 29.75)];
    [bezierPath addCurveToPoint: CGPointMake(13.87, 37.43) controlPoint1: CGPointMake(12.16, 31.98) controlPoint2: CGPointMake(13.35, 34.59)];
    [bezierPath addCurveToPoint: CGPointMake(16.13, 37.43) controlPoint1: CGPointMake(15.61, 38.5) controlPoint2: CGPointMake(16.11, 38.03)];
    [bezierPath closePath];
    return bezierPath;
}

/**
 返回算路偏好文案
 
 @param mode 偏好
 @return 算路偏好文案
 */
+ (NSString *)nameForStrategy:(BNRoutePlanMode)mode {
    NSString *name = nil;
    switch (mode) {
        case BNRoutePlanMode_Recommend:
            name = @"智能推荐";
            break;
        case BNRoutePlanMode_NoHeighWay:
            name = @"不走高速";
            break;
        case BNRoutePlanMode_LessToll:
            name = @"少收费";
            break;
        case BNRoutePlanMode_LessJam:
            name = @"躲避拥堵";
            break;
        case BNRoutePlanMode_SaveTime:
            name = @"时间优先";
            break;
        case BNRoutePlanMode_MainRoad:
            name = @"高速优先";
            break;
        default:
            name = @"";
            break;
    }
    return name;
}

+ (UIImage *)loadResourceImage:(NSString*)imageName {
    return [UIImage imageNamed:imageName];
}
+ (UIImage *)getImgWithBundleString:(NSString*)imgStr {
    NSString *imagePath = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:[NSString stringWithFormat:@"baiduNaviSDK.bundle/image/%@", imgStr]];
    UIImage *image = [UIImage imageWithContentsOfFile:imagePath];
    return image;
}
@end


#ifdef __cplusplus
extern "C" {
#endif

    CGRect getScreenFrame(){
        CGRect mainScreenFrame = [UIScreen mainScreen].bounds;
        mainScreenFrame = CGRectMake(0, 0, MIN(mainScreenFrame.size.width, mainScreenFrame.size.height),MAX(mainScreenFrame.size.width, mainScreenFrame.size.height));
        return mainScreenFrame;
    }
    
    UIEdgeInsets safeAreaInsets() {
        UIEdgeInsets safeAreaInsets = UIEdgeInsetsZero;
        if (@available(iOS 11.0, *)) {
            safeAreaInsets = [[[[UIApplication sharedApplication] delegate] window] safeAreaInsets];
        }
        return safeAreaInsets;
    }

#ifdef __cplusplus
}
#endif
