//
//  UtilUITool.h
//  NaviDemo
//
//  Created by linbiao on 2019/5/13.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "BNCommonDef.h"

NS_ASSUME_NONNULL_BEGIN

@interface UtilUITool : NSObject

/**
 loading动画的贝塞尔曲线
 
 @return 贝塞尔曲线
 */
+ (UIBezierPath *)loadingBezierPath;

/**
 返回算路偏好文案
 
 @param mode 偏好
 @return 算路偏好文案
 */
+ (NSString *)nameForStrategy:(BNRoutePlanMode)mode;

/**
 加载图片资源
 
 @param imageName 图片名
 @return 图片资源
 */
+ (UIImage *)loadResourceImage:(NSString*)imageName;
/**
 加载Bundle图片资源
 @param imageName 图片名
 @return 图片资源
 */
+ (UIImage *)getImgWithBundleString:(NSString*)imgStr;
@end

NS_ASSUME_NONNULL_END
