//
//  UIView+Ext.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/21.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "UIView+Ext.h"
#import "CommonDefine.h"

@implementation UIView (Ext)

- (void)addShadowLayer {
    self.layer.shadowOffset = CGSizeMake(1, 1);
    self.layer.shadowOpacity = 0.5;
    self.layer.shadowColor = UIColorFromRGBA(0x000000, 0.5).CGColor;
}

- (void)addTopShadowLayer {
    UIBezierPath *maskPath = [UIBezierPath bezierPathWithRoundedRect:self.bounds byRoundingCorners:UIRectCornerTopLeft|UIRectCornerTopRight cornerRadii:CGSizeMake(ADAPTOR_VALUE_1242(20), ADAPTOR_VALUE_1242(20))];
    CAShapeLayer *maskLayer = [[CAShapeLayer alloc] init];
    maskLayer.frame = self.bounds;
    maskLayer.path = maskPath.CGPath;
    self.layer.mask = maskLayer;
}

- (void)addBottomShadowLayer {
    UIBezierPath *maskPath = [UIBezierPath bezierPathWithRoundedRect:self.bounds byRoundingCorners:UIRectCornerBottomLeft|UIRectCornerBottomRight cornerRadii:CGSizeMake(ADAPTOR_VALUE_1242(20), ADAPTOR_VALUE_1242(20))];
    CAShapeLayer *maskLayer = [[CAShapeLayer alloc] init];
    maskLayer.frame = self.bounds;
    maskLayer.path = maskPath.CGPath;
    self.layer.mask = maskLayer;
}

@end
