//
//  StringSizeCache.h
//  NaviDemo
//
//  Created by linbiao on 2019/5/9.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface StringSizeCache : NSObject

/**
 设置最大缓存数量，默认200个
 
 @param maxCount 最大缓存数量
 */
- (void)setMaxCacheCount:(NSInteger)maxCount;


/**
 获取字符串在font字体下的size
 
 @param string 字符串
 @param font 字体
 @return 字符串的size
 */
- (CGSize)getStringSize:(NSString*)string
                   font:(UIFont*)font;


/**
 获取字符串在指定要求下的大小和字体
 
 @param string 字符串
 @param font 字体
 @param minFontSize 最小字体大小
 @param actualFontSize 实际字体大小
 @param width 宽度
 @param lineBreakMode 换行模式
 @return 字符串大小
 */
- (CGSize)getStringsize:(NSString*)string
                   font:(UIFont *)font
            minFontSize:(CGFloat)minFontSize
         actualFontSize:(CGFloat *)actualFontSize
               forWidth:(CGFloat)width
          lineBreakMode:(NSLineBreakMode)lineBreakMode;

@end

NS_ASSUME_NONNULL_END
