//
//  BNCarRouteStepModel+Ext.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/20.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "BNCarRouteStepModel+Ext.h"
#import "NSAttributedString+Ext.h"
#import "CommonDefine.h"

@implementation BNCarRouteStepModel (Ext)

+ (NSAttributedString*)combinedTitleWithRoadName:(NSString*)roadname distance:(NSString*)distance{
    NSString * titlePart0 = roadname;
    NSString * titlePart1 = distance;
    
#ifndef NEED_HTML
    //线上会下发<b>roadname</b>，去掉
    if (titlePart0.length >= 7 && [[titlePart0 substringToIndex:3] isEqualToString:@"<b>"]) {
        titlePart0 = [titlePart0 substringWithRange:NSMakeRange(3, titlePart0.length-7)];
    }
#endif
    
    titlePart1 = [NSString stringWithFormat:@"\n%@",titlePart1];
    
    NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
    paragraphStyle.lineSpacing = 4;
    NSDictionary *attributes = @{ NSParagraphStyleAttributeName:paragraphStyle};
    NSMutableAttributedString *retAttrString = [[NSMutableAttributedString alloc] initWithString: titlePart0 attributes:attributes];
    [retAttrString ext_setFont: [UIFont systemFontOfSize: 15.0f]];
    
#ifdef NEED_HTML
    [OHASBasicHTMLParser processMarkupInAttributedString: retAttrString];
#endif
    
    NSMutableAttributedString *attr_titlePart1 = [[NSMutableAttributedString alloc] initWithString: titlePart1];
    [attr_titlePart1 ext_setFont: [UIFont systemFontOfSize: 14.0f]];
    [attr_titlePart1 ext_setTextColor:UIColorFromRGB(0x999999)];
    
    [retAttrString appendAttributedString:attr_titlePart1];
    
    return retAttrString;
}

-(NSAttributedString*)linkFormatTipDoubleLineAttrString{
    if (!self.linkFormatTip) {
        return nil;
    }
    NSArray * parts = [self.linkFormatTip componentsSeparatedByString:@","];
    //        NSLog(@"%@\n%@",parts[0],parts[1]);
    if (parts.count > 1) {
        NSString * titlePart0 = parts[0];
        NSString * titlePart1 = parts[1];
        
        return [self.class combinedTitleWithRoadName:titlePart0 distance:titlePart1];
    }
    else {
        NSString * titlePart0 = parts[0];
        
        return [self.class combinedTitleWithRoadName:titlePart0 distance:@""];
    }
}

@end
