//
//  WayPointPreferncerouteViewController.m
//  NaviDemo
//
//  Created by v_qinruiguang on 2021/6/3.
//  Copyright © 2021 v_qinruiguang. All rights reserved.
//
#import "BNNaviElderlyRoutePreferenceModel.h"
#import "WayPointPreferncerouteViewController.h"
#import "WayPointPrefernceTableViewCell.h"
#import "BNRoutePlanModel.h"
#import "BNaviService.h"
#import "BNaviModel.h"
#import "BNUtility.h"
#import "BNRoutePreferenceSelectView.h"
#import "BNCarRouteData.h"
#import "CommonDefine.h"
@interface WayPointPreferncerouteViewController ()<UITableViewDelegate, UITableViewDataSource, BNNaviUIManagerDelegate,BNNaviRoutePlanDelegate, BNaviViewDelegate, BNaviModelDelegate>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) UITableView *wayTableView;
@property (nonatomic, strong) UIButton *routeBtn;
@property (nonatomic, strong) UIButton *setCarNumber;
@property (nonatomic, strong) UIButton *editWayPointBtn;
@property (nonatomic) BN_NaviType naviType;
@property (nonatomic, strong) NSMutableArray  *dataArray;
@property (nonatomic, strong) NSMutableArray  *wayArray;
@property (nonatomic, assign) BOOL  isEdit;
@end

@implementation WayPointPreferncerouteViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.title = @"途经点偏好算路";
    
    [self _initData];
    [self _initView];
}
-(void)_initData {
    NSMutableArray *nodesArray = [[NSMutableArray alloc]initWithCapacity:2];
    //起点 传入的是原始的经纬度坐标，若使用的是百度地图坐标，可以使用BNTools类进行坐标转化
    CLLocation *myLocation = [BNaviService_Location getLastLocation];
    BNRoutePlanNode *startNode = [[BNRoutePlanNode alloc] init];
    startNode.pos = [[BNPosition alloc] init];
    startNode.routePlanMode = BNRoutePlanMode_MainRoad;
//    if (myLocation) {
//        startNode.pos.x = myLocation.coordinate.longitude;
//        startNode.pos.y = myLocation.coordinate.latitude;
//        startNode.pos.eType = BNCoordinate_OriginalGPS;
//    }
//    else {
        //113.950511,22.529978
//    113.951946,22.533318 //113.94765,22.549738
    startNode.pos.x = 113.94765;
    startNode.pos.y = 22.549738;
        startNode.pos.eType = BNCoordinate_BaiduMapSDK;
//    }
    [nodesArray addObject:startNode];
    
    //也可以在此加入1到3个的途经点113.948548,22.55179
//   113.946031,22.549945  113.942249,22.548229  113.943614,22.548241  //113.94524,22.549731 三道
    BNRoutePlanNode *midNode = [[BNRoutePlanNode alloc] init];
    midNode.pos = [[BNPosition alloc] init];
    midNode.pos.x = 113.942249;
    midNode.pos.y = 22.548229;
    midNode.pos.eType = BNCoordinate_BaiduMapSDK;
    
    BNRoutePlanNode *midNode2 = [[BNRoutePlanNode alloc] init];
    midNode2.pos = [[BNPosition alloc] init];
    midNode2.pos.x = 113.94524;
    midNode2.pos.y = 22.549731;
    midNode2.pos.eType = BNCoordinate_BaiduMapSDK;
//    midNode.routePlanMode = BNRoutePlanMode_SaveTime;
//    [nodesArray addObject:midNode];
    self.wayArray = [NSMutableArray array];
    [self.wayArray addObject:midNode2];
    [self.wayArray addObject:midNode];
    
    //终点 113.941079,22.546103
    BNRoutePlanNode *endNode = [[BNRoutePlanNode alloc] init];
    endNode.pos = [[BNPosition alloc] init];
    endNode.pos.x = 113.941079;
    endNode.pos.y = 22.546103;
    endNode.pos.eType = BNCoordinate_BaiduMapSDK;
    [nodesArray addObject:endNode];
    self.dataArray = nodesArray;
    [[BNaviModel getInstance] addNaviModelListener:self];
}
-(void)addAlertViewByIndex:(NSIndexPath *)index :(UITableView *)table {
    BNRoutePlanNode *startNode;
    UIAlertController *alertVc = [UIAlertController alertControllerWithTitle:@"修改经纬度" message:nil preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *cancelBtn = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        NSLog(@"取消");
    }];
    __weak typeof(self) weakSelf = self;
    UIAlertAction *sureBtn = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDestructive handler:^(UIAlertAction * _Nonnull action) {

        UITextField *startX = [alertVc.textFields objectAtIndex:0];
        UITextField *startY = [alertVc.textFields objectAtIndex:1];
        if (startX.text.length > 0) {
            BNRoutePlanNode *node;
            BNPosition *position = [[BNPosition alloc] init];
            if (table == weakSelf.tableView ){
                node = weakSelf.dataArray[index.section];
            } else {
                node = weakSelf.wayArray[index.row];
            }
            position.eType = node.pos.eType;
            position.y = [startY.text floatValue];
            position.x = [startX.text floatValue];
            node.pos = position;
            [weakSelf  tableReload];
        }

    }];
    //设置`确定`按钮的颜色
    [sureBtn setValue:[UIColor redColor] forKey:@"titleTextColor"];
    //将action添加到控制器
    [alertVc addAction:cancelBtn];
    [alertVc addAction :sureBtn];
    if ((table==self.tableView) &&index.section <2){
        startNode = self.dataArray[index.section];
    } else {
        startNode = self.wayArray[index.row];
    }
    

    [alertVc addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.placeholder = @"纬度";
        textField.text = [NSString stringWithFormat:@"%f", startNode.pos.x];
    }];
    [alertVc addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.placeholder = @"经度";
        textField.text = [NSString stringWithFormat:@"%f", startNode.pos.y];
    }];

    [self presentViewController:alertVc animated:YES completion:nil];
}
-(void)_initView {
    self.view.backgroundColor = [UIColor whiteColor];
    self.tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, 2*130+20*2) style:UITableViewStyleGrouped];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.rowHeight = 130;
    [self.tableView registerNib:[UINib nibWithNibName:@"WayPointPrefernceTableViewCell" bundle:nil] forCellReuseIdentifier:@"cell"];
    [self.view addSubview:self.tableView];
    self.tableView.sectionHeaderHeight = 20;
    self.tableView.tableFooterView = [UIView new];
    
    self.wayTableView = [[UITableView alloc] initWithFrame:CGRectMake(0, self.tableView.bottom, self.view.bounds.size.width, self.view.bounds.size.height - 50 - self.tableView.bottom) style:UITableViewStyleGrouped];
    self.wayTableView.delegate = self;
    self.wayTableView.dataSource = self;
    self.wayTableView.rowHeight = 130;
    [self.wayTableView registerNib:[UINib nibWithNibName:@"WayPointPrefernceTableViewCell" bundle:nil] forCellReuseIdentifier:@"cell"];
    [self.view addSubview:self.wayTableView];
    self.wayTableView.sectionHeaderHeight = 30;
    self.wayTableView.tableFooterView = [UIView new];
    
    
    self.routeBtn = [[UIButton alloc] init];
    [self.routeBtn setTitle:@"开始导航" forState:UIControlStateNormal];
    self.routeBtn.frame = CGRectMake(self.view.bounds.size.width/2, self.view.bounds.size.height - 50, self.view.bounds.size.width/2, 50);
    self.routeBtn.backgroundColor = UIColorFromRGBA(0xFF9966, 1);
    [self.routeBtn addTarget:self action:@selector(tapRouteBtn) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.routeBtn];
    self.routeBtn.layer.cornerRadius = 5;
    self.routeBtn.layer.masksToBounds = YES;
    
    self.setCarNumber = [[UIButton alloc] init];
    [self.setCarNumber setTitle:@"已经设置车牌" forState:UIControlStateSelected];
    [self.setCarNumber setTitle:@"未设置车牌" forState:UIControlStateNormal];
    self.setCarNumber.frame = CGRectMake(0, self.view.bounds.size.height - 50, self.view.bounds.size.width/2, 50);
    self.setCarNumber.backgroundColor = UIColorFromRGBA(0xFF6633, 1);
    [self.setCarNumber addTarget:self action:@selector(tapSetCarNumber:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.setCarNumber];
    self.setCarNumber.layer.cornerRadius = 5;
    self.setCarNumber.layer.masksToBounds = YES;
    
    
    [self.wayTableView setEditing:self.isEdit animated:YES];
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"+途经点" style:UIBarButtonItemStyleDone target:self action:@selector(addWayPoint)];
    
    
    // 2.给导航设置右边的barbuttonItem
    UIBarButtonItem *reginBarButtonItem = [[UIBarButtonItem alloc]initWithBarButtonSystemItem:UIBarButtonSystemItemAdd target:self action:@selector(addWayPoint)];
    self.navigationItem.rightBarButtonItem = reginBarButtonItem;
    
    UIBarButtonItem *style1 = [[UIBarButtonItem alloc]initWithBarButtonSystemItem:UIBarButtonSystemItemEdit target:self action:@selector(editWayPoint)];
    // 3.给右边设置多个barbuttonitem
    self.navigationItem.rightBarButtonItems = @[reginBarButtonItem,style1];

}

// 设置货车信息
- (void)setTruckInfo {
    BMTruckInfoModel *model = [[BMTruckInfoModel alloc] init];
    model.truckType = BMTruckTypeMedium;
    model.powerType = BMTruckPowerTypeGasoline;
    model.carNumber = @"京A66666";
    model.emission = 1 * 1000;
    model.weight = 2.565 * 1000;
    model.load = 1.73 * 1000;
    model.length = 6 * 1000;
    model.width = 2.15 * 1000;
    model.height = 3.5 * 1000;
    model.axleNumber = 2;
    model.plateColor = BNTruckPlateColorGreen;
    model.axleWeight = 2 * 1000;
    model.oilCost = 13;
    if (self.setCarNumber.isSelected) {
        [BNaviService_Strategy syncTruckInfoModel:model];
    } else {
        [BNaviService_Strategy syncTruckInfoModel:nil];
    }
    
    ///设置 货车用途
//    [BNaviService_Strategy syncTruckUse:BNaviTruckUse_Danger];
    
}
-(void)tapSetCarNumber:(UIButton*)sender {
    sender.selected = !sender.isSelected;
    
}
-(void)editWayPoint {
    self.isEdit = !self.isEdit;
    [self.wayTableView setEditing:self.isEdit animated:YES];
    [self tableReload];
    
}
-(void)addWayPoint {
    if (self.wayArray.count>0) {
        if (self.wayArray.count<18) {
            [self.wayArray addObject:[self.wayArray.lastObject copy]];
        } else {
            [self aleartView:@"最多18个途径点"];
        }
    } else {
        BNRoutePlanNode *midNode = [[BNRoutePlanNode alloc] init];
        midNode.pos = [[BNPosition alloc] init];
        midNode.pos.x = 113.977004;
        midNode.pos.y = 22.556393;
        midNode.pos.eType = BNCoordinate_BaiduMapSDK;
        midNode.routePlanMode = BNRoutePlanMode_Invalid;
        [self.wayArray addObject:midNode];
    }
    [self tableReload];
    NSIndexPath *indexpath = [NSIndexPath indexPathForRow:self.wayArray.count-1 inSection:0];
    [self.wayTableView scrollToRowAtIndexPath:indexpath atScrollPosition:UITableViewScrollPositionMiddle animated:YES];
}

-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    if (tableView == self.tableView) {
        return 2;
    } else {
        return 1;
    }
    
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if (self.tableView == tableView) {
        return 1;
    } else {
        return self.wayArray.count;
    }
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    WayPointPrefernceTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell" forIndexPath:indexPath];
    if (self.wayTableView == tableView) {
        cell.detBtn.hidden = NO;
        cell.detBtn.userInteractionEnabled = YES;
        cell.prefernceBtn.userInteractionEnabled = YES;
        cell.prefernceBtn.tag = indexPath.row;
        cell.detBtn.tag = indexPath.row;
        cell.node = self.wayArray[indexPath.row];
        [cell.detBtn addTarget:self action:@selector(tapDelBtn:) forControlEvents:UIControlEventTouchUpInside];
        [cell.prefernceBtn addTarget:self action:@selector(tapPrefernceBtn:) forControlEvents:UIControlEventTouchUpInside];
    } else {
        cell.node = self.dataArray[indexPath.section];
        if(indexPath.section==0){
            cell.prefernceBtn.tag = 2000;
            cell.prefernceBtn.userInteractionEnabled = YES;
            [cell.prefernceBtn addTarget:self action:@selector(tapPrefernceBtn:) forControlEvents:UIControlEventTouchUpInside];
        } else {
            cell.prefernceBtn.userInteractionEnabled = NO;
            cell.prefernceBtn.tag = 2001;
        }
        cell.detBtn.hidden = YES;
        cell.detBtn.userInteractionEnabled = NO;
    }
    return cell;
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [self addAlertViewByIndex:indexPath :tableView];
}

-(UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section {
    if (tableView == self.wayTableView) {
        UILabel *title = [[UILabel alloc] initWithFrame:CGRectMake(15, 10, 200, 20)];
        title.text = @"途经点";
        return title;
    } else {
        UILabel *title = [[UILabel alloc] initWithFrame:CGRectMake(15, 10, 200, 20)];
        if (section ==0) {
            title.text = @"起点";
        } else if (section == 1) {
            title.text = @"终点";
        } else {
            title.text = @"途经点";
        }
        return title;
    }
    
}
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    if (tableView == self.wayTableView) {
        return YES;
    } else {
        return NO;
    }
    
}


#pragma mark 选择编辑模式，添加模式很少用,默认是删除
-(UITableViewCellEditingStyle)tableView:(UITableView *)tableView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath {
    return UITableViewCellEditingStyleNone;
}

- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
    if (tableView == self.wayTableView) {
        return YES;
    } else {
        return  NO;
    }
}
#pragma mark 排序 当移动了某一行时候会调用//编辑状态下，只要实现这个方法，就能实现拖动排序
-(void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)sourceIndexPath toIndexPath:(NSIndexPath *)destinationIndexPath {
    // 取出要拖动的模型数据
    if (tableView == self.wayTableView) {
        BNRoutePlanNode *node = self.wayArray[sourceIndexPath.row];    //删除之前行的数据
        [self.wayArray removeObject:node];    // 插入数据到新的位置
        [self.wayArray insertObject:node atIndex:destinationIndexPath.row];
    }

}
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath{
    if (editingStyle ==UITableViewCellEditingStyleDelete && tableView == self.wayTableView) {//如果编辑样式为删除样式
        if (indexPath.row<[self.wayArray count]) {
            [self.wayArray removeObjectAtIndex:indexPath.row];//移除数据源的数据
            [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationLeft];//移除tableView中的数据
        }
    }
}
-(void)tapDelBtn:(UIButton *)sender {
    if (sender.tag < [self.wayArray count]) {
        [self.wayArray removeObjectAtIndex:sender.tag];//移除数据源的数据
        [self tableReload];
    }
}
-(void)tableReload {
    [self.wayTableView reloadData];
    [self.tableView reloadData];
}
-(void)tapPrefernceBtn:(UIButton *)sender {
    BNRoutePreferenceSelectView *prefernceSelectView = [[BNRoutePreferenceSelectView alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, self.view.bounds.size.height)];
    __weak typeof(self) weakSelf = self;
    prefernceSelectView.block = ^(NSDictionary *dict) {
        BNRoutePlanNode *node;
        if (sender.tag == 2000) {
            node = weakSelf.dataArray.firstObject;
        } else {
            node = weakSelf.wayArray[sender.tag];
        }
        if (dict) {
            BNNaviElderlyRoutePreferenceModel *model = dict[@"Data"];
            node.routePlanMode = model.preferenceType;
        }
        
        [weakSelf tableReload];
    };
    [self.view addSubview:prefernceSelectView];
    [prefernceSelectView show];
}

-(void)starRoute {
    BNaviService_Strategy.supportMoreSettings = YES;
    BNaviService_Strategy.multiplePreferenceEnable = YES;
    [BNaviService_RoutePlan setDisableOpenUrl:YES];
    BNaviService_Strategy.bottomButtonHeight = 0;
    BNaviService_Strategy.toolBarViewTopSpace = 0;
    BNaviService_Strategy.naviLocationOffset = 0;
    BNaviService_Strategy.showRrefreshRouteButton = YES;
    BN_NaviType naviType = BN_NaviTypeTruck;
    NSMutableArray *nodes = [NSMutableArray array];
    [nodes addObject:self.dataArray.firstObject];
    [nodes addObjectsFromArray:self.wayArray];
    [nodes addObject:self.dataArray.lastObject];
    [self setTruckInfo];
    [BNaviService_RoutePlan startNaviRoutePlan:BNRoutePlanMode_Recommend naviNodes:nodes time:nil delegete:self userInfo:@{BNaviTripTypeKey: @(naviType)}];
}

-(void)tapRouteBtn{
    [self starRoute];
}
#pragma mark - BNNaviRoutePlanDelegate
//算路成功回调
-(void)routePlanDidFinished:(NSDictionary *)userInfo {
    NSLog(@"算路成功");
    BNCarRouteModel *route = userInfo[BNDriveRouteDataKey];
    //路径规划成功，开始导航
    [BNaviService_UI showPage:BNaviUI_NormalNavi delegate:self extParams:@{BNaviUI_NormalNavi_TypeKey: @(BN_NaviTypeTruck)}]; // 货车导航
}

//算路失败回调
- (void)routePlanDidFailedWithError:(NSError *)error andUserInfo:(NSDictionary*)userInfo {
    switch ([error code]%10000) {
        case BNAVI_ROUTEPLAN_ERROR_LOCATIONFAILED:
            NSLog(@"暂时无法获取您的位置,请稍后重试");
            break;
        case BNAVI_ROUTEPLAN_ERROR_ROUTEPLANFAILED:
            NSLog(@"无法发起导航");
            break;
        case BNAVI_ROUTEPLAN_ERROR_LOCATIONSERVICECLOSED:
            NSLog(@"定位服务未开启,请到系统设置中打开定位服务。");
            break;
        case BNAVI_ROUTEPLAN_ERROR_NODESTOONEAR:
            NSLog(@"起终点距离起终点太近");
            break;
        default:
            NSLog(@"算路失败");
            break;
    }
}

//算路取消回调
-(void)routePlanDidUserCanceled:(NSDictionary*)userInfo {
    NSLog(@"算路取消");
}

-(void)onHandleNaviRouteWillChangedByType:(BNCalculateSourceType)type {
    NSLog(@"onHandleNaviRouteWillChangedByType-开始刷新");
    [self aleartView:[NSString stringWithFormat:@"onHandleNaviRouteWillChangedByType :%d", type]];
}
- (void)onHandleNaviRouteDidChangedByType:(BNCalculateSourceType)type node:(BNRoutePlanNode *)node  index:(int)index error:(NSError *)error {
    [self aleartView:@"onHandleNaviRouteDidChangedByType"];
    NSLog(@"更新完成");
    
}
///开始刷新路线
- (void)onHandleNaviRouteWillRefresh {
    [self aleartView:@"onHandleNaviRouteWillRefresh"];
    
}
///刷新路线返回刷新结果类型
- (void)onHandleNaviRouteDidRefreshWithType:(BNaviMessage_OtherRoute_Enum)type {
    [self aleartView:[NSString stringWithFormat:@"onHandleNaviRouteDidRefreshWithType:%d", type]];
    
}
-(void)aleartView:(NSString *)str {
    UIAlertController *alertVc = [UIAlertController alertControllerWithTitle:nil message:str preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *cancelBtn = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        NSLog(@"取消");
    }];
    [alertVc addAction:cancelBtn];
    [self presentViewController:alertVc animated:YES completion:nil];
    
}

@end
