//
//  WayPointPrefernceTableViewCell.m
//  NaviDemo
//
//  Created by v_qinruiguang on 2021/6/3.
//  Copyright © 2021 v_qinruiguang. All rights reserved.
//

#import "WayPointPrefernceTableViewCell.h"

@implementation WayPointPrefernceTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

-(void)setNode:(BNRoutePlanNode *)node {
    _node = node;
    self.xLab.text = [NSString stringWithFormat:@"%f", node.pos.x];
    self.yLab.text = [NSString stringWithFormat:@"%f", node.pos.y];
    ////先不用等引擎合入在开
    switch (node.routePlanMode) {
        case BNRoutePlanMode_Invalid:
        {
            [self.prefernceBtn setTitle:@"无效值" forState:UIControlStateNormal];
        }
            break;
        case BNRoutePlanMode_Recommend:
        {
            [self.prefernceBtn setTitle:@"推荐" forState:UIControlStateNormal];
        }
            break;
        case BNRoutePlanMode_NoHeighWay:
        {
            [self.prefernceBtn setTitle:@"不走高速" forState:UIControlStateNormal];
        }
            break;
        case BNRoutePlanMode_LessToll:
        {
            [self.prefernceBtn setTitle:@"少收费" forState:UIControlStateNormal];
        }
            break;
        case BNRoutePlanMode_LessJam:
        {
            [self.prefernceBtn setTitle:@"躲避拥堵" forState:UIControlStateNormal];
        }
            break;
        case BNRoutePlanMode_SaveTime:
        {
            [self.prefernceBtn setTitle:@"时间优先" forState:UIControlStateNormal];
        }
            break;
        case BNRoutePlanMode_MainRoad:
        {
            [self.prefernceBtn setTitle:@"高速优先" forState:UIControlStateNormal];
        }
            break;
        case BNRoutePlanMode_EconomicRoute:
        {
            [self.prefernceBtn setTitle:@"省钱路线" forState:UIControlStateNormal];
        }
            break;
        case BNRoutePlanMode_RoadFirst:
        {
            [self.prefernceBtn setTitle:@"距离最短" forState:UIControlStateNormal];
        }
            break;
        default:
            break;
    }
}

@end
