//
//  TruckGPSViewController.m
//  NaviDemo
//
//  Created by Lin,Biao on 2019/9/11.
//  Copyright © 2019 Baidu. All rights reserved.
//

#import "TruckGPSViewController.h"
#import "BNRoutePlanModel.h"
#import "BNaviService.h"
#import "BNaviModel.h"
#import "BNUtility.h"
#import "TruckConfigViewController.h"
#import "BNCarRouteData.h"
#import "BNaviFinishPageModel.h"
#import "CustomBottomBar.h"

@interface TruckGPSViewController ()<BNNaviUIManagerDelegate,BNNaviRoutePlanDelegate, BNaviViewDelegate, BNaviModelDelegate, UIAlertViewDelegate>
@property (nonatomic) BN_NaviType naviType;
@property (nonatomic, strong)NSMutableArray *nodesArray;
@property (nonatomic, strong)UILabel *startNodeLabel;
@property (nonatomic, strong)UILabel *endNodeLabel;

@property(nonatomic, assign)NSInteger beforDist; //超速前 距离 当前
@property(nonatomic, assign)NSInteger lastDist; //超速前 距离 上一次
@property(nonatomic, strong)UIAlertView *alertView;
@property(nonatomic, strong)CustomBottomBar *bottomView;


@end

@implementation TruckGPSViewController

- (void)dealloc {
    NSLog(@"TruckGPSViewController Dealloc");
}

- (UIButton*)createButton:(NSString*)title target:(SEL)selector frame:(CGRect)frame {
    UIButton* button = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    button.frame = frame;
    [button setTitle:title forState:UIControlStateNormal];
    [button setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7) {
        [button setBackgroundColor:[UIColor whiteColor]];
    }else
    {
        [button setBackgroundColor:[UIColor clearColor]];
    }
    [button addTarget:self action:selector forControlEvents:UIControlEventTouchUpInside];
    return button;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    BNaviService_Strategy.tapBarChartViewEnable = NO;
    BNaviService_Strategy.showAvoidJamEnable = NO;
    BNaviService_Strategy.showRrefreshRouteButton = YES;
    self.view.backgroundColor = [UIColor grayColor];
    self.title = @"货车GPS导航";
    
    UILabel* startNodeLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 130, self.view.frame.size.width, 30)];
    startNodeLabel.backgroundColor = [UIColor clearColor];
    startNodeLabel.text = @"起点：百度国际大厦";
    startNodeLabel.textAlignment = NSTextAlignmentCenter;
    startNodeLabel.autoresizingMask = UIViewAutoresizingFlexibleWidth;
    [self.view addSubview:startNodeLabel];
    self.startNodeLabel = startNodeLabel;
    UILabel* endNodeLabel = [[UILabel alloc] initWithFrame:CGRectMake(startNodeLabel.frame.origin.x, startNodeLabel.frame.origin.y+startNodeLabel.frame.size.height, self.view.frame.size.width, startNodeLabel.frame.size.height)];
    endNodeLabel.backgroundColor = [UIColor clearColor];
    endNodeLabel.text = @"终点：腾讯大厦";
    endNodeLabel.textAlignment = NSTextAlignmentCenter;
    endNodeLabel.autoresizingMask = UIViewAutoresizingFlexibleWidth;
    [self.view addSubview:endNodeLabel];
    self.endNodeLabel = endNodeLabel;
    CGSize buttonSize = {240,40};
    CGRect buttonFrame = {(self.view.frame.size.width-buttonSize.width)/2,40+endNodeLabel.frame.size.height+endNodeLabel.frame.origin.y,buttonSize.width,buttonSize.height};
    UIButton* realNaviButton = [self createButton:@"开始导航" target:@selector(realNavi:)  frame:buttonFrame];
    [self.view addSubview:realNaviButton];

    CGRect simbuttonFrame = {(self.view.frame.size.width-buttonSize.width)/2,CGRectGetMaxY(buttonFrame)+50,buttonSize.width,buttonSize.height};
    UIButton* simNaviButton = [self createButton:@"开始模拟导航" target:@selector(simNavi:)  frame:simbuttonFrame];
    [self.view addSubview:simNaviButton];
    
    CGRect goConfigButtonFrame = {(self.view.frame.size.width-buttonSize.width)/2,CGRectGetMaxY(simbuttonFrame) + 50 ,buttonSize.width,buttonSize.height};
    UIButton* goConfigButton = [self createButton:@"设置" target:@selector(goConfig)  frame:goConfigButtonFrame];
    [self.view addSubview:goConfigButton];
    
    CGRect updateButtonFrame = {(self.view.frame.size.width-buttonSize.width)/2,CGRectGetMaxY(goConfigButtonFrame) + 50 ,buttonSize.width,buttonSize.height};
    UIButton *updateNodeButton = [self createButton:@"更改起终点" target:@selector(addAlertView)  frame:updateButtonFrame];
    [self.view addSubview:updateNodeButton];
    
    CLLocationCoordinate2D wgs84llCoordinate = [BNaviService_Location getLastLocation].coordinate;
    //assign your coordinate here...
    
    CLLocationCoordinate2D bd09McCoordinate;
    //the coordinate in bd09MC standard, which can be used to show poi on baidu map
    bd09McCoordinate = [BNUtility convertToBD09MCWithWGS84ll:wgs84llCoordinate];
    
    [[BNaviModel getInstance] addNaviViewListener:self];
    [[BNaviModel getInstance] addNaviModelListener:self];
//    [BNaviModel getInstance].exitNaviFromExternal = YES;
    [self setTruckInfo];
    [self setBaseNodes];
    BNaviService_Strategy.yawSpecifiedRouteNavigation = 1;
    self.lastDist = -1;
    [self setBaseNodes];
    /// 超速回调需要将当前的VC继承代理 BNaviModelDelegate  添加到listener 才能使用。
}

- (BOOL)checkServicesInited {
    if(![BNaviService_Instance isServicesInited]) {
        UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"提示"
                                                            message:@"引擎尚未初始化完成，请稍后再试"
                                                           delegate:nil
                                                  cancelButtonTitle:@"我知道了"
                                                  otherButtonTitles:nil];
        [alertView show];
        return NO;
    }
    return YES;
}

- (void)onHandleGPSSpeedChange:(BNKMNaviSpeed *)speed speedLimit:(int)speedLimit {
    ////超过一公里 超速就提示一下。
    if (speed.speed > speedLimit) {
        if (self.lastDist == -1 || ((self.lastDist - self.beforDist) >= 300)) {
            @synchronized (self) {
                self.lastDist = self.beforDist;
            }
            
            [self onHandleSpeedLimit];
        }
        
    }
       
}

-(void)onHandleRemainInfo:(BNaviRemainInfo *)remainInfo {
    self.beforDist = remainInfo.remainDist;
    NSLog(@"当前已经行驶的 距离%ld", (long)remainInfo.remainDist);
    
    
}
-(void)onHandleSpeedLimit {
    NSLog(@"超速");
}

//真实GPS导航
- (void)realNavi:(UIButton*)button {
    if (![self checkServicesInited]) return;
    [self startNavi];
}

- (void)simNavi:(UIButton*)button {
    if (![self checkServicesInited]) return;
    [self startNaviReal:NO];
}

- (void)startNavi{
    [self startNaviReal:YES];
}
-(void)setBaseNodes {
    BOOL useMyLocation = NO;
    NSMutableArray *nodesArray = [[NSMutableArray alloc]initWithCapacity:2];
    //起点 传入的是原始的经纬度坐标，若使用的是百度地图坐标，可以使用BNTools类进行坐标转化
    CLLocation *myLocation = [BNaviService_Location getLastLocation];
    BNRoutePlanNode *startNode = [[BNRoutePlanNode alloc] init];
    startNode.pos = [[BNPosition alloc] init];
    startNode.routePlanMode = BNRoutePlanMode_MainRoad;
    if (useMyLocation) {
        startNode.pos.x = myLocation.coordinate.longitude;
        startNode.pos.y = myLocation.coordinate.latitude;
        startNode.pos.eType = BNCoordinate_OriginalGPS;
    }
    else {
        //113.949298,22.530242
        startNode.pos.x = 113.949298;
        startNode.pos.y = 22.530242;
        startNode.pos.eType = BNCoordinate_BaiduMapSDK;
    }
    [nodesArray addObject:startNode];
    
    //终点：腾讯大厦
    BNRoutePlanNode *endNode = [[BNRoutePlanNode alloc] init];
    endNode.pos = [[BNPosition alloc] init];
    //113.941079,22.546103
    endNode.pos.x = 113.941079;
    endNode.pos.y = 22.546103;
    endNode.pos.eType = BNCoordinate_BaiduMapSDK;
    [nodesArray addObject:endNode];
    
    BNaviService_Strategy.showNaviToolbox = YES;
    
    //ui的展示/不展示
    BNaviService_Strategy.supportMoreSettings = YES;
    BNaviService_Strategy.supportUGCReportButton = YES;
    
    //NSString *json = @"{\"version\":\"0.1\",\"errorcode\":0,\"content\":{\"scene_array\":{\"scene_open_roadcondition\":{\"statistics_key\":\"scene_open_roadcondition\",\"scene_type\":1,\"stratgies\":{\"userop\":{\"op_seq\":\"asr_e_c_open_roadcondition\",\"overtime\":60,\"delay\":5},\"frequency\":{\"lifetime\":0},\"speak\":{\"priority\":1}},\"action\":{\"order\":\"common_speak_voice\",\"params\":{\"tts\":\"导航中更换目的地可以直接说,小度小度,更换目的地为[[]]\",\"data_id\":\"rp_endnode_name\"}}}},\"frequency\":{\"common_type\":{\"timediff\":10,\"one_day\":0,\"once_navi\":0},\"click_type\":{\"timediff\":10,\"once_day\":0,\"once_navi\":0}}}}";
//    NSString *json = @"{\"from\":\"liangzhiyuan\"}";
    NSString *extraInfo = @"eyJzZXNzaW9uX2lkIjoiYTI3MzQ3ZDhiYTNiOWFhOTRmMTYyM2MzNmViY2Q2NDEiLCJsb2MiOiJvdGhlciIsInRyYWNrcHRzX2Rpc3RhbmNlcyI6WzE1NzgwOCwxMzgzMTRdfQ";
    //关闭openURL,不想跳转百度地图可以设为YES
    
    
//    BNaviService_MapOverlay.delegate = self;
//    BNaviService_MapOverlay.dataSource = self;
    self.nodesArray = [NSMutableArray arrayWithArray:nodesArray];
}
- (void)startNaviReal:(BOOL)isReal {
    
//    //自定义算路环境
//    BNaviService_RoutePlan.customRoutePlanUrl = @"http://112.34.111.141:80/phpui2/?rewriteid=tt&";
    
    
   
    [self starRoute:isReal];
}

-(void)starRoute:(BOOL)isReal {
    [BNaviService_RoutePlan setDisableOpenUrl:YES];
    BN_NaviType naviType = BN_NaviTypeTruck;
    if (!isReal) {
        naviType = BN_NaviTypeTruckSimulator;
    }
    _naviType = naviType;
    /*
    BNTripManagerTimeModel *beginModel = [[BNTripManagerTimeModel alloc] init];
    beginModel.nYear = 2021;
    beginModel.nMonth = 9;
    beginModel.nDay = 24;
    beginModel.nHour = 10;
    beginModel.nMinute = 0;
     */
    [self setBaseNodes];
    [BNaviService_RoutePlan startNaviRoutePlan:BNRoutePlanMode_Recommend naviNodes:self.nodesArray time:nil delegete:self userInfo:@{BNaviTripTypeKey: @(naviType)}];
}
// 设置货车信息
- (void)setTruckInfo {
    BMTruckInfoModel *model = [[BMTruckInfoModel alloc] init];
    model.truckType = BMTruckTypeMedium;
    model.powerType = BMTruckPowerTypeGasoline;
    model.carNumber = @"京A66666";
    model.emission = 6;
    model.weight = 2.565 * 1000;
    model.load = 1.73 * 1000;
    model.length = 6 * 1000;
    model.width = 2.15 * 1000;
    model.height = 3.5 * 1000;
    model.axleNumber = 2;
    model.plateColor = BNTruckPlateColorGreen;
    model.axleWeight = 2 * 1000;
    model.oilCost = 13;
    [BNaviService_Strategy syncTruckInfoModel:model];
    ///设置 货车用途
    [BNaviService_Strategy syncTruckUse:BNaviTruckUse_Danger];
    
}
-(void)addAlertView {
    UIAlertController *alertVc = [UIAlertController alertControllerWithTitle:@"输入起终点经纬度" message:nil preferredStyle:UIAlertControllerStyleAlert];
    //默认只有标题 没有操作的按钮:添加操作的按钮 UIAlertAction
    
    UIAlertAction *cancelBtn = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        NSLog(@"取消");
    }];
    //添加确定
    UIAlertAction *sureBtn = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDestructive handler:^(UIAlertAction * _Nonnull action) {
        
        UITextField *startX = [alertVc.textFields objectAtIndex:0];
        UITextField *startY = [alertVc.textFields objectAtIndex:1];
        UITextField *endX = [alertVc.textFields objectAtIndex:2];
        UITextField *endY = [alertVc.textFields objectAtIndex:3];
        if (startX.text.length > 0) {
            BNRoutePlanNode *startNode = self.nodesArray.firstObject;
            startNode.pos.x = [startX.text floatValue];
            startNode.pos.y = [startY.text floatValue];
            self.startNodeLabel.text = [NSString stringWithFormat:@"起点: %f-%f", [startX.text floatValue], [startY.text floatValue]];
            if (self.nodesArray.count > 1) {
                [self.nodesArray replaceObjectAtIndex:0 withObject:startNode];
            } else {
                [self.nodesArray addObject:startNode];
            }
            
        }
        if (endX.text.length > 0) {
            BNRoutePlanNode *endNode = self.nodesArray.lastObject;
            endNode.pos.x = [endX.text floatValue];
            endNode.pos.y = [endY.text floatValue];
            self.endNodeLabel.text = [NSString stringWithFormat:@"终点: %f-%f", [endX.text floatValue], [endY.text floatValue]];
            [self.nodesArray replaceObjectAtIndex:self.nodesArray.count-1 withObject:endNode];
        }
        
        
    }];
    //设置`确定`按钮的颜色
    [sureBtn setValue:[UIColor redColor] forKey:@"titleTextColor"];
    //将action添加到控制器
    [alertVc addAction:cancelBtn];
    [alertVc addAction :sureBtn];
    BNRoutePlanNode *startNode = self.nodesArray.firstObject;
    BNRoutePlanNode *endNode = self.nodesArray.lastObject;
    [alertVc addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.placeholder = @"起点:纬度";
        textField.text = [NSString stringWithFormat:@"%f", startNode.pos.x];
    }];
    [alertVc addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.placeholder = @"起点:经度";
        textField.text = [NSString stringWithFormat:@"%f", startNode.pos.y];
    }];
    
    [alertVc addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.placeholder = @"终点:纬度";
        textField.text = [NSString stringWithFormat:@"%f", endNode.pos.x];
    }];
    [alertVc addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.placeholder = @"终点:经度";
        textField.text = [NSString stringWithFormat:@"%f", endNode.pos.y];
    }];
    [self presentViewController:alertVc animated:YES completion:nil];
}

#pragma mark - BNNaviRoutePlanDelegate
//算路成功回调
-(void)routePlanDidFinished:(NSDictionary *)userInfo {
    NSLog(@"算路成功");
    
    BNCarRouteModel *route = userInfo[BNDriveRouteDataKey];
    
    //路径规划成功，开始导航
    BNaviService_Strategy.naviLocationOffset = 0;
    BNaviService_Strategy.bottomButtonHeight = 0;
    BNaviService_Strategy.toolBarViewTopSpace = 0;
    [BNaviService_UI showPage:BNaviUI_NormalNavi delegate:self extParams:@{BNaviUI_NormalNavi_TypeKey: @(_naviType)}]; // 货车导航
//    [BNaviService_UI showPage:BNaviUI_NormalNavi delegate:self extParams:@{BNaviUI_NormalNavi_TypeKey: @(BN_NaviTypeTruckSimulator)}]; // 货车模拟导航
}

//算路失败回调
- (void)routePlanDidFailedWithError:(NSError *)error andUserInfo:(NSDictionary*)userInfo {
    switch ([error code]%10000) {
        case BNAVI_ROUTEPLAN_ERROR_LOCATIONFAILED:
            NSLog(@"暂时无法获取您的位置,请稍后重试");
            break;
        case BNAVI_ROUTEPLAN_ERROR_ROUTEPLANFAILED:
            NSLog(@"无法发起导航");
            break;
        case BNAVI_ROUTEPLAN_ERROR_LOCATIONSERVICECLOSED:
            NSLog(@"定位服务未开启,请到系统设置中打开定位服务。");
            break;
        case BNAVI_ROUTEPLAN_ERROR_NODESTOONEAR:
            NSLog(@"起终点距离起终点太近");
            break;
        default:
            NSLog(@"算路失败");
            break;
    }
}

//算路取消回调
-(void)routePlanDidUserCanceled:(NSDictionary*)userInfo {
    NSLog(@"算路取消");
}

#pragma mark - 安静退出导航

- (void)exitNaviUI {
    [BNaviService_UI exitPage:EN_BNavi_ExitTopVC animated:YES extraInfo:nil];
}

#pragma mark - BNNaviUIManagerDelegate

//退出导航页面回调
- (void)willExitPage:(BNaviUIType)pageType  extraInfo:(NSDictionary*)extraInfo{
    if (pageType == BNaviUI_NormalNavi) {
        NSLog(@"退出导航");
    } else if (pageType == BNaviUI_Declaration) {
        NSLog(@"退出导航声明页面");
    }
}

- (void)onExitPage:(BNaviUIType)pageType  extraInfo:(NSDictionary*)extraInfo {
    if (pageType == BNaviUI_NormalNavi) {
        NSLog(@"退出导航");
    } else if (pageType == BNaviUI_Declaration) {
        NSLog(@"退出导航声明页面");
    }
}

//自定义货车底部BottomBarView
- (UIView *)naviBottomBarView {
//    return self.bottomView;
    return nil;
}

- (CustomBottomBar *)bottomView {
    if (!_bottomView) {
        CustomBottomBar *view = [[CustomBottomBar alloc]initWithFrame:CGRectZero];
        _bottomView = view;
    }
    return _bottomView;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation {
    return NO;
}

- (BOOL)shouldAutorotate {
    return NO;
}

- (NSUInteger)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait;
}

- (void)goConfig{
    TruckConfigViewController * configVC = [[TruckConfigViewController alloc] init];
    [self presentViewController:configVC animated:YES completion:nil];
}

/**
 *  刷新按钮点击事件回调
 */
- (void)onHandleViewRecalculateButtonDidTap{
    NSLog(@"onHandleViewRecalculateRouteButtonDidTap in TruckGPSViewController");
    
    //BNaviService_MapView projectionInStepList:<#(NSArray *)#> point:<#(id)#> resultIndex:<#(nonnull int *)#>
}

- (void)onHandleMapRefresh:(BNaviMapRefreshInfo*)mapRefreshInfo{

}

- (void)onHandleExitButtonDidTap{
    NSLog(@"onHandleExitButtonDidTap");
}

- (BOOL)shouldOverrideExitingPage:(BNavi_ExitPage_Type)exitType  extraInfo:(NSDictionary*)extraInfo{
    NSLog(@"shouldOverrideExitingPage %d", exitType);
    return YES;
}

- (void)overrideExitingPage:(BNavi_ExitPage_Type)exitType animated:(BOOL)animated extraInfo:(NSDictionary*)extraInfo{
    NSLog(@"overrideExitingPage %d", exitType);
    [BNaviService_UI continueExitPage:EN_BNavi_ExitTopVC animated:animated extraInfo:nil];
}

- (void)onHandleGuideViewTurnIconDidTap{
    NSDictionary *naviInfo = [BNaviFinishPageModel naviInfo];
    
//    UIViewController *naviVC = [BNaviModel getInstance].naviViewController;
//    UIView *rightContentView =  [naviVC performSelector:@selector(rightContentView)];
//    UIView *refreshView = [rightContentView performSelector:@selector(recalculateButtonView)];
//    NSLog(@"refresh button hidden %d, superView %@, frame %@", refreshView.hidden, refreshView.superview, NSStringFromCGRect(refreshView.frame));
    
//    [[DynamicOverlayDemo getInstance] startUpdateLocation];

    /*
    if(!_polygonOverlay){
        BNaviOverlayPolygon *aPoly = [[BNaviOverlayPolygon alloc] init];
        
        NSMutableArray *arr = [NSMutableArray array];
        
        [arr addObject:[BNaviOverlayCoordinate coordinateWithLatitude:22.5459 longitude:113.9256]];  //南山-嘉南美地
        [arr addObject:[BNaviOverlayCoordinate coordinateWithLatitude:22.5483 longitude:113.9729]];
        [arr addObject:[BNaviOverlayCoordinate coordinateWithLatitude:22.5393 longitude:113.9748]];
        [arr addObject:[BNaviOverlayCoordinate coordinateWithLatitude:22.5270 longitude:113.9556]];
        [arr addObject:[BNaviOverlayCoordinate coordinateWithLatitude:22.5177 longitude:113.9134]];
        
        aPoly.coords = arr;
        
        aPoly.strokeColor = [[UIColor alloc] initWithRed:0.0 green:0 blue:0.5 alpha:1];
        aPoly.fillColor = [[UIColor alloc] initWithRed:0 green:1 blue:1 alpha:0.2];
        aPoly.lineWidth = 2.0;
        
        [BNaviService_MapOverlay addPolygon:aPoly];
        _polygonOverlay = aPoly;
    }
    else {
        [BNaviService_MapOverlay removePolygon:_polygonOverlay];
        _polygonOverlay = nil;
    }
    */
    
}
/*
- (void)didTapOverlayPolygon:(BNaviOverlayPolygon *)polygon atCoordinate:(CLLocationCoordinate2D)coordinate{
    BNKMPointAnnotation *pointAnnotation = [[BNKMPointAnnotation alloc] init];
//    CLLocationCoordinate2D coor;
//    coor.latitude = 39.915;
//    coor.longitude = 116.404;
    pointAnnotation.coordinate = coordinate;
    pointAnnotation.title = @"test";
    pointAnnotation.subtitle = @"点击结束等待乘客";

    [BNaviService_MapOverlay addAnnotation:pointAnnotation];
    
    [BNaviService_MapView setMapCenterWithBaiduCoordinate:coordinate animated:YES];
}

- (void)addMapItemAtCoordinate:(CLLocationCoordinate2D)coordinate{
    BNPosition *pos = [BNPosition positionFromCoordinate:coordinate];
    pos.eType = BNCoordinate_BaiduMapSDK;
    if (!_itemData) {
        _itemData = [BNaviMapItemData itemWithImage:[UIImage imageNamed:@"icon_waterdrop_blue"] position:pos xAlign:0.5 yAlign:0.5 name:@"didademo_position"];
        [BNaviService_MapOverlay setItemOverlayData:@[_itemData]];
        [BNaviService_MapOverlay show:YES];
    }
}

- (BNKMAnnotationView *)viewForAnnotation:(id<BNKMAnnotation>)annotation{
    static NSString *AnnotationViewID = @"renameMark";
    BNKMPinAnnotationView *annotationView = [[BNKMPinAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:AnnotationViewID];
    annotationView.image = [UIImage imageNamed:@"pin_green"];
    
    [annotationView addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(didTapAnnotationView:)]];
    
    return annotationView;
}

- (void)didTapAnnotationView:(UITapGestureRecognizer *)tap{
    BNKMPinAnnotationView *annotationView = tap.view;
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"annotationView" message:@"" preferredStyle:UIAlertControllerStyleActionSheet];
    [alert addAction:[UIAlertAction actionWithTitle:@"移除" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [BNaviService_MapOverlay removeAnnotation:annotationView.annotation];
    }]];
    [alert addAction:[UIAlertAction actionWithTitle:@"退出" style:UIAlertActionStyleDestructive handler:^(UIAlertAction * _Nonnull action) {
        [alert dismissViewControllerAnimated:YES completion:nil];
    }]];
    
    [self.getTopViewController presentViewController:alert animated:YES completion:nil];
}
*/
- (UIViewController *)getTopViewController {
    UIViewController *topViewController = [[[[UIApplication sharedApplication] delegate] window] rootViewController];
    while (topViewController.presentedViewController) topViewController = topViewController.presentedViewController;

    return topViewController;
}

- (void)naviYawingDidStart:(BNaviModel *)model withStamp:(NSString *)yawingStamp{
    
    NSLog(@"naviYawingDidStart, stamp = %@", yawingStamp);
    NSArray *yawEvents = [BNaviService_RoutePlan getLeftRoadEventForYaw];
    NSString *message = @"原因:";
    NSString *title = nil;
    for (int i = 0; i<yawEvents.count; i++) {
        BNaviRouteEventItemModel *model = yawEvents[i];
        message = [NSString stringWithFormat:@"%@-%@", message, model.eventStr];
        
    }
//    title = [NSString stringWithFormat:@"偏航类型共有%d个", yawEvents.count];
//    UIAlertView *alert = [[UIAlertView alloc]initWithTitle:title
//                                                   message:message
//                                                  delegate:self
//                                         cancelButtonTitle:@"确定"
//                                         otherButtonTitles:nil];
//    if (yawEvents.count>0) {
//        [alert show];
//    }
    
    self.lastDist = -1;
}

/// 货车限行标识（限高，限重等）显示
/// @param msgParam <#msgParam description#>
- (void)onHandleTruckTrafficSignShow:(BNaviTruckTrafficSignInfo *)msgParam{
    NSLog(@"onHandleTruckTrafficSignShow, type = %d, distance = %d", msgParam.trafficSignType, msgParam.remainDistance);
}

/// 货车限行标识（限高，限重等）更新
/// @param msgParam <#msgParam description#>
- (void)onHandleTruckTrafficSignUpdate:(BNaviTruckTrafficSignInfo *)msgParam{
    NSLog(@"onHandleTruckTrafficSignUpdate, type = %d, distance = %d", msgParam.trafficSignType, msgParam.remainDistance);
}

/// 货车限行标识（限高，限重等）隐藏
/// @param msgParam <#msgParam description#>
- (void)onHandleTruckTrafficSignHide:(BNaviTruckTrafficSignInfo *)msgParam{
    NSLog(@"onHandleTruckTrafficSignHide, type = %d, distance = %d", msgParam.trafficSignType, msgParam.remainDistance);
}

- (void)onHandlePassViaPoint:(BNaviPassViaPointInfo *)passViaInfo {
    NSLog(@"经过途经点 eType %d --- viaIndex= %d",passViaInfo.enType, passViaInfo.viaIndex);
}
/**
 *  处理高速面板消息
 *
 *  @param highWayBoard 高速面板消息类型
 */
- (void)onHandleHighWayBoard:(BNaviHighwayBoard*)highWayBoard {
    
    NSLog(@"高速服务区名称---%@", highWayBoard.highwaySAName);
    
}
@end
