//
//  TruckConfigViewController.m
//  NaviDemo
//
//  Created by Liang,Zhiyuan(GIS)2 on 2020/2/16.
//  Copyright © 2020 Baidu. All rights reserved.
//

#import "TruckConfigViewController.h"

#import "BNRoutePlanModel.h"
#import "BNaviService.h"
#import "BNaviModel.h"
#import "BNUtility.h"

@interface TruckConfigSwitch : UISwitch

@property (nonatomic) int index;

@end

@implementation TruckConfigSwitch

@end

@interface TruckConfigViewController () <UITableViewDelegate, UITableViewDataSource>

@property (nonatomic) UITableView *tableView;

@property (nonatomic) NSArray<NSArray<NSString *> *> *configArray;

@end

@implementation TruckConfigViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.view.backgroundColor = [UIColor whiteColor];
    UIButton * btnClose = [UIButton buttonWithType:UIButtonTypeSystem];
    [btnClose setTitle:@"退出" forState:UIControlStateNormal];
    [btnClose setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    btnClose.frame = CGRectMake(50, 30, 60, 40);
    [btnClose addTarget:self action:@selector(didTapClose) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btnClose];
    
    _tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 80, self.view.bounds.size.width, self.view.bounds.size.height - 60)];
    [self.view addSubview:_tableView];
    
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    _configArray = @[
        @[@"supportMoreSettings", @"是否支持更多设置功能"],
        @[@"showCurrentRoadName", @"是否显示当前路名"],
        @[@"showLanesView", @"是否显示车道线"],
        @[@"showIntervalSpeedView", @"是否显示区间测速"],
        @[@"showHighwayInfoPanel", @"是否显示高速信息面板"],
        @[@"showExitDirectionPanel", @"是否显示出口方向面板"],
        @[@"showMainAuxiliaryButton", @"是否显示主辅路切换"],
        @[@"showNaviToolbox", @"是否显示导航工具箱"],
        @[@"showRoadConditionButton", @"是否显示路况开关"],
        @[@"showMuteButton", @"是否显示声音模式选择"],
        @[@"showRrefreshRouteButton", @"是否显示路线刷新"],
        @[@"showZoomButton", @"是否显示缩放按钮"],
        @[@"supportTruckRestrictionView", @"是否显示货车限行标识"],
        @[@"supportSimulatorSpeedControl", @"是否显示模拟器速度控制按钮"],
        @[@"supportSimulatorPauseButton", @"是否显示模拟器暂停按钮"],
        @[@"supportRoadConditionBar", @"是否显示路况条"],
        @[@"supportViewAllButton", @"是否显示全览按钮"],
    ];
}

- (void)didTapClose{
    [self dismissViewControllerAnimated:YES completion:nil];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return 40;
}

- (nonnull UITableViewCell *)tableView:(nonnull UITableView *)tableView cellForRowAtIndexPath:(nonnull NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"tableViewCell"];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"tableViewCell"];
    }
    cell.textLabel.text = _configArray[indexPath.row][1];
    
    float switchX = self.tableView.frame.size.width/2;
    
    const static int switchTag = 666;
    TruckConfigSwitch *aSwitch = [cell viewWithTag:switchTag];
    if (!aSwitch) {
        aSwitch = [[TruckConfigSwitch alloc] initWithFrame:CGRectMake(switchX + 40, 5, 60, 30)];
        [cell addSubview:aSwitch];
        
        [aSwitch addTarget:self action:@selector(switchDidChanged:) forControlEvents:UIControlEventValueChanged];
    }
    
    aSwitch.index = indexPath.row;
    
    NSString *selectorString = _configArray[indexPath.row][0];
    id inst = BNaviService_Strategy;
    SEL selector = NSSelectorFromString(selectorString);
    BOOL on = [inst performSelector:selector];
    aSwitch.on = on;

    return cell;
}

- (NSInteger)tableView:(nonnull UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _configArray.count;
}

- (void)switchDidChanged:(UIControl *)control{
    TruckConfigSwitch *aSwt = control;
    
    NSString *selectorString = _configArray[aSwt.index][0];
    id inst = BNaviService_Strategy;
    
    [inst setValue:@(aSwt.isOn) forKey:selectorString];
}

@end
