//
//  LocationManager.m
//  NaviSDKDemo
//
//  Created by chenxintao on 2018/6/22.
//  Copyright © 2018年 李择一. All rights reserved.
//

#import "DynamicOverlayDemo.h"
#import "BNaviService.h"

@interface DynamicOverlayDemo()<CLLocationManagerDelegate>

@property (strong, nonatomic) CLLocationManager* locationManager;

//@property (strong, nonatomic) BNaviMapItemData* itemData;

@end

@implementation DynamicOverlayDemo

+ (instancetype)getInstance
{
    static DynamicOverlayDemo* shareManager = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        shareManager = [[DynamicOverlayDemo alloc] init];
    });
    return shareManager;
}

- (instancetype)init
{
    if (self = [super init])
    {
        _locationManager = [[CLLocationManager alloc] init];
        _locationManager.delegate = self;
        _locationManager.desiredAccuracy = kCLLocationAccuracyBest;
        
//        BNaviService_MapOverlay.delegate = self;
    }
    return self;
}

//- (BNaviMapItemData*)itemData
//{
//    if (!_itemData)
//    {
//        BNPosition* position = [[BNPosition alloc] init];
//        position.eType = BNCoordinate_OriginalGPS;
//        _itemData = [BNaviMapItemData itemWithImage:[UIImage imageNamed:@"icon_waterdrop_blue"] position:position xAlign:0.5 yAlign:0.5 name:@"didademo_position"];
//
//        _itemData.hotPointRect = CGRectMake(0, 0, 30, 30);
//    }
//    return _itemData;
//}

- (void)startUpdateLocation
{
    [self.locationManager startUpdatingLocation];
}

- (void)stopUpdateLocation
{
    [self.locationManager stopUpdatingLocation];
//    if (_itemData)
//    {
//        [BNaviService_MapOverlay removeOneItemOfLayer:_itemData];
//    }
}

- (void)locationManager:(CLLocationManager *)manager didFailWithError:(NSError *)error
{
    NSLog(@"locationManager didFailWithError: %@", error);
}

- (void)locationManager:(CLLocationManager *)manager didUpdateLocations:(NSArray<CLLocation *> *)locations
{
    if (!locations.count)
        return;
    self.lastLocation = locations[locations.count - 1];
    
//    if (!_itemData)
//    {
//        self.itemData.pos.x = self.lastLocation.coordinate.longitude;
//        self.itemData.pos.y = self.lastLocation.coordinate.latitude;
//        [BNaviService_MapOverlay setItemOverlayData:@[_itemData]];
//        [BNaviService_MapOverlay show:YES];
//    }
//    else
//    {
//        self.itemData.pos.x = self.lastLocation.coordinate.longitude;
//        self.itemData.pos.y = self.lastLocation.coordinate.latitude;
//        [BNaviService_MapOverlay updateItemOverlayData:@[_itemData]];
//    }
}

//- (void)didTouchOverlayMapItem:(BNaviMapItemData *)itemData{
//    NSLog(@"touche item :%@", itemData);
//}

@end
