//
//  DriverTruckViewController.m
//  NaviDemo
//
//  Created by v_qinruiguang on 2022/1/14.
//  Copyright © 2022 v_qinruiguang. All rights reserved.
//

#import "DriverTruckViewController.h"
#import "BNNaviElderlyRoutePreferenceModel.h"
#import "DrivePageViewController.h"
#import "BNRoutePlanModel.h"
#import "BNaviService.h"
#import "CommonDefine.h"
#import "RouteContentView.h"
#import "RadarSwitchView.h"
#import "RadarLocationView.h"
////未来出行
#import "BNDatePickerViewController.h"
#import "NSDate+BNFutureTrip.h"
#import "BNCustomYellowTips.h"
#import "BNRoutePreferenceSelectView.h"

#import "BNCustomYellowTips.h"
#import "BNCommonDef.h"

#define kPanelHeight        (ADAPTOR_VALUE_750(302) + SAFE_AREA_INSETS_BOTTOM) //底部面板显示区域高度
#define kPanelLessHeight    (ADAPTOR_VALUE_750(266) + SAFE_AREA_INSETS_BOTTOM)
#define kLeftOffset         (CR_MAP_VIEW_ENTRANCE_RIGHT_MARGIN+4+1)

@interface DriverTruckViewController () <BNNaviRoutePlanDelegate, BNDriveRouteManagerDelegate, RadarLocationViewDelegate, BNNaviUIManagerDelegate, BMKMapViewDelegate, BNDatePickerViewControllerDelegate, BMDRYellowTipsStrategyManagerDataSource>

@property (nonatomic, assign) BNRoutePlanMode strategy;
@property (nonatomic, strong) RouteContentView *contentView;
@property (nonatomic, strong) RadarSwitchView *radarSwitchView;
@property (nonatomic, strong) RadarLocationView *radarLocationView;
@property (nonatomic, strong) UIView *logoView;
@property (nonatomic, strong) UIButton *tripBtn; //未来出行

@property (nonatomic, strong) UIButton *tripSelectTimeBtn; //未来出行 开始时间
@property (nonatomic, strong) NSDate *selectDate; //未来出行 开始时间
///存放小黄条的外部view
@property (nonatomic, strong) UIView *customYellowTipsBgVew;

@property (nonatomic, strong) UIButton *prefernceBtn; //选择偏航 按钮

@property (nonatomic, strong) BNRoutePreferenceSelectView *prefernceSelectView;


@property (nonatomic, strong) UIView *myYellowTipsView;

@property (nonatomic, strong) UIButton *delYellowTipsView;

@property (nonatomic, strong) UIButton *truckNaviSetCarNumber; // 货车 是否设置车牌

@property (nonatomic, assign) BOOL isExitNavi;

@end

@implementation DriverTruckViewController

- (void)dealloc {
    [BNaviService_DriveRoute stopUpdateLocation];
    NSLog(@"DrivePageViewController Dealloc");
}
// 设置货车信息
- (void)setTruckInfo {
    
    BMTruckInfoModel *model = [[BMTruckInfoModel alloc] init];
    model.truckType = BMTruckTypeHeavy;
    model.powerType = BMTruckPowerTypeGasoline;
    model.carNumber = @"粤B66645";
    model.emission = 6;
    model.weight = 70 * 1000;
    model.load = 100 * 1000;
    model.length = 20 * 1000;
    model.width = 4 * 1000;
    model.height = 5 * 1000;
    model.axleNumber = 6;
    model.plateColor = BNTruckPlateColorGreen;
    model.axleWeight = 80 * 1000;
    model.oilCost = 13 * 1000;
    model.truckCarType = BNTruckCarTypeCommon; /// 新能源 、普通车
    [BNaviService_Strategy syncTruckInfoModel:model];
}
/// 清空货车车牌
-(void)clearTruckInfo {
    [BNaviService_Strategy syncTruckInfoModel:nil];
}
 
- (NSString *)title {
    return @"驾车页";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    
    [self.contentView.tabPanel pageLoading];
    self.naviTye = BN_NaviTypeTruck;
    self.strategy = BNRoutePlanMode_Recommend;
    BNaviService_DriveRoute.delegate = self;
    [BNaviService_Instance naviMapView].delegate = self;
    self.contentView.isSlide = YES;
    [self.view addSubview:self.tripBtn];
    [self.view addSubview:self.prefernceBtn];
    [self.view addSubview:self.prefernceSelectView];
    [self setYellView];

}
///设置小黄条视图
- (void)setYellView {
    
    self.myYellowTipsView = [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(self.navigationController.navigationBar.frame), self.view.bounds.size.width  , 60)];
    self.myYellowTipsView.backgroundColor = [UIColor clearColor];
    [self.view addSubview:self.myYellowTipsView];
    
}

- (void)tap_delYellowTips {
    [BNaviService_YellowTips removeYellowTipFromContainer];
    
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    if (!self.isExitNavi) {
        [self startRoutePlan];
    }
    self.isExitNavi = NO;
    self.navigationController.interactivePopGestureRecognizer.enabled = NO;
    [BNaviService_DriveRoute viewWillAppear:self.view];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    
    self.navigationController.interactivePopGestureRecognizer.enabled = YES;
    [BNaviService_DriveRoute viewWillDisAppear:self.view];
}


- (void)startRoutePlan {
    [self.contentView.tabPanel pageLoading];
    [BNaviService_Strategy syncTruckUse:BNaviTruckUse_Danger];
    [BNaviService_YellowTips removeYellowTipFromContainer];
    if (self.nodes.count >= 2) {
        BNaviService_RoutePlan.disableOpenUrl = YES;
        [self setTruckInfo];
        [BNaviService_RoutePlan startNaviRoutePlan:self.strategy naviNodes:self.nodes time:nil delegete:self userInfo:@{BNaviTripTypeKey: @(self.naviTye)}];
    }
}

-(void)truckVC {
    
}
#pragma mark --BMDRYellowTipsStrategyManagerDelegate
- (void)yellowTips_viewWillShow {
    NSLog(@"显示");
    [self showRouteViewTop:40];
}


- (void)yellowTips_viewWillHide {
    NSLog(@"隐藏");
    [self.myYellowTipsView removeFromSuperview];
    [self showRouteViewTop:0];
}
#pragma mark - Public
- (void)carRouteDidSelectAtIndex:(NSInteger)index {
    [self showRouteViewAll];
    if (index >= 0 && index < self.carRoute.carRoutes.count) {
        [self routeSelectIndex:index needSelectRoute:YES];
        [self.contentView.carDetailContentView refreshData:self.carRoute index:self.selectIndex];
    }
}
 
//- (void)yellowTips_ClickedWithItemRoutID:(NSNumber *)roudId{
//    [self.myYellowTipsView removeFromSuperview];
//    [self showRouteViewTop:0];
//}


- (void)enterNaviPage {
    [BNaviService_DriveRoute stopUpdateLocation];
    [BNaviService_UI showPage:BNaviUI_NormalNavi delegate:self extParams:@{BNaviUI_NormalNavi_TypeKey: @(self.naviTye)}];
}

- (void)retryRoutePlan {
    [self startRoutePlan];
}

#pragma mark - Private
- (void)routeSelectIndex:(NSInteger)selectIndex needSelectRoute:(BOOL)needSelectRoute {
    self.selectIndex = selectIndex;
    
    if (needSelectRoute) {
        [BNaviService_DriveRoute selectRouteAtIndex:selectIndex];
        [self showRouteViewAll];
    }
}

- (CGFloat)bottomPaneHeight {
    if (self.carRoute.carRoutes.count == 1) {
        return kPanelLessHeight;
    } else {
        return kPanelHeight;
    }
}

- (void)resetUIFrame {
    CGFloat naviBtnHeight = 0;
    if (self.isTripType) {
        naviBtnHeight = 45;
    }
    self.contentView.frame = CGRectMake(0, IPHONE_SCREEN_HEIGHT-[self bottomPaneHeight]+naviBtnHeight, IPHONE_SCREEN_WIDTH, [self bottomPaneHeight]-naviBtnHeight);
    if (self.isTripType) {
        self.contentView.top = IPHONE_SCREEN_HEIGHT-[self bottomPaneHeight] + naviBtnHeight - 10;
        self.contentView.height = [self bottomPaneHeight] - naviBtnHeight;
    }
    self.radarLocationView.frame = CGRectMake(kLeftOffset, self.contentView.top - kRAButtonHeight-5, kRAButtonWidth, kRAButtonHeight);
    
    self.radarSwitchView.frame = CGRectMake(IPHONE_SCREEN_WIDTH-kRAButtonWidth-kLeftOffset, self.contentView.top - (kRAButtonHeight*2+1)-5, kRAButtonWidth, kRAButtonHeight*2+1);
    self.radarSwitchView.bottom = self.radarLocationView.bottom;
    self.logoView.frame = CGRectMake(CGRectGetMaxX(self.radarLocationView.frame)+5, IPHONE_SCREEN_HEIGHT-[self bottomPaneHeight]-self.logoView.height-5, self.logoView.width, self.logoView.height);
    [self.contentView reset];
    if (self.isTripType) {
        [self.contentView.tabPanel hiddenNaviBtn:self.isTripType];
    }
}

- (void)showRouteViewAll {
    if (self.customYellowTipsBgVew) {
        [self showRouteViewTop:self.customYellowTipsBgVew.height];
    }
    
}
-(void)tapPrefernceBtn {
    
    [self.prefernceSelectView show];
}

- (void)showRouteViewTop:(CGFloat)offset {
    CGFloat top = [[UIApplication sharedApplication] statusBarFrame].size.height+ 44.f;
    BNMargin margin = {top+offset, 20, self.view.height-self.radarSwitchView.y, 20};
    
    [BNaviService_DriveRoute showRouteViewAll:margin animated:YES];
    
}

- (void)refreshRouteData {
    BNCarRouteModel *route = [BNaviService_DriveRoute getCurrentCarRouteData];
    if (route) {
        self.carRoute = route;
        [self routeSelectIndex:[BNaviService_RoutePlan GetCurrentSelectRouteIdx] needSelectRoute:NO];
        
        [self resetUIFrame]; // [self resetUIFrame];需要在pageLoadedSuccess前，因为tabPanel中会用到tabPanel的高度
        [self.contentView.tabPanel pageLoadedSuccess:self.carRoute];
        [self.contentView.carDetailContentView refreshData:self.carRoute index:self.selectIndex];
    } else { // 没获取到当前路线信息，有可能是已经到达终点，退出驾车页
        [self.navigationController popViewControllerAnimated:YES];
    }
}
 
-(void)tapTripSelect {
    BNDatePickerViewController * datePicker = [[BNDatePickerViewController alloc]init];
    datePicker.delegate = self;
    datePicker.modalPresentationStyle = UIModalPresentationOverFullScreen;
    
    NSDate * selectedDate = self.selectDate;
    datePicker.initialSelectedDateAligned = selectedDate;
    
    [self presentViewController:datePicker animated:NO completion:^{
        
    }];
    
}

#pragma mark - BNDatePickerViewControllerDelegate
-(void)datePickerDidDismiss:(BNDatePickerViewController*)picker {
    
    
}

-(void)datePickerDidOK:(BNDatePickerViewController*)picker {
    NSLog(@"%@", picker.selectedDate);
    self.selectDate = picker.selectedDate;
    [_tripSelectTimeBtn setTitle:[NSString stringWithFormat:@"%d-%d-%d-%d-%d", picker.selectedDate.year, picker.selectedDate.month, picker.selectedDate.day, picker.selectedDate.hour, picker.selectedDate.minute] forState:UIControlStateNormal];
    [self startRoutePlan];

}
-(BOOL)isTripMode {
    return self.isTripType;
}

-(void)tapNaviSetCarNumber:(UIButton *)sender {
    sender.selected = !sender.isSelected;
    if (sender.isSelected) {
        [self clearTruckInfo];
    } else {
        [self setTruckInfo];
    }
}

#pragma mark - BNNaviRoutePlanDelegate
/**
 *  算路成功回调
 *
 *  @param userInfo 用户信息
 */
- (void)routePlanDidFinished:(NSDictionary*)userInfo {
    [self showRouteViewAll];
    /// 获取路线数据
    BNCarRouteModel *routeModel =  [BNaviService_DriveRoute getCurrentCarRouteData];
    
    
    BNCarRouteModel *route = userInfo[BNDriveRouteDataKey];
    if (route) {
        self.carRoute = route;
        [self routeSelectIndex:[BNaviService_RoutePlan GetCurrentSelectRouteIdx] needSelectRoute:NO];
        
        [self resetUIFrame]; // [self resetUIFrame];需要在pageLoadedSuccess前，因为tabPanel中会用到tabPanel的高度
        [self.contentView.tabPanel pageLoadedSuccess:self.carRoute];
        [self.contentView.carDetailContentView refreshData:self.carRoute index:self.selectIndex];
    }
    
    // 算路成功后需要打开定位才能显示车标
   
    [BNaviService_DriveRoute startUpdateLocation];
    
 
}


/**
 *  算路失败回调
 *
 *  @param error    失败信息
 *  @param userInfo 用户信息
 */
- (void)routePlanDidFailedWithError:(NSError *)error andUserInfo:(NSDictionary*)userInfo {
    [self.contentView.tabPanel pageLoadedFailed:error];
}

/**
 *  算路取消
 *
 *  @param userInfo 用户信息
 */
-(void)routePlanDidUserCanceled:(NSDictionary*)userInfo {
    
}

#pragma mark - BNDriveRouteManagerDelegate
/**
 用户在地图上点击了某条路线（如果需要高亮该路线，要调用selectRouteAtIndex:接口）
 
 @param routeIndex 路线序号（从0开始）
 */
- (void)onHandleTouchRouteAtIndex:(NSUInteger)routeIndex {
    if (routeIndex < self.carRoute.carRoutes.count) {
        [self routeSelectIndex:routeIndex needSelectRoute:NO];
        [self.contentView.tabPanel selectAtIndex:self.selectIndex];
        [self.contentView.carDetailContentView refreshData:self.carRoute index:self.selectIndex];
    }
}

- (void)onHandleUpdateCurrentCarPositionInfo:(NSDictionary *)positionInfo {
    
}

#pragma mark - RadarLocationViewDelegate
- (void)radarLocation:(RadarLocationView *)locationView {
    [self showRouteViewAll];
}

#pragma mark - BNMapViewManagerDelegate
- (void)mapStatusDidChanged:(BMKMapView *)mapView {
    [self.radarSwitchView handleMapLevelChange:[mapView getMapStatus].fLevel];
}
- (void)onHandleMapLevelChange:(NSInteger)level {
    [self.radarSwitchView handleMapLevelChange:level];
}
#pragma mark - BNNaviUIManagerDelegate
- (void)willExitPage:(BNaviUIType)pageType extraInfo:(NSDictionary*)extraInfo {
    self.isExitNavi = YES;
    [self showRouteViewAll];
    [BNaviService_DriveRoute startUpdateLocation];
    
    [self refreshRouteData];
}

#pragma mark - Lazy loading
- (RouteContentView *)contentView {
    if (!_contentView) {
        _contentView = [[RouteContentView alloc] initWithFrame:CGRectMake(0, IPHONE_SCREEN_HEIGHT-[self bottomPaneHeight], IPHONE_SCREEN_WIDTH, [self bottomPaneHeight])];
        _contentView.drivePageVc = self;
        [self.view addSubview:_contentView];
    }
    return _contentView;
}

- (RadarSwitchView *)radarSwitchView {
    if (!_radarSwitchView) {
        _radarSwitchView = [[RadarSwitchView alloc] initWithFrame:CGRectMake(IPHONE_SCREEN_WIDTH-kRAButtonWidth-kLeftOffset, IPHONE_SCREEN_HEIGHT-[self bottomPaneHeight]-(kRAButtonHeight*2+1)-5, kRAButtonWidth, kRAButtonHeight*2+1)];
        [self.view insertSubview:_radarSwitchView belowSubview:self.contentView];
    }
    return _radarSwitchView;
}

- (RadarLocationView *)radarLocationView {
    if (!_radarLocationView) {
        _radarLocationView = [[RadarLocationView alloc] initWithFrame:CGRectMake(kLeftOffset, IPHONE_SCREEN_HEIGHT-[self bottomPaneHeight]-kRAButtonHeight-5, kRAButtonWidth, kRAButtonHeight)];
        _radarLocationView.delegate = self;
        [self.view insertSubview:_radarLocationView belowSubview:self.contentView];
    }
    return _radarLocationView;
}

 
 
-(UIButton *)truckNaviSetCarNumber {
    if (!_truckNaviSetCarNumber) {
        _truckNaviSetCarNumber = [UIButton buttonWithType:UIButtonTypeCustom];
        [_truckNaviSetCarNumber setTitle:@"货车有车牌" forState:UIControlStateNormal];
        [_truckNaviSetCarNumber setTitle:@"货车无车牌" forState:UIControlStateSelected];
        [_truckNaviSetCarNumber setBackgroundColor:[UIColor redColor]];
        _truckNaviSetCarNumber.titleLabel.font = [UIFont systemFontOfSize:13];
        _truckNaviSetCarNumber.titleLabel.numberOfLines = 0;
        [_truckNaviSetCarNumber setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [_truckNaviSetCarNumber addTarget:self action:@selector(tapNaviSetCarNumber:) forControlEvents:UIControlEventTouchUpInside];
        _truckNaviSetCarNumber.frame = CGRectMake(0, self.prefernceBtn.bottom + 20, 80, 40);
        
    }
    return _truckNaviSetCarNumber;
}
-(UIButton *)prefernceBtn {
    if (!_prefernceBtn) {
        _prefernceBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_prefernceBtn setTitle:@"智能推荐" forState:UIControlStateNormal];
        [_prefernceBtn setBackgroundColor:[UIColor redColor]];
        _prefernceBtn.titleLabel.font = [UIFont systemFontOfSize:13];
        _prefernceBtn.titleLabel.numberOfLines = 0;
        [_prefernceBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [_prefernceBtn addTarget:self action:@selector(tapPrefernceBtn) forControlEvents:UIControlEventTouchUpInside];
        _prefernceBtn.frame = CGRectMake(0, 300, 80, 40);
        
    }
    return _prefernceBtn;
}
-(BNRoutePreferenceSelectView *)prefernceSelectView {
    if (!_prefernceSelectView) {
        _prefernceSelectView = [[BNRoutePreferenceSelectView alloc] initWithFrame:self.view.bounds];
        [_prefernceSelectView hid];
        __weak typeof(self) weakSelf = self;
        _prefernceSelectView.block = ^(NSDictionary *dict) {
            if (dict) {
                BNNaviElderlyRoutePreferenceModel *selectMode = dict[@"Data"];
                [weakSelf.prefernceBtn setTitle:selectMode.preferenceStr forState:UIControlStateNormal];
                weakSelf.strategy = selectMode.preferenceType;
                [weakSelf startRoutePlan];
            }
            
        };
        
    }
    return  _prefernceSelectView;
}

-(UIView *)customYellowTipsBgVew {
    if (!_customYellowTipsBgVew) {
        _customYellowTipsBgVew = [[UIView alloc] init];
        [self.view addSubview: _customYellowTipsBgVew];
    }
    return _customYellowTipsBgVew;
}
#pragma mark - 禁止横屏
- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait;
}

- (UIInterfaceOrientation)preferredInterfaceOrientationForPresentation {
    return UIInterfaceOrientationPortrait;
}

@end
