//
//  BNRoutePreferenceSelectView.m
//  BNCare
//
//  Created by v_lisisi on 2021/8/21.
//  Copyright © 2021 baidu. All rights reserved.
//

#import "BNRoutePreferenceSelectView.h"
#import "UIView+layout.h"
#import "BNRoutePreferenceCell.h"
#import "BNNaviElderlyRoutePreferenceModel.h"
#import "CommonDefine.h"
@interface BNRoutePreferenceSelectView ()<UICollectionViewDelegate, UICollectionViewDataSource>
@property(nonatomic, strong) UIView *bgView;
@property(nonatomic, strong) UIView *topBgView;

@property(nonatomic, strong) UILabel *titleLab;
@property(nonatomic, strong) UIButton *closeBtn;

@property(nonatomic, strong) UICollectionView *collectionView;
@property(nonatomic, strong) NSMutableArray  *preferenceData;
@property(nonatomic, strong) BNNaviElderlyRoutePreferenceModel  *routePreferenceModel;
@property(nonatomic, assign) int  selectIndex;

@end

@implementation BNRoutePreferenceSelectView


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self initView];
        [self setAllFrame];
    }
    return self;
}

-(void)initView {
    self.routePreferenceModel = [BNNaviElderlyRoutePreferenceModel sharedInstance];
    self.preferenceData = [NSMutableArray  arrayWithArray:[BNNaviElderlyRoutePreferenceModel routePreferenceArray]];
    self.backgroundColor = [UIColor colorWithWhite:0.5 alpha:0.5];
    self.bgView = [[UIView alloc] init];
    self.bgView.backgroundColor = [UIColor whiteColor];
    [self addSubview:self.bgView];
    
    self.topBgView = [[UIView alloc] init];
    self.topBgView.backgroundColor = [UIColor clearColor];
    [self addSubview:self.topBgView];
    
    self.titleLab = [[UILabel alloc] init];
    self.titleLab.text = @"路线偏好";
    self.titleLab.font = [UIFont boldSystemFontOfSize:22];
    self.titleLab.textColor = RGBA(17, 20, 26, 1);
    [self.bgView addSubview:self.titleLab];
    
    self.closeBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    self.closeBtn.titleLabel.font = [UIFont systemFontOfSize:18];
    [self.closeBtn setTitleColor:RGBA(17, 20, 26, 1) forState:UIControlStateNormal];
    [self.closeBtn setTitleColor:RGBA(17, 20, 26, 1) forState:UIControlStateHighlighted];
    [self.closeBtn setTitle:@"关闭" forState:UIControlStateNormal];
    [self.closeBtn setTitle:@"关闭" forState:UIControlStateHighlighted];
    [self.bgView addSubview:self.closeBtn];
    
    UICollectionViewFlowLayout *flowLayout = [[UICollectionViewFlowLayout alloc] init];
        [flowLayout setScrollDirection:UICollectionViewScrollDirectionVertical];
        //设置CollectionView的属性
    self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:flowLayout];
    self.collectionView.backgroundColor = [UIColor whiteColor];
    self.collectionView.delegate = self;
    self.collectionView.dataSource = self;
    self.collectionView.scrollEnabled = YES;
    [self.bgView addSubview:self.collectionView];
    
    [self.closeBtn addTarget:self action:@selector(tapCloseBtn) forControlEvents:UIControlEventTouchUpInside];
    //注册Cell
    [self.collectionView registerClass:[BNRoutePreferenceCell class] forCellWithReuseIdentifier:@"BNRoutePreferenceCell"];

    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] init];
    [tap addTarget:self action:@selector(tapGesture)];
    [self.topBgView addGestureRecognizer:tap];
    
}

#pragma mark  --- collectionDeleagte
-(NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.preferenceData.count;
}
- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    BNRoutePreferenceCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"BNRoutePreferenceCell" forIndexPath:indexPath];
    cell.model = self.preferenceData[indexPath.row];
    if (cell.model.isSelectType) {
        self.selectIndex = indexPath.row;
    }
    
    return cell;
}

-(void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    self.preferenceData = [NSMutableArray  arrayWithArray:[BNNaviElderlyRoutePreferenceModel updateRoutePreference:self.preferenceData[indexPath.row] withPreferenceData:self.preferenceData]];
    [self.collectionView reloadData];
    if (self.block) {
        self.block(@{@"index":@(indexPath.row),
                     @"Data":self.preferenceData[indexPath.row]
                   });
    }
    
    [self hid];
    
    NSLog(@"选中了cell");
}
#pragma mark  定义每个UICollectionView的大小
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath {
    return  CGSizeMake((self.width - 40-10) /3, 75);
}

#pragma mark  定义每个UICollectionView的横向间距
- (CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section {
    return 5;
}

#pragma mark  定义每个UICollectionView的纵向间距
- (CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout minimumLineSpacingForSectionAtIndex:(NSInteger)section {
    return 0;
}

-(void)setAllFrame {
    
    
    self.bgView.left = self.left;
    self.bgView.top = self.bottom;
    self.bgView.width = self.width;
    self.bgView.height = 350;
    
    self.topBgView.top = self.top;
    self.topBgView.left = self.left;
    self.topBgView.width = self.width;
    self.topBgView.height = self.height - 350;
    
    self.titleLab.top = 20;
    self.titleLab.left = 20;
    self.titleLab.width = 200;
    self.titleLab.height = 20;
  
    self.closeBtn.top = 10;
    self.closeBtn.right = self.width - 60;
    self.closeBtn.size = CGSizeMake(50, 40);
    
    self.collectionView.top = self.titleLab.bottom+20;
    self.collectionView.left = 10;
    self.collectionView.width = self.width-20;
    self.collectionView.height = 260;
    
}

-(void)tapGesture {
    [self hid];
}

-(void)tapCloseBtn {
    [self hid];
}

-(void)show {
    self.alpha = 0;
    [self.bgView setNeedsUpdateConstraints];
    [UIView animateWithDuration:0.3 animations:^{
        self.alpha = 1;
        
        self.bgView.height = 350;
        self.bgView.top = self.height - 350;
        //告知父类控件绘制，不添加注释的这两行的代码无法生效
        [self.bgView.superview layoutIfNeeded];
        self.hidden = NO;
        self.bgView.layer.masksToBounds = YES;
        self.bgView.layer.cornerRadius = 6;
    }];
}

-(void)hid {
    [self.bgView setNeedsUpdateConstraints];
    [UIView animateWithDuration:0.3 animations:^{
        self.alpha = 0;
        self.bgView.height = 0;
        self.bgView.top = self.bottom;
        //告知父类控件绘制，不添加注释的这两行的代码无法生效
        [self.bgView.superview layoutIfNeeded];
        self.hidden = YES;
    }];
}
-(void)dealloc {
    
    NSLog(@"BNRoutePreferenceSelectView -- dealloc");
}
-(void)setData {
    
    
}
@end
