//
//  BNRoutePreferenceCell.m
//  BNCare
//
//  Created by v_lisisi on 2021/8/22.
//  Copyright © 2021 baidu. All rights reserved.
//

#import "BNRoutePreferenceCell.h"
#import "CommonDefine.h"
#import "UIView+layout.h"

@interface BNRoutePreferenceCell ()

@property(nonatomic, strong)UIView *bgView;
@property(nonatomic, strong)UIImageView *bgImage;
@property(nonatomic, strong)UIImageView *imgView;
@property(nonatomic, strong)UILabel *cellLab;

@end

@implementation BNRoutePreferenceCell

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self initView];
        [self setAllFrame];
    }
    return self;
}


-(void)initView {
    self.backgroundColor = [UIColor whiteColor];
    self.bgView = [[UIView alloc] init];
    self.bgView.backgroundColor = RGBA(205, 206, 210, 1);
    [self.contentView addSubview:self.bgView];
    
    self.bgImage = [[UIImageView alloc] init];
    self.bgImage.backgroundColor = RGBA(32, 178, 170, 1);
//    self.bgImage.image = [UIImage imageNamed:@"bnavi_route_preference"];
    [self.bgView addSubview:self.bgImage];
    
    
    
    self.cellLab = [[UILabel alloc] init];
    self.cellLab.text = @"智能推荐";
    self.cellLab.textColor = [UIColor whiteColor]; //RGBA(17, 20, 26, 1);
    self.cellLab.textAlignment = NSTextAlignmentCenter;
    self.cellLab.font = [UIFont boldSystemFontOfSize:18];
    self.cellLab.numberOfLines = 0;
    [self.bgView addSubview:self.cellLab];
    
}


-(void)setAllFrame {
    self.bgView.top = 10;
    self.bgView.left = 0;
    self.bgView.height = self.height-10;
    self.bgView.width = self.width;
   
    self.bgView.layer.masksToBounds = YES;
    self.bgView.layer.cornerRadius = 10;
    
    self.bgImage.top = 0;
    self.bgImage.left = 0;
    self.bgImage.height = self.bgView.height;
    self.bgImage.width = self.width;
    
    
    self.cellLab.width = self.bgView.width;
    self.cellLab.height = 80;
    self.cellLab.top = (self.bgView.height - 80)/2;
    
}

-(void)setModel:(BNNaviElderlyRoutePreferenceModel *)model {
    _model = model;
    self.cellLab.text = model.preferenceStr;
    self.imgView.hidden = YES;
    if (model.isSelectType) {
        self.bgImage.hidden = NO;
        self.cellLab.textColor = [UIColor whiteColor];
    } else {
        self.bgImage.hidden = YES;
        self.cellLab.textColor = RGBA(80, 87, 115, 1);
    }
    
}

@end
