//
//  BNNaviElderlyRoutePreferenceModel.m
//  BNCare
//
//  Created by v_lisisi on 2021/8/22.
//  Copyright © 2021 baidu. All rights reserved.
//

#import "BNNaviElderlyRoutePreferenceModel.h"
static BNNaviElderlyRoutePreferenceModel *elderlyRoutePreference;
@implementation BNNaviElderlyRoutePreferenceModel

- (instancetype)init {
    if (self = [super init]) {
    }
    return self;
}

+(BNNaviElderlyRoutePreferenceModel*)dictToPreferenceModel:(NSDictionary*)dict {
    BNNaviElderlyRoutePreferenceModel *mode = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    mode.isSelectType = [dict[@"isSelectType"] boolValue];
    mode.preferenceStr = dict[@"preferenceStr"];
    mode.isDefault = [dict[@"isDefault"] boolValue];
    mode.preferenceType = (BNRoutePlanMode)[dict[@"preferenceType"] intValue];
    return mode;
}
+(NSDictionary*)preferenceModelToDict:(BNNaviElderlyRoutePreferenceModel*)model {
    NSMutableDictionary *dic = [NSMutableDictionary dictionary];
    [dic setObject:@(model.isSelectType) forKey:@"isSelectType"];
    [dic setObject:model.preferenceStr forKey:@"preferenceStr"];
    [dic setObject:@(model.preferenceType) forKey:@"preferenceType"];
    [dic setObject:@(model.isDefault) forKey:@"isDefault"];
    return dic;
}
- (void)dealloc {
    
}

+ (BNNaviElderlyRoutePreferenceModel *)sharedInstance {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        elderlyRoutePreference = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    });
    return elderlyRoutePreference;
}

+(NSArray *)routePreferenceArray {
    //BNRoutePlanMode_Recommend           = 0X00000001 ,      /**<  推荐 */
    //BNRoutePlanMode_NoHeighWay          = 0X00000004 ,      /**<  不走高速 */
    //BNRoutePlanMode_LessToll            = 0X00000008 ,      /**<  少收费 */
    //BNRoutePlanMode_LessJam             = 0X00000010 ,      /**<  躲避拥堵 */
    //BNRoutePlanMode_SaveTime            = 0X00000100 ,      /**<  时间优先 */
    //BNRoutePlanMode_MainRoad            = 0X00000200 ,      /**<  高速优先 */
    //BNRoutePlanMode_EconomicRoute       = 0X00000400 ,      /**<  省钱路线 */
    //BNRoutePlanMode_RoadFirst           = 0X00000080 ,      /**<  距离最短 */
    NSArray *arr = [NSArray array];
    
    BNNaviElderlyRoutePreferenceModel *lessJamNoHeighWay = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    lessJamNoHeighWay.preferenceStr = @"躲避拥堵\n不走高速";
    lessJamNoHeighWay.isSelectType = NO;
    lessJamNoHeighWay.preferenceType = BNRoutePlanMode_LessJam | BNRoutePlanMode_NoHeighWay;
    lessJamNoHeighWay.isDefault = YES;
    
    BNNaviElderlyRoutePreferenceModel *lessTollNoheightWay = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    lessTollNoheightWay.preferenceStr = @"少收费\n不走高速";
    lessTollNoheightWay.isSelectType = NO;
    lessTollNoheightWay.preferenceType = BNRoutePlanMode_LessToll | BNRoutePlanMode_NoHeighWay;
    lessTollNoheightWay.isDefault = NO;
    
    BNNaviElderlyRoutePreferenceModel *lessJamToll = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    lessJamToll.preferenceStr = @"躲避拥堵\n少收费";
    lessJamToll.isSelectType = NO;
    lessJamToll.preferenceType = BNRoutePlanMode_LessJam|BNRoutePlanMode_LessToll;
    lessJamToll.isDefault = NO;
    
    
    BNNaviElderlyRoutePreferenceModel *lessJamlessTollNoHeighWay = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    lessJamlessTollNoHeighWay.preferenceStr = @"躲避拥堵\n少收费\n不走高速";
    lessJamlessTollNoHeighWay.isSelectType = NO;
    lessJamlessTollNoHeighWay.preferenceType = BNRoutePlanMode_LessJam|BNRoutePlanMode_LessToll|BNRoutePlanMode_NoHeighWay;
    lessJamlessTollNoHeighWay.isDefault = NO;
    
    BNNaviElderlyRoutePreferenceModel *lessJamMainRoad = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    lessJamMainRoad.preferenceStr = @"躲避拥堵\n高速优先";
    lessJamMainRoad.isSelectType = NO;
    lessJamMainRoad.preferenceType = BNRoutePlanMode_LessJam|BNRoutePlanMode_MainRoad;
    lessJamMainRoad.isDefault = NO;
    
    BNNaviElderlyRoutePreferenceModel *saveTimeNoHeighWay = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    saveTimeNoHeighWay.preferenceStr = @"时间优先\n不走高速";
    saveTimeNoHeighWay.isSelectType = NO;
    saveTimeNoHeighWay.preferenceType = BNRoutePlanMode_SaveTime|BNRoutePlanMode_NoHeighWay;
    saveTimeNoHeighWay.isDefault = NO;
     
    
    BNNaviElderlyRoutePreferenceModel *model = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    model.preferenceStr = @"智能推荐";
    model.isSelectType = YES;
    model.preferenceType = BNRoutePlanMode_Recommend;
    model.isDefault = NO;
    
    BNNaviElderlyRoutePreferenceModel *time = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    time.preferenceStr = @"时间优先";
    time.isSelectType = NO;
    time.preferenceType = BNRoutePlanMode_SaveTime;
    time.isDefault = NO;
    BNNaviElderlyRoutePreferenceModel *lesscharge = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    lesscharge.preferenceStr = @"少收费";
    lesscharge.isSelectType = NO;
    lesscharge.isDefault = NO;
    lesscharge.preferenceType = BNRoutePlanMode_LessToll;
    
    BNNaviElderlyRoutePreferenceModel *avoidcongestion = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    avoidcongestion.preferenceStr = @"躲避拥堵";
    avoidcongestion.isSelectType = NO;
    avoidcongestion.isDefault = NO;
    avoidcongestion.preferenceType = BNRoutePlanMode_LessJam;
    
    BNNaviElderlyRoutePreferenceModel *highspeed = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    highspeed.preferenceStr = @"不走高速";
    highspeed.isSelectType = NO;
    highspeed.isDefault = NO;
    highspeed.preferenceType = BNRoutePlanMode_NoHeighWay;
    
    BNNaviElderlyRoutePreferenceModel *highspeedpriority = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    highspeedpriority.preferenceStr = @"高速优先";
    highspeedpriority.isSelectType = NO;
    highspeedpriority.isDefault = NO;
    highspeedpriority.preferenceType = BNRoutePlanMode_MainRoad;
    
    BNNaviElderlyRoutePreferenceModel *economicRoute = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    economicRoute.preferenceStr = @"省钱路线";
    economicRoute.isSelectType = NO;
    economicRoute.isDefault = NO;
    economicRoute.preferenceType = BNRoutePlanMode_EconomicRoute;
    
    BNNaviElderlyRoutePreferenceModel *roadFirst = [[BNNaviElderlyRoutePreferenceModel alloc] init];
    roadFirst.preferenceStr = @"距离最短";
    roadFirst.isSelectType = NO;
    roadFirst.isDefault = NO;
    roadFirst.preferenceType = BNRoutePlanMode_RoadFirst;
    
    arr = @[lessJamNoHeighWay, lessTollNoheightWay, lessJamToll, lessJamlessTollNoHeighWay, lessJamMainRoad, saveTimeNoHeighWay, model, time, lesscharge, avoidcongestion, highspeed, highspeedpriority, economicRoute, roadFirst];
    NSMutableArray *mutabArr = [NSMutableArray array];
    for (int i = 0; i<arr.count; i++) {
        [mutabArr addObject:[BNNaviElderlyRoutePreferenceModel preferenceModelToDict:arr[i]]];
    }
        
    
    return arr;
}

+(NSArray *)updateRoutePreference:(BNNaviElderlyRoutePreferenceModel*)model withPreferenceData:(NSArray *)routePrefArr {
    if (routePrefArr) {
//        NSMutableArray *mutabArr = [NSMutableArray array];
        ///循环找出选中的 选中的不一定是默认的
        for (int i=0; i<routePrefArr.count; i++) {
            BNNaviElderlyRoutePreferenceModel *highspeedpriority = routePrefArr[i];
            if (highspeedpriority.preferenceType == model.preferenceType) {
                highspeedpriority.isSelectType = YES;
            } else {
                highspeedpriority.isSelectType = NO;
            }
//            [mutabArr addObject:[BNNaviElderlyRoutePreferenceModel preferenceModelToDict:routePrefArr[i]]];
        }
        
    }
    return routePrefArr;
}

@end
