//
//  NSDate+BNFutureTrip.m
//  FutureTripDemo
//
//  Created by Liang,Zhiyuan(GIS)2 on 2019/2/15.
//  Copyright © 2019 Liang,Zhiyuan(GIS). All rights reserved.
//

#import "NSDate+BNFutureTrip.h"

#define D_MINUTE 60
#define D_HOUR 60 * 60

static const unsigned componentFlags = (NSYearCalendarUnit| NSMonthCalendarUnit | NSDayCalendarUnit | NSWeekCalendarUnit |  NSHourCalendarUnit | NSMinuteCalendarUnit | NSSecondCalendarUnit | NSWeekdayCalendarUnit | NSWeekdayOrdinalCalendarUnit);

@implementation NSDate (BNFutureTrip)

+(NSDate*)GMT_date{
//#ifdef DEBUG
//    return [[NSDate date].midnight dateByAddingMinutes:16 * 60 + 15];
//
//    static NSDateFormatter *dateFormatter = nil;
//    if (!dateFormatter) {
//        dateFormatter = [[NSDateFormatter alloc] init];
//        [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
//    }
//    NSDate *capturedStartDate = [dateFormatter dateFromString: @"2019-09-16 23:59:59"];
//    return capturedStartDate;
//#endif
    return [NSDate date];
}

+(NSDate*)local_date{
    NSDate * date = [NSDate date];
    NSTimeZone * zone = [NSTimeZone systemTimeZone];
    NSTimeInterval dInterval = [zone secondsFromGMTForDate:date];
    NSDate * cur = [date dateByAddingTimeInterval:dInterval];
    return cur;
}

+(NSDate*)GMTDateFromLocalTimestamp:(NSTimeInterval)localTimeSince1970{
    NSDate * localDate = [NSDate dateWithTimeIntervalSince1970:localTimeSince1970];
    
    NSTimeZone * zone = [NSTimeZone systemTimeZone];
    NSTimeInterval dInterval = [zone secondsFromGMTForDate:[NSDate date]];
    
    NSDate * cur = [localDate dateByAddingTimeInterval:-dInterval];
    return cur;
}

+(NSTimeInterval)localTimestampFromGMTDate:(NSDate*)aGMTDate{
    NSTimeInterval ret = [aGMTDate timeIntervalSince1970];
    
    NSTimeZone * zone = [NSTimeZone systemTimeZone];
    NSTimeInterval dInterval = [zone secondsFromGMTForDate:[NSDate date]];
    
    return ret + dInterval;
}

-(NSTimeInterval)ft_localTimeIntervalSince1970{
    return [NSDate localTimestampFromGMTDate:self];
}

+ (NSDate *) dateWithDaysFromNow: (NSInteger) days
{
    return [[NSDate date] dateByAddingDays:days];
}

+ (NSDate *) dateTomorrow
{
    return [NSDate dateWithDaysFromNow:1];
}

+ (NSDate *) dateTheDayAfterTomorrow
{
    return [NSDate dateWithDaysFromNow:1];
}

+ (NSDate *) dateYesterday
{
    return [NSDate dateWithDaysBeforeNow:1];
}

+ (NSDate *) dateWithDaysBeforeNow: (NSInteger) days
{
    return [[NSDate date] dateBySubtractingDays:days];
}

- (NSDate *) dateByAddingDays: (NSInteger) dDays
{
    NSDateComponents *dateComponents = [[NSDateComponents alloc] init];
    [dateComponents setDay:dDays];
    NSDate *newDate = [[NSCalendar currentCalendar] dateByAddingComponents:dateComponents toDate:self options:0];
    return newDate;
}

- (NSDate *) dateBySubtractingDays: (NSInteger) dDays
{
    return [self dateByAddingDays: (dDays * -1)];
}

- (NSDate *) dateByAddingHours: (NSInteger) dHours
{
    NSTimeInterval aTimeInterval = [self timeIntervalSinceReferenceDate] + D_HOUR * dHours;
    NSDate *newDate = [NSDate dateWithTimeIntervalSinceReferenceDate:aTimeInterval];
    return newDate;
}

- (NSDate *) dateBySubtractingHours: (NSInteger) dHours
{
    return [self dateByAddingHours: (dHours * -1)];
}

- (NSDate *) dateByAddingMinutes: (NSInteger) dMinutes
{
    NSTimeInterval aTimeInterval = [self timeIntervalSinceReferenceDate] + D_MINUTE * dMinutes;
    NSDate *newDate = [NSDate dateWithTimeIntervalSinceReferenceDate:aTimeInterval];
    return newDate;
}

- (NSDate *) dateBySubtractingMinutes: (NSInteger) dMinutes
{
    return [self dateByAddingMinutes: (dMinutes * -1)];
}


- (BOOL) isToday
{
    return [self isEqualToDateIgnoringTime:[NSDate date]];
}

- (BOOL) isTodayToDate:(NSDate*)date{
    return [self isEqualToDateIgnoringTime:date];
}

- (BOOL) isTomorrow
{
    return [self isEqualToDateIgnoringTime:[NSDate dateTomorrow]];
}

- (BOOL) isTomorrowToDate:(NSDate*)date{
    return [self isEqualToDateIgnoringTime:[date dateByAddingDays:1]];
}

- (BOOL) isYesterday
{
    return [self isEqualToDateIgnoringTime:[NSDate dateYesterday]];
}

- (BOOL) isYesterdayToDate:(NSDate*)date{
    return [self isEqualToDateIgnoringTime:[date dateBySubtractingDays:1]];
}

- (BOOL) isEqualToDateIgnoringTime: (NSDate *) aDate
{
    NSDateComponents *components1 = [[NSDate currentCalendar] components:componentFlags fromDate:self];
    NSDateComponents *components2 = [[NSDate currentCalendar] components:componentFlags fromDate:aDate];
    return ((components1.year == components2.year) &&
            (components1.month == components2.month) &&
            (components1.day == components2.day));
}

+ (NSCalendar *) currentCalendar
{
    static NSCalendar *sharedCalendar = nil;
    if (!sharedCalendar)
        sharedCalendar = [NSCalendar autoupdatingCurrentCalendar];
    return sharedCalendar;
}

-(NSDate*)tomorrow{
    return [self dateByAddingDays:1];
}

-(NSDate*)yesterday{
    return [self dateBySubtractingDays:1];
}

-(NSDate*)midnight{
    NSCalendar * cal = [NSCalendar currentCalendar];
    return [cal startOfDayForDate:self];
}

- (NSInteger)ft_weekday{
    return [self weekday_p];
}

- (NSInteger)weekday_p
{
    //    NSCalendar * calendar = [NSCalendar calendarWithIdentifier:NSCalendarIdentifierGregorian];
    
    NSCalendar * calendar = [NSDate currentCalendar];
    NSDateComponents *components = [calendar components:componentFlags fromDate:self];
    return components.weekday;
}

+(NSString*)stringForWeekday:(NSInteger)weekday{
    static NSArray * weakdayArry = nil;
    if (weakdayArry == nil) {
        weakdayArry = @[@"周日",@"周一",@"周二",@"周三",@"周四",@"周五",@"周六"];
    }
    
    if (weekday >=1 && weekday <= 7) {
        return weakdayArry[weekday-1];
    }
    
    return nil;
}

-(NSString*)weekdayString{
    NSInteger weekday = [self weekday_p];
    return [NSDate stringForWeekday:weekday];
}

-(NSDate*)nextDateByUnit:(NSTimeInterval)unitTime{
    if (((long long)self.timeIntervalSince1970) % ((long long)unitTime) == 0) {
        //刚好是**:00:00或是**:15:00，**:30:00，**:45:00之类
        return [self dateByAddingTimeInterval:unitTime];
    }
    
    NSDate * midnight = self.midnight;
    NSTimeInterval timeSinceMidNight = [self timeIntervalSinceDate:midnight];
    
    int unit = ceil(timeSinceMidNight/(unitTime));
    NSDate * date = [midnight dateByAddingTimeInterval:unit * unitTime];
    return date;
}

-(NSDate*)nextDateByUnit_15min{
    return [self nextDateByUnit:15 * 60];
}

//是否规则的15分钟
- (BOOL)isByUnit_15min
{
    NSTimeInterval dInterval = [self timeIntervalSince1970];
    NSInteger time = dInterval;
    if(time%(15*60) == 0)
    {
        return YES;
    }
    else
    {
        return NO;
    }
}



- (NSInteger) hour
{
    NSDateComponents *components = [[NSDate currentCalendar] components:componentFlags fromDate:self];
    return components.hour;
}

- (NSInteger) minute
{
    NSDateComponents *components = [[NSDate currentCalendar] components:componentFlags fromDate:self];
    return components.minute;
}

- (NSInteger) seconds
{
    NSDateComponents *components = [[NSDate currentCalendar] components:componentFlags fromDate:self];
    return components.second;
}

- (NSInteger) day
{
    NSDateComponents *components = [[NSDate currentCalendar] components:componentFlags fromDate:self];
    return components.day;
}

- (NSInteger) month
{
    NSDateComponents *components = [[NSDate currentCalendar] components:componentFlags fromDate:self];
    return components.month;
}

- (NSInteger) week
{
    NSDateComponents *components = [[NSDate currentCalendar] components:componentFlags fromDate:self];
    return components.week;
}

- (NSInteger) nthWeekday // e.g. 2nd Tuesday of the month is 2
{
    NSDateComponents *components = [[NSDate currentCalendar] components:componentFlags fromDate:self];
    return components.weekdayOrdinal;
}

- (NSInteger) year
{
    NSDateComponents *components = [[NSDate currentCalendar] components:componentFlags fromDate:self];
    return components.year;
}

- (NSInteger)distanceInDaysToDate:(NSDate *)anotherDate
{
//    NSCalendar *gregorianCalendar = [[NSCalendar alloc] initWithCalendarIdentifier:NSGregorianCalendar];
//    NSDateComponents *components = [gregorianCalendar components:NSDayCalendarUnit fromDate:self toDate:anotherDate options:0];
//    return components.day;
    NSTimeInterval nowTime = [self.midnight timeIntervalSince1970];
    NSTimeInterval anotherTime = [anotherDate.midnight timeIntervalSince1970];
    
    NSInteger distance = (nowTime - anotherTime)/(3600 * 24);
    return distance;
}

@end
