//
//  NSDate+BNFutureTrip.h
//  FutureTripDemo
//
//  Created by Liang,Zhiyuan(GIS)2 on 2019/2/15.
//  Copyright © 2019 Liang,Zhiyuan(GIS). All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface NSDate (BNFutureTrip)

/**
 获取当前GMT时间

 @return <#return value description#>
 */
+(NSDate*)GMT_date;

/**
 当地时间

 @return <#return value description#>
 */
+(NSDate*)local_date;


/**
 从本地时间戳获取gmt时间

 @param localTimeSince1970 <#localTimeSince1970 description#>
 @return <#return value description#>
 */
+(NSDate*)GMTDateFromLocalTimestamp:(NSTimeInterval)localTimeSince1970;

+(NSTimeInterval)localTimestampFromGMTDate:(NSDate*)aGMTDate;

-(NSTimeInterval)ft_localTimeIntervalSince1970;

+ (NSDate *) dateWithDaysFromNow: (NSInteger) days;

+ (NSDate *) dateTomorrow;

+ (NSDate *) dateYesterday;

+ (NSDate *) dateWithDaysBeforeNow: (NSInteger) days;

- (NSDate *) dateByAddingDays: (NSInteger) dDays;

- (NSDate *) dateBySubtractingDays: (NSInteger) dDays;

- (NSDate *) dateByAddingHours: (NSInteger) dHours;

- (NSDate *) dateBySubtractingHours: (NSInteger) dHours;

- (NSDate *) dateByAddingMinutes: (NSInteger) dMinutes;

- (NSDate *) dateBySubtractingMinutes: (NSInteger) dMinutes;

- (BOOL) isToday;

- (BOOL) isTomorrow;

- (BOOL) isYesterday;

- (BOOL) isTodayToDate:(NSDate*)date;

- (BOOL) isTomorrowToDate:(NSDate*)date;

- (BOOL) isYesterdayToDate:(NSDate*)date;

- (BOOL) isEqualToDateIgnoringTime: (NSDate *) aDate ;

-(NSDate*)tomorrow;

-(NSDate*)yesterday;

-(NSDate*)midnight;

-(NSInteger)ft_weekday;

+(NSString*)stringForWeekday:(NSInteger)weekday;

-(NSString*)weekdayString;

- (NSInteger) hour;

- (NSInteger) minute;

- (NSInteger) seconds;

- (NSInteger) day;

- (NSInteger) month;

- (NSInteger) week;

- (NSInteger) nthWeekday; // e.g. 2nd Tuesday of the month is 2

- (NSInteger) year;

/**
 从一天的00:00分开始，按unitTime划分时间，返回离当前时间最近的下一个单位时间
 例如，如果unitTime为15分钟，当前为11:41分，那么返回11:45分

 @param unitTime <#unitTime description#>
 @return <#return value description#>
 */
-(NSDate*)nextDateByUnit:(NSTimeInterval)unitTime;

-(NSDate*)nextDateByUnit_15min;

- (NSInteger)distanceInDaysToDate:(NSDate *)anotherDate;

//是否规则的15分钟
- (BOOL)isByUnit_15min;

@end

NS_ASSUME_NONNULL_END
