//
//  BNDatePickerViewController.m
//  FutureTripDemo
//
//  Created by Liang,Zhiyuan(GIS)2 on 2019/1/30.
//  Copyright © 2019 Liang,Zhiyuan(GIS). All rights reserved.
//
#import "CommonDefine.h"
#import "BNDatePickerViewController.h"
#import "NSDate+BNFutureTrip.h"
//#import "BNFutureTripCommon.h"
//#import "NaviTKAlertCenter.h"
#define TRIP_VIEW_BOTTOM_OFFSET 10
@interface BNDateModel : NSObject

@property (nonatomic) NSInteger year;

@property (nonatomic) NSInteger month;

@property (nonatomic) NSInteger day;

@property (nonatomic) NSInteger weekday;

@property (nonatomic,readonly) NSString * weekdayString;

@property (nonatomic) NSDate * date;

-(id)initWithDateComponents:(NSDateComponents*)comps;

@end

@implementation BNDateModel

-(id)initWithDateComponents:(NSDateComponents*)comps{
    self = [super init];
    if (self) {
        self.year = comps.year;
        self.month = comps.month;
        self.day = comps.day;
        self.weekday = comps.weekday;
    }
    return self;
}

-(NSString*)weekdayString{
//    static NSArray * weakdayArry = nil;
//    if (weakdayArry == nil) {
//        weakdayArry = @[@"周日",@"周一",@"周二",@"周三",@"周四",@"周五",@"周六"];
//    }
//
//    if (self.weekday >= 1 && self.weekday <= 7) {
//        return weakdayArry[self.weekday-1];
//    }
//    return nil;
    
    return [NSDate stringForWeekday:self.weekday];
}

@end

@interface BNDatePickerViewController ()<UIPickerViewDelegate, UIPickerViewDataSource>

#pragma mark UI components
@property (nonatomic) UIPickerView * pickerView;

@property (nonatomic) UIView * bgView;

@property (nonatomic) UIButton * cancelButton;

@property (nonatomic) UILabel * titleLabel;

@property (nonatomic) UIButton * okButton;

#pragma mark time attributes

@property (nonatomic) BOOL addStartNowForFirstRow; //在第一行加上"现在出发"

@property (nonatomic) NSArray<BNDateModel*> * dateArray;

@property (nonatomic) BOOL ignoreToday; //不显示今天

@property (nonatomic) NSInteger startHourToday;

@property (nonatomic) NSInteger startMinuteToday;

@property (nonatomic) NSNumber * comp0Index;
@property (nonatomic) NSNumber * comp1Index;
@property (nonatomic) NSNumber * comp2Index;

@property (nonatomic) NSDate * enterViewControllerDate; //进入vc的时间

@property (nonatomic) NSDate * lastSelectedFate;

@end

@implementation BNDatePickerViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    
//    NSLog(@"当前时间：%@",[NSDate GMT_date]);
    
    self.addStartNowForFirstRow = NO;
    
    [self initDateModel];
    
    self.view.backgroundColor = [UIColor clearColor]; //UIColorFromRGB(0xcc0000);
//    self.view.backgroundColor = BMThemeColor(@"BG22");
    
//    CGFloat bgWidth = ADAPTOR_VALUE_750(730);
    
    CGFloat bgWidth = ADAPTOR_VALUE_750(720);
    CGFloat bgHeight = ADAPTOR_VALUE_750(560);
    
    CGFloat bottomOffset = TRIP_VIEW_BOTTOM_OFFSET;
    CGRect bgRect = CGRectMake(([UIScreen mainScreen].bounds.size.width -bgWidth)/2, [UIScreen mainScreen].bounds.size.height - bgHeight - 10 - bottomOffset, bgWidth, bgHeight);
    _bgView = [[UIView alloc] initWithFrame:bgRect];
    _bgView.backgroundColor = [UIColor whiteColor]; //UIColorFromRGB(0xcc0000);  // BMThemeColor(@"BG22");
    [self.view addSubview:_bgView];
    _bgView.layer.masksToBounds = YES;
    _bgView.layer.cornerRadius = ADAPTOR_VALUE_750(10);;
    
    CGFloat pickerViewHeight = ADAPTOR_VALUE_750(87.5 * 4);
    _pickerView = [[UIPickerView alloc] initWithFrame:CGRectMake(0, ADAPTOR_VALUE_750(29.5 * 4), [UIScreen mainScreen].bounds.size.width, pickerViewHeight)];
    _pickerView.backgroundColor = [UIColor whiteColor]; //BMThemeColor(@"BG22");
    _pickerView.delegate = self;
    _pickerView.dataSource = self;
    [_bgView addSubview:_pickerView];
    
    UIView *pickerTopLine = [[UIView alloc] initWithFrame:CGRectMake(0, _pickerView.frame.origin.y - 1, [UIScreen mainScreen].bounds.size.width, 1)];
    pickerTopLine.backgroundColor = UIColorFromRGB(0x1effffff);//BMThemeColor(@"SL13");
    [_bgView addSubview:pickerTopLine];
    UIView *pickerBottomLine = [[UIView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(_pickerView.frame), [UIScreen mainScreen].bounds.size.width, 1)];
    pickerBottomLine.backgroundColor = pickerTopLine.backgroundColor;
    [_bgView addSubview:pickerBottomLine];
    
    CGFloat buttonWidth = ADAPTOR_VALUE_750(140);
    _cancelButton = [UIButton buttonWithType:UIButtonTypeSystem];
    _cancelButton.frame = CGRectMake(0, 0, buttonWidth, ADAPTOR_VALUE_750(90));
    [_bgView addSubview:_cancelButton];
    [_cancelButton setTitle:@"退出" forState:UIControlStateNormal];
    [_cancelButton setTitleColor:UIColorFromRGB(0x999999) forState:UIControlStateNormal];
    [_cancelButton addTarget:self action:@selector(didTapCancelButton) forControlEvents:UIControlEventTouchUpInside];
    _cancelButton.center = CGPointMake(ADAPTOR_VALUE_750(10) + buttonWidth/2, (_bgView.frame.size.height + CGRectGetMaxY(_pickerView.frame))/2);
    
    _okButton = [UIButton buttonWithType:UIButtonTypeSystem];
    _okButton.frame = CGRectMake(0, 0, _cancelButton.frame.size.width, _cancelButton.frame.size.height);
    [_okButton setTitle:@"确定" forState:UIControlStateNormal];
    [_bgView addSubview:_okButton];
    [_okButton addTarget:self action:@selector(didTapOkButton) forControlEvents:UIControlEventTouchUpInside];
    _okButton.center = CGPointMake(_bgView.frame.size.width - _cancelButton.center.x, _cancelButton.center.y);
    
    _titleLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, ADAPTOR_VALUE_750(300), ADAPTOR_VALUE_750(29.5 * 4))];
    _titleLabel.text = @"选择出发时间";
    [_titleLabel sizeToFit];
    _titleLabel.center = CGPointMake(_bgView.frame.size.width/2, ADAPTOR_VALUE_750(29.5 * 4)/2);
    
    [_bgView addSubview:_titleLabel];
    
    [self.view addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(didTapSelfView)]];
    
    
}

-(void)viewDidAppear:(BOOL)animated{
    [super viewDidAppear:animated];
    
    if (self.initialSelectedDateAligned) {
        //每次进入，picker选中的项以最晚的时间为准
        //如果进入时间大于选择时间，那么用进入时间
        //如果进入时间小于用户选择时间，那么用用户选择时间
        if ([self.enterViewControllerDate laterDate:self.initialSelectedDateAligned] == self.enterViewControllerDate) {
            self.initialSelectedDateAligned = [self.enterViewControllerDate nextDateByUnit:15 * 60];
        }
        dispatch_async(dispatch_get_main_queue(), ^{
            [self selectDate:self.initialSelectedDateAligned];
        });
    }
    
}

#define NORMAL_DISPLAY_DAY_COUNT 7 //正常的话，包括今天，显示7天时间。但如果今天没有剩余时间了，需要跳到明天的话，那么就是6天

static NSCalendarUnit defaultCalendarUnit = (NSCalendarUnitYear |
                                             NSCalendarUnitMonth |
                                             NSCalendarUnitDay|
                                             NSCalendarUnitWeekday|
                                             NSCalendarUnitHour|
                                             NSCalendarUnitMinute
                                             );

-(void)initDateModel{
    NSMutableArray * dateArray = [NSMutableArray array];
    
//    NSCalendar *gregorian = [[NSCalendar alloc] initWithCalendarIdentifier:NSCalendarIdentifierGregorian];
    NSCalendar * calendar = [NSCalendar currentCalendar];
    NSDate * now = [NSDate GMT_date];
    self.enterViewControllerDate = now;
    NSDateComponents * dateComponents = [calendar components:defaultCalendarUnit fromDate:now];
    self.startHourToday = dateComponents.hour;
    self.startMinuteToday = dateComponents.minute;
    
    if(self.startHourToday == 23 && self.startMinuteToday >= 45){
        self.ignoreToday = YES;
    }
    
    if (!self.ignoreToday) {
        BNDateModel * todayModel = [[BNDateModel alloc] initWithDateComponents:dateComponents];
        todayModel.date = now;
        [dateArray addObject:todayModel];
        //不是大于23:45，那么看是否忽略当前小时
        if (self.startMinuteToday >= 45) {
            self.startHourToday ++;
            self.startMinuteToday = 0;
        }
    }
    else {
        //越过今天，直达明天
        self.startHourToday = 0;
        self.startMinuteToday = 0;
    }
    
    NSDate * nextDate = [now dateByAddingTimeInterval:3600 * 24];
    for (int i=0; i<6; i++) {
        dateComponents =
        [calendar components:defaultCalendarUnit fromDate:nextDate];
        BNDateModel * dateModel = [[BNDateModel alloc] initWithDateComponents:dateComponents];
        dateModel.date = nextDate;
        [dateArray addObject:dateModel];
        nextDate = [nextDate dateByAddingTimeInterval:3600 * 24];
    }
    self.dateArray = dateArray;
}

- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView{
    return 3;
}

//-(BOOL)shouldIgnoreToday{
//    return self.startHourToday == 23 && self.startMinuteToday > 45;
//}

// returns the # of rows in each component..
- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component{
    
    if (component == 0) {
//        if (self.ignoreToday) {
//            //今天没有时间了
//            return 6;
//        }
//        return 7;
        return self.dateArray.count;
    }  else if (component == 1) {
        NSInteger selectedComp0 = self.comp0Index?self.comp0Index.integerValue:[pickerView selectedRowInComponent:0];
    
        if (self.addStartNowForFirstRow) {
            if ([pickerView selectedRowInComponent:0] == 0) {
                return 24 - self.startHourToday + 1; //对于“现在出发”，需要加上一个空项
            }
            else if ([pickerView selectedRowInComponent:0] == 1) {
                return 24 - self.startHourToday;
            }
            else {
                return 24;
            }
        }
        else {
            if (selectedComp0 == 0) {
                return 24 - self.startHourToday;
            }
            else {
                return 24;
            }
        }
        
        return 24;
    }else if (component == 2) {
        //15 minitues a unit
//        if ([pickerView selectedRowInComponent:0] == 0 && [pickerView selectedRowInComponent:1] == 0) {
//            return 4 - [self nextIndexOfStartMinute];
//        }
        NSInteger selectedComp0 = self.comp0Index?self.comp0Index.integerValue:[pickerView selectedRowInComponent:0];
        NSInteger selectedComp1 = self.comp1Index?self.comp1Index.integerValue:[pickerView selectedRowInComponent:1];
        
        if (self.addStartNowForFirstRow) {
            if (selectedComp0 == 0) {
                return 4 - [self nextIndexOfStartMinute] + 1;//对于“现在出发”，需要加上一个空项
            }
            else if (selectedComp1 == 1) {
                return 4 - [self nextIndexOfStartMinute];
            }
            else {
                return 4;
            }
        }
        else {
            if (selectedComp0 == 0 &&
                selectedComp1 == 0) {
                return 4 - [self nextIndexOfStartMinute];
            }
            else {
                return 4;
            }
        }
        
        return 4;
    }
    return 0;
}

- (CGFloat)pickerView:(UIPickerView *)pickerView widthForComponent:(NSInteger)component
{
    if (component == 0) {
        return self.view.frame.size.width/2;
    }
    else if (component == 1){
        return self.view.frame.size.width/6;
    }
    else {
        return self.view.frame.size.width/2 - self.view.frame.size.width/6;
    }
    return 100;
}

#pragma mark - UIPickerViewDelegate
- (nullable NSString *)pickerView:(UIPickerView *)pickerView
                      titleForRow:(NSInteger)row
                     forComponent:(NSInteger)component {
    if (component == 0) {
        if (self.addStartNowForFirstRow) {
            if (row == 0) {
                return @"现在出发";
            }
        }
        
        BNDateModel * model = (BNDateModel *)[self pickerView:pickerView objectForRow:row forComponent:component];
        
        if (self.ignoreToday) {
            if (row == 0) {
                return [NSString stringWithFormat:@"明天 %@",model.weekdayString];
            }
        }
        else {
            if (row == 0) {
                return [NSString stringWithFormat:@"今天 %@",model.weekdayString];
            }
            else if (row == 1){
                return [NSString stringWithFormat:@"明天 %@",model.weekdayString];
            }
        }
        
        return [NSString stringWithFormat:@"%ld月%ld日 %@",(long)model.month, (long)model.day,model.weekdayString];
    }
    else if (component == 1) {
        if (self.addStartNowForFirstRow){
            if([pickerView selectedRowInComponent:0] == 0) {
                //“现在出发”的场景
                if (row == 0) {
                    return nil;
                }
            }
            NSNumber * number = [self pickerView:pickerView objectForRow:row forComponent:component];
            return [NSString stringWithFormat:@"%ld",(long)number.integerValue];
        }
        else {
            NSNumber * number = [self pickerView:pickerView objectForRow:row forComponent:component];
            return [NSString stringWithFormat:@"%ld",(long)number.integerValue];
        }
    }
    else if (component == 2) {
        if (self.addStartNowForFirstRow) {
            if([pickerView selectedRowInComponent:0] == 0) {
                //“现在出发”的场景
                if (row == 0) {
                    return nil;
                }
                
            }
            NSNumber * number = [self pickerView:pickerView objectForRow:row forComponent:component];
            return [NSString stringWithFormat:@"%ld",(long)number.integerValue];
        }
        else {
            NSNumber * number = [self pickerView:pickerView objectForRow:row forComponent:component];
            return [NSString stringWithFormat:@"%02d",(long)number.integerValue];
        }
    }
    return nil;
}


/**
 获取不同的row component对应的对象

 @param pickerView <#pickerView description#>
 @param row <#row description#>
 @param component <#component description#>
 @return component_0:返回nil表示“现在出发”，返回BNDateModel表示有数据
 component2和3，返回对应的int
 */
- (nullable id)pickerView:(UIPickerView *)pickerView objectForRow:(NSInteger)row forComponent:(NSInteger)component {
    int comp0StartIndex = self.addStartNowForFirstRow?1:0;
    if (component == 0) {
        if (self.addStartNowForFirstRow) {
            if (row == 0) {
                return nil;
            }
        }
        NSInteger rowIndexShifted = row - comp0StartIndex;
        
        return [self objectForRow:rowIndexShifted forComponent:0 startHour:0 startMinute:0];
    }
    else if (component == 1) {
        if (self.addStartNowForFirstRow){
            if([pickerView selectedRowInComponent:0] == 0) {
                //“现在出发”的场景
                if (row == 0) {
                    return nil;
                }
                else {
                    return [self objectForRow:row-1 forComponent:1 startHour:self.startHourToday startMinute:self.startMinuteToday];
                }
            }
            if([pickerView selectedRowInComponent:0] == 1) {
                //今天的场景
                return [self objectForRow:row forComponent:1 startHour:self.startHourToday startMinute:self.startMinuteToday];
            }
            else {
                //明天及以后的场景
                return [self objectForRow:row forComponent:1 startHour:0 startMinute:0];
            }
        }
        else {
            if([pickerView selectedRowInComponent:0] == 0) {
                //今天的场景
                return [self objectForRow:row forComponent:1 startHour:self.startHourToday startMinute:self.startMinuteToday];
            }
            else {
                //明天及以后的场景
                return [self objectForRow:row forComponent:1 startHour:0 startMinute:0];
            }
        }
    }
    else if (component == 2) {
        if (self.addStartNowForFirstRow) {
            if([pickerView selectedRowInComponent:0] == 0) {
                //“现在出发”的场景
                if (row == 0) {
                    return nil;
                }
                else {
                    return [self objectForRow:row-1 forComponent:2 startHour:self.startHourToday startMinute:self.startMinuteToday];
                }
            }
            else if([pickerView selectedRowInComponent:0] == 1) {
                //今天的场景
                return [self objectForRow:row forComponent:2 startHour:self.startHourToday startMinute:self.startMinuteToday];
            }
            else {
                //明天及以后的场景
                return [self objectForRow:row forComponent:2 startHour:0 startMinute:0];
            }
        }
        else {
            if([pickerView selectedRowInComponent:0] == 0&&
               [pickerView selectedRowInComponent:1] == 0) {
                //今天的场景
                return [self objectForRow:row forComponent:2 startHour:self.startHourToday startMinute:self.startMinuteToday];
            }
            else {
                //明天及以后的场景
                return [self objectForRow:row forComponent:2 startHour:0 startMinute:0];
            }
        }
    }
    return nil;
}


-(nullable id)objectForRow:(NSInteger)row forComponent:(NSInteger)component startHour:(NSInteger)startHour startMinute:(NSInteger)startMinute{
    if (component == 0) {
        BNDateModel * model = self.dateArray[row];
        return model;
    }
    else if (component == 1) {
        
        NSInteger hour = startHour + row;
        
        return @(hour);
    }
    else if (component == 2) {
        NSInteger minute = ([self nextIndexOfMinute:startMinute] + row) * 15;
        
        return @(minute);
        
    }
    return nil;
}

/**
 根据当前的minute，返回对应的下一个index，以15为单位 ,例如
 0->0
 8->1
 15->1
 16->2
 30->2
 40->3
 45->进入下一周期

 @return <#return value description#>
 */
-(NSUInteger)nextIndexOfMinute:(NSInteger)minute{
    NSUInteger next = ceil((float)minute/15.);
    return next;
}

-(NSUInteger)nextIndexOfStartMinute{
    return [self nextIndexOfMinute:self.startMinuteToday];
}

- (CGFloat)pickerView:(UIPickerView *)pickerView rowHeightForComponent:(NSInteger)component
{
    return 35.0f;
}

- (void)pickerView:(UIPickerView *)pickerView
      didSelectRow:(NSInteger)row
       inComponent:(NSInteger)component {
    self.comp0Index = nil;
    self.comp1Index = nil;
    self.comp2Index = nil;
    
    if (component == 0) {
        [pickerView reloadComponent:1];
        [pickerView reloadComponent:2];
        
        if (row == 0) {
            //如果当前是“现在出发”， 必须选回空行
            [pickerView selectRow:0 inComponent:1 animated:NO];
            [pickerView selectRow:0 inComponent:2 animated:NO];
        }
    }
    else if (component == 1) {
        if (self.addStartNowForFirstRow) {
            [pickerView reloadComponent:2];
            
            if ([pickerView selectedRowInComponent:0]==0) {
                //如果当前是“现在出发”， 必须选回空行
                [pickerView selectRow:0 inComponent:1 animated:YES];
            }
        }
        else {
            [pickerView reloadComponent:2];
        }
        
    }
    else{
        if (self.addStartNowForFirstRow) {
            if ([pickerView selectedRowInComponent:0]==0) {
                //如果当前是“现在出发”， 必须选回空行
                [pickerView selectRow:0 inComponent:2 animated:YES];
            }
        }
        else {
            //todo
        }
    }
    
    if (component == 0) {
        if (!self.lastSelectedFate) {
            self.lastSelectedFate = self.initialSelectedDateAligned;
        }
        NSTimeInterval seltime = [self.selectedDate.midnight timeIntervalSince1970] + [self.lastSelectedFate timeIntervalSinceDate:self.lastSelectedFate.midnight];
        NSDate * newDate = [NSDate dateWithTimeIntervalSince1970:seltime];
        if ([newDate earlierDate:self.enterViewControllerDate] == newDate) {
            newDate = [self.enterViewControllerDate nextDateByUnit_15min];
        }
        [self selectDate:newDate];
    }
    else if (component == 1) {
        if (!self.lastSelectedFate) {
            self.lastSelectedFate = self.initialSelectedDateAligned;
        }
        
        NSTimeInterval timeHourAligned = (((long long)[self.selectedDate timeIntervalSince1970])/3600) * 3600;
        NSTimeInterval lastSelectMinute = (((long long)[self.lastSelectedFate timeIntervalSince1970])%3600);
        
        NSDate * newDate = [NSDate dateWithTimeIntervalSince1970:timeHourAligned + lastSelectMinute];
        [self selectDate:newDate];
    }
    
    self.lastSelectedFate = self.selectedDate;
}

-(void)selectDate:(NSDate*)date{
    if (self.dateArray.count == 0) {
        return;
    }
    NSDate * day0 = self.dateArray[0].date;
    
    NSInteger dDay = [date distanceInDaysToDate:day0];
    
    NSInteger comp0Idx = dDay;
    
    NSInteger hour = date.hour;
//    if (date.minute >= 45) {
//        hour ++;
//    }
    
    NSInteger firstHour = ((NSNumber*)[self objectForRow:0 forComponent:1 startHour:0 startMinute:0]).integerValue;
    
    NSInteger comp1Idx = hour - (comp0Idx == 0?self.startHourToday:firstHour);
    
    NSInteger min = date.minute;
    if (date.minute > 45) {
        min = 0;
    }
    
    NSInteger comp2Idx = [self nextIndexOfMinute:min] ;//- [self nextIndexOfStartMinute];
    if (comp0Idx == 0 && comp1Idx == 0) {
        comp2Idx = comp2Idx -  [self nextIndexOfStartMinute];
    }
    
    [self.pickerView selectRow:comp0Idx inComponent:0 animated:NO];
    [self safe_pickerViewSelectRow:comp1Idx inComponent:1];
    [self safe_pickerViewSelectRow:comp2Idx inComponent:2];
    
//    [self.pickerView selectRow:comp1Idx inComponent:1 animated:NO];
//    [self.pickerView reloadComponent:1];
//    [self.pickerView selectRow:comp1Idx inComponent:1 animated:NO];
//
//    [self.pickerView selectRow:comp2Idx inComponent:2 animated:NO];
//    [self.pickerView reloadComponent:2];
//    [self.pickerView selectRow:comp2Idx inComponent:2 animated:NO];
    
    self.comp0Index = @(comp0Idx);
    self.comp1Index = @(comp1Idx);
    self.comp2Index = @(comp2Idx);
    
//    [self.pickerView reloadAllComponents];
}


/**
 因为需要同时改变num和selectedRow，必须要用这种方法workaround

 @param row <#row description#>
 @param comp <#comp description#>
 */
-(void)safe_pickerViewSelectRow:(NSInteger)row inComponent:(NSInteger)comp{
//    NSLog(@"safe_pickerViewSelectRow %d %d",row, comp)
    if (row >= 0 && comp >= 0) {
        [self.pickerView selectRow:row inComponent:comp animated:NO];
        [self.pickerView reloadComponent:comp];
        [self.pickerView selectRow:row inComponent:comp animated:NO];
    }
}

-(NSDate*)selectedDate{
    NSInteger selectedRow_comp0 = [_pickerView selectedRowInComponent:0];
    NSInteger selectedRow_comp1 = [_pickerView selectedRowInComponent:1];
    NSInteger selectedRow_comp2 = [_pickerView selectedRowInComponent:2];
    
    BNDateModel * objOfComp0 = [self pickerView:_pickerView objectForRow:selectedRow_comp0 forComponent:0];
    NSNumber * valueOfComp1 = [self pickerView:_pickerView objectForRow:selectedRow_comp1 forComponent:1];
    NSNumber * valueOfComp2 = [self pickerView:_pickerView objectForRow:selectedRow_comp2 forComponent:2];
    
    if (!objOfComp0) {
        return [NSDate GMT_date];
    }
    
    NSDateComponents * comps = [[NSDateComponents alloc] init];
    [comps setYear:objOfComp0.year];
    [comps setMonth:objOfComp0.month];
    [comps setDay:objOfComp0.day];
    [comps setHour:valueOfComp1.integerValue];
    [comps setMinute:valueOfComp2.integerValue];
    
    NSCalendar *calendar = [NSCalendar currentCalendar];
    NSDate * selectedDate = [calendar dateFromComponents:comps];
    
    return selectedDate;
}

-(void)dismiss{
    [self dismissViewControllerAnimated:NO completion:^{
        if ([self.delegate respondsToSelector:@selector(datePickerDidDismiss:)]) {
            [self.delegate datePickerDidDismiss:self];
        }
    }];
}

#pragma mark button handler
-(void)didTapSelfView{
    [self dismiss];
}

-(void)didTapCancelButton{
    [self dismiss];
}

-(void)didTapOkButton{
//#ifdef DEBUG
//    NSDate * selectedDate = self.selectedDate;
//    NSLog(@"selected date: %@",selectedDate);
//    return;
//#endif
    NSDate * selectedDate = self.selectedDate;
    
//    NSLog(@"did tap ok with selected date: %@",selectedDate)
    
    NSDate * now = [NSDate GMT_date];
    if ([now earlierDate:selectedDate] == selectedDate) {
//        BNShowToast(@"出发时间不能早于当前时刻");
        NSLog(@"出发时间不能早于当前时刻, 当前时刻%@",now);
        return;
    }
    
    if ([self.delegate respondsToSelector:@selector(datePickerDidOK:)]) {
        [self.delegate datePickerDidOK:self];
    }
    
    [self dismissViewControllerAnimated:NO completion:^{
        if ([self.delegate respondsToSelector:@selector(datePickerDidDismiss:)]) {
            [self.delegate datePickerDidDismiss:self];
        }
    }];
}

@end

@interface BNArrialDatePickerViewController ()<UIPickerViewDelegate, UIPickerViewDataSource>

#pragma mark UI components
@property (nonatomic) UIPickerView * pickerView;

@property (nonatomic) UIView * bgView;

@property (nonatomic) UIButton * cancelButton;

@property (nonatomic) UILabel * titleLabel;

@property (nonatomic) UILabel * subTitleLabel;

@property (nonatomic) UIButton * okButton;

#pragma mark time attributes

//@property (nonatomic) BOOL addStartNowForFirstRow; //在第一行加上"现在出发"

@property (nonatomic) NSArray<BNDateModel*> * dateArray;

@property (nonatomic) BOOL ignoreToday; //不显示今天

@property (nonatomic) NSInteger startHourToday;

@property (nonatomic) NSInteger startMinuteToday;

@property (nonatomic) NSNumber * comp0Index;
@property (nonatomic) NSNumber * comp1Index;
@property (nonatomic) NSNumber * comp2Index;

@property (nonatomic) NSDate * enterViewControllerDate; //进入vc的时间

@property (nonatomic) NSDate * miniData;
@property (nonatomic) NSDate * focusData;

@property (nonatomic) NSDate*  showArrialDate;//展示的到达时间

@property (nonatomic,assign) NSTimeInterval miniTimeCost;//当前光柱图里最小的eat

@property (nonatomic) NSDate * lastSelectedFate;

@property (nonatomic) BOOL hasInsertMinute; //分钟面板插入不规则时刻

@property (nonatomic) NSString *nowArrialTime;

@end

@implementation BNArrialDatePickerViewController

- (id)initWithShownArrialDate:(NSDate*)showArrialDate miniTimeCost:(NSTimeInterval)timeCost nowArrialTime:(NSString*)time
{
    self = [super init];
    if(self)
    {
        self.showArrialDate = showArrialDate;
        self.miniTimeCost = timeCost;
        self.nowArrialTime = time;
    }
    
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    
//    NSLog(@"当前时间：%@",[NSDate GMT_date]);
    
    [self initDateModel];
    
    self.view.backgroundColor = UIColorFromRGB(0x111111);
//    self.view.backgroundColor = BMThemeColor(@"BG22");
    
    CGFloat bgWidth = ADAPTOR_VALUE_750(730);
//    CGFloat bgWidth = BNFT_COMMON_VIEW_WIDTH;
    CGFloat bgHeight = ADAPTOR_VALUE_750(560);
    
    CGFloat bottomOffset = TRIP_VIEW_BOTTOM_OFFSET;
    CGRect bgRect = CGRectMake(([UIScreen mainScreen].bounds.size.width -bgWidth)/2, [UIScreen mainScreen].bounds.size.height - bgHeight - 10 - bottomOffset, bgWidth, bgHeight);
    _bgView = [[UIView alloc] initWithFrame:bgRect];
    _bgView.backgroundColor = UIColorFromRGB(0x242424); //BMThemeColor(@"BG51");
    [self.view addSubview:_bgView];
    _bgView.layer.masksToBounds = YES;
    _bgView.layer.cornerRadius = ADAPTOR_VALUE_750(10);
    
    CGFloat pickerViewHeight = ADAPTOR_VALUE_750(87.5 * 4);
    _pickerView = [[UIPickerView alloc] initWithFrame:CGRectMake(0, ADAPTOR_VALUE_750(29.5 * 4), [UIScreen mainScreen].bounds.size.width, pickerViewHeight)];
    _pickerView.backgroundColor = UIColorFromRGB(0x242424); // BMThemeColor(@"BG51");
    _pickerView.delegate = self;
    _pickerView.dataSource = self;
    [_bgView addSubview:_pickerView];
    
    UIView *pickerTopLine = [[UIView alloc] initWithFrame:CGRectMake(0, _pickerView.frame.origin.y - 1, [UIScreen mainScreen].bounds.size.width, 1)];
    pickerTopLine.backgroundColor = UIColorFromRGB(0x1effffff); // BMThemeColor(@"SL13");
    [_bgView addSubview:pickerTopLine];
    UIView *pickerBottomLine = [[UIView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(_pickerView.frame), [UIScreen mainScreen].bounds.size.width, 1)];
    pickerBottomLine.backgroundColor = pickerTopLine.backgroundColor;
    [_bgView addSubview:pickerBottomLine];
    
    CGFloat buttonWidth = ADAPTOR_VALUE_750(140);
    _cancelButton = [UIButton buttonWithType:UIButtonTypeSystem];
    _cancelButton.frame = CGRectMake(0, 0, buttonWidth, ADAPTOR_VALUE_750(90));
    [_bgView addSubview:_cancelButton];
    [_cancelButton setTitle:@"退出" forState:UIControlStateNormal];
    [_cancelButton setTitleColor:UIColorFromRGB(0x4cffffff) forState:UIControlStateNormal]; //BMThemeColor(@"L31")
    [_cancelButton addTarget:self action:@selector(didTapCancelButton) forControlEvents:UIControlEventTouchUpInside];
    _cancelButton.center = CGPointMake(ADAPTOR_VALUE_750(10) + buttonWidth/2, (_bgView.frame.size.height + CGRectGetMaxY(_pickerView.frame))/2);
    
    _okButton = [UIButton buttonWithType:UIButtonTypeSystem];
    _okButton.frame = CGRectMake(0, 0, _cancelButton.frame.size.width, _cancelButton.frame.size.height);
    [_okButton setTitle:@"确定" forState:UIControlStateNormal];
    [_bgView addSubview:_okButton];
    [_okButton addTarget:self action:@selector(didTapOkButton) forControlEvents:UIControlEventTouchUpInside];
    _okButton.center = CGPointMake(_bgView.frame.size.width - _cancelButton.center.x, _cancelButton.center.y);

    _titleLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, ADAPTOR_VALUE_750(300), ADAPTOR_VALUE_750(29.5 * 4))];
    _titleLabel.text = @"选择到达时间";
    [_titleLabel sizeToFit];
    _titleLabel.center = CGPointMake(_bgView.frame.size.width/2, ADAPTOR_VALUE_750(29.5 * 4)/2);
    
    [_bgView addSubview:_titleLabel];
    
    [self.view addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(didTapSelfView)]];
    
    
}

//-(void)viewDidAppear:(BOOL)animated{
//    [super viewDidAppear:animated];
//
//    if (self.initialSelectedDateAligned) {
//        //每次进入，picker选中的项以最晚的时间为准
//        //如果进入时间大于选择时间，那么用进入时间
//        //如果进入时间小于用户选择时间，那么用用户选择时间
//        if ([self.enterViewControllerDate laterDate:self.initialSelectedDateAligned] == self.enterViewControllerDate) {
//            self.initialSelectedDateAligned = [self.enterViewControllerDate nextDateByUnit:15 * 60];
//        }
//        dispatch_async(dispatch_get_main_queue(), ^{
//            [self selectDate:self.initialSelectedDateAligned];
//        });
//    }
//
//}

//#define NORMAL_DISPLAY_DAY_COUNT 7 //正常的话，包括今天，显示7天时间。但如果今天没有剩余时间了，需要跳到明天的话，那么就是6天
//
//static NSCalendarUnit defaultCalendarUnit = (NSCalendarUnitYear |
//                                             NSCalendarUnitMonth |
//                                             NSCalendarUnitDay|
//                                             NSCalendarUnitWeekday|
//                                             NSCalendarUnitHour|
//                                             NSCalendarUnitMinute
//                                             );

-(void)initDateModel{
    
//每次进入到达面板，面板最小值=（当前时刻+当前光柱图时间耗费最小值）nextDateByUnit_15min
   self.miniData = [NSDate dateWithTimeIntervalSinceNow:_miniTimeCost];
   if(![self.miniData isByUnit_15min])
   {
       self.miniData = [self.miniData nextDateByUnit_15min];
   }
   
   
   //每次进入到达面板，面板焦点值=外部显示的到达时间或面板最小值
   NSCalendar * calendar = [NSCalendar currentCalendar];
   NSDate * now = [NSDate GMT_date];
   self.focusData = self.showArrialDate;
   if (!self.showArrialDate)//如果到达时间显示的是--:--
   {
       self.focusData = self.miniData;
   }
   if([self.focusData earlierDate:self.miniData] == self.focusData)
   {
       //如果到达时间大于当前时间，那么到达时间最为最小值插入
//       if([self.focusData laterDate:now] == self.focusData)
//       {
//          self.miniData = self.focusData;
//       }
//       else
       {
           self.focusData = self.miniData;
       }
   }
   
   
   //这时pickView还没创建，等加载完
   dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
       [self selectDate:self.focusData];
   });
   
   //根据面板最小时间算全部日期和开始小时和分
   NSDateComponents * dateComponents = [calendar components:defaultCalendarUnit fromDate:self.miniData];
   self.startHourToday = dateComponents.hour;
   self.startMinuteToday = dateComponents.minute;
//   if(self.startHourToday == 23 && self.startMinuteToday >= 45){
//       self.ignoreToday = YES;
//   }
    //最小时间是明天
   if (![self.miniData isToday])
   {
       self.ignoreToday = YES;
   }
   
   NSMutableArray * dateArray = [NSMutableArray array];
   if (!self.ignoreToday) {
       BNDateModel * todayModel = [[BNDateModel alloc] initWithDateComponents:dateComponents];
       todayModel.date = now;
       [dateArray addObject:todayModel];
       //不是大于23:45，那么看是否忽略当前小时
       if (self.startMinuteToday > 45 && [self.focusData isByUnit_15min])//如果需要插入不规则时刻，这里不能以45作为结束
       {
           self.startHourToday ++;
           self.startMinuteToday = 0;
       }
   }
   else {
       //越过今天，直达明天
//       self.startHourToday = 0;
//       self.startMinuteToday = 0;
   }
   
   NSDate * nextDate = [now dateByAddingTimeInterval:3600 * 24];
   for (int i=0; i<6; i++) {
       dateComponents =
       [calendar components:defaultCalendarUnit fromDate:nextDate];
       BNDateModel * dateModel = [[BNDateModel alloc] initWithDateComponents:dateComponents];
       dateModel.date = nextDate;
       [dateArray addObject:dateModel];
       nextDate = [nextDate dateByAddingTimeInterval:3600 * 24];
   }
   self.dateArray = dateArray;
}

- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView{
    return 3;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component{
    
    if (component == 0) {
        return self.dateArray.count;
    }  else if (component == 1) {
        NSInteger selectedComp0 = self.comp0Index?self.comp0Index.integerValue:[pickerView selectedRowInComponent:0];
        if (selectedComp0 == 0) {
            return 24 - self.startHourToday;
        }
        else {
            return 24;
        }
    }else if (component == 2) {
        NSInteger selectedComp0 = self.comp0Index?self.comp0Index.integerValue:[pickerView selectedRowInComponent:0];
        NSInteger selectedComp1 = self.comp1Index?self.comp1Index.integerValue:[pickerView selectedRowInComponent:1];
        if (selectedComp0 == 0 &&
            selectedComp1 == 0)
        {
            //当选中时间是不规则的15分钟，需要插入一个新分钟
            if(![self.focusData isByUnit_15min] && [self bFocusDataIsSelected])
            {
                return 4 - [self nextIndexOfStartMinute]+1;
            }
            else
            {
                return 4 - [self nextIndexOfStartMinute];
            }
        }
        else
        {
            if(![self.focusData isByUnit_15min] && [self bFocusDataIsSelected])
            {
                return 4+1;
            }
            else
            {
                return 4;
            }
        }
    }
    return 0;
}

- (CGFloat)pickerView:(UIPickerView *)pickerView widthForComponent:(NSInteger)component
{
    if (component == 0) {
        return self.view.frame.size.width/2;
    }
    else if (component == 1){
        return self.view.frame.size.width/6;
    }
    else {
        return self.view.frame.size.width/2 - self.view.frame.size.width/6;
    }
    return 100;
}

#pragma mark - UIPickerViewDelegate
- (nullable NSString *)pickerView:(UIPickerView *)pickerView
                      titleForRow:(NSInteger)row
                     forComponent:(NSInteger)component {
    if (component == 0) {
        BNDateModel * model = (BNDateModel *)[self pickerView:pickerView objectForRow:row forComponent:component];
        
        if (self.ignoreToday) {
            if (row == 0) {
                return [NSString stringWithFormat:@"明天 %@",model.weekdayString];
            }
        }
        else {
            if (row == 0) {
                return [NSString stringWithFormat:@"今天 %@",model.weekdayString];
            }
            else if (row == 1){
                return [NSString stringWithFormat:@"明天 %@",model.weekdayString];
            }
        }
        
        return [NSString stringWithFormat:@"%ld月%ld日 %@",(long)model.month, (long)model.day,model.weekdayString];
    }
    else if (component == 1) {
        NSNumber * number = [self pickerView:pickerView objectForRow:row forComponent:component];
        return [NSString stringWithFormat:@"%ld",(long)number.integerValue];
        
    }
    else if (component == 2) {
        NSNumber * number = [self pickerView:pickerView objectForRow:row forComponent:component];
        return [NSString stringWithFormat:@"%02d",(long)number.integerValue];
        
    }
    return nil;
}


/**
 获取不同的row component对应的对象

 @param pickerView <#pickerView description#>
 @param row <#row description#>
 @param component <#component description#>
 @return component_0:返回nil表示“现在出发”，返回BNDateModel表示有数据
 component2和3，返回对应的int
 */
- (nullable id)pickerView:(UIPickerView *)pickerView objectForRow:(NSInteger)row forComponent:(NSInteger)component {
    int comp0StartIndex = 0;
    if (component == 0) {
        NSInteger rowIndexShifted = row - comp0StartIndex;
        
        return [self objectForRow:rowIndexShifted forComponent:0 startHour:0 startMinute:0];
    }
    else if (component == 1) {
        if([pickerView selectedRowInComponent:0] == 0) {
            //今天的场景
            return [self objectForRow:row forComponent:1 startHour:self.startHourToday startMinute:self.startMinuteToday];
        }
        else {
            //明天及以后的场景
            return [self objectForRow:row forComponent:1 startHour:0 startMinute:0];
        }
    }
    else if (component == 2) {
        if([pickerView selectedRowInComponent:0] == 0&&
           [pickerView selectedRowInComponent:1] == 0) {
            //今天的场景
//            if(self.startMinuteToday > [self.focusData minute])
//            {
//                self.startMinuteToday = [self.focusData minute];
//            }
            return [self objectForRow:row forComponent:2 startHour:self.startHourToday startMinute:self.startMinuteToday];
        }
        else {
            //明天及以后的场景
            return [self objectForRow:row forComponent:2 startHour:0 startMinute:0];
        }
    }
    return nil;
}


-(nullable id)objectForRow:(NSInteger)row forComponent:(NSInteger)component startHour:(NSInteger)startHour startMinute:(NSInteger)startMinute{
    if (component == 0) {
        BNDateModel * model = self.dateArray[row];
        return model;
    }
    else if (component == 1) {
        
        NSInteger hour = startHour + row;
        
        return @(hour);
    }
    else if (component == 2) {
        
        NSInteger minute = ([self nextIndexOfMinute:startMinute] + row) * 15;
        BOOL bInsert = NO;
        if([self bFocusDataIsSelected])
        {
            //插入不规则时刻分钟的数值计算
            if(![self.focusData isByUnit_15min] && minute > [self.focusData minute])
            {
                NSInteger insertMinute = [self.focusData minute];
                //估计插入时刻最近的那个单位15
                if((insertMinute/15+1)*15 == minute)
                {
                    minute = insertMinute;
                    bInsert = YES;
                }
                else if(minute > (insertMinute/15+1)*15)//大于
                {
                    minute = ([self nextIndexOfMinute:startMinute] + row ) * 15-15;
                    bInsert = YES;
                }
            }
        }
        
        //解决滚动不到最小小时的问题
        if (!bInsert && minute > 45)
        {
            minute = startMinute;
        }
        return @(minute);
        
    }
    return nil;
}

/**
 根据当前的minute，返回对应的下一个index，以15为单位 ,例如
 0->0
 8->1
 15->1
 16->2
 30->2
 40->3
 45->进入下一周期

 @return <#return value description#>
 */
-(NSUInteger)nextIndexOfMinute:(NSInteger)minute{
    NSUInteger next = ceil((float)minute/15.);
    return next;
}

-(NSUInteger)nextIndexOfStartMinute{
    return [self nextIndexOfMinute:self.startMinuteToday];
}

- (CGFloat)pickerView:(UIPickerView *)pickerView rowHeightForComponent:(NSInteger)component
{
    return 35.0f;
}

- (void)pickerView:(UIPickerView *)pickerView
      didSelectRow:(NSInteger)row
       inComponent:(NSInteger)component {
    self.comp0Index = nil;
    self.comp1Index = nil;
    self.comp2Index = nil;
    
    if (component == 0) {
        [pickerView reloadComponent:1];
        [pickerView reloadComponent:2];
        
        if (row == 0) {
            //如果当前是“现在出发”， 必须选回空行
            [pickerView selectRow:0 inComponent:1 animated:NO];
            [pickerView selectRow:0 inComponent:2 animated:NO];
        }
    }
    else if (component == 1) {
        
            [pickerView reloadComponent:2];
    }
    else{

    }
    
    if (component == 0) {
        if (!self.lastSelectedFate) {
            self.lastSelectedFate = self.focusData;
        }
        
        NSTimeInterval seltime = [self.selectedDate.midnight timeIntervalSince1970] + [self.lastSelectedFate timeIntervalSinceDate:self.lastSelectedFate.midnight];
        NSDate * newDate = [NSDate dateWithTimeIntervalSince1970:seltime];
        if ([newDate earlierDate:self.miniData] == newDate) {
            newDate = self.miniData;
        }
        [self selectDate:newDate];
    }
    else if (component == 1) {

        if (!self.lastSelectedFate) {
            self.lastSelectedFate = self.focusData;
        }
        
        NSTimeInterval timeHourAligned = (((long long)[self.selectedDate timeIntervalSince1970])/3600) * 3600;
        NSTimeInterval lastSelectMinute = (((long long)[self.lastSelectedFate timeIntervalSince1970])%3600);
        
        NSDate * newDate = [NSDate dateWithTimeIntervalSince1970:timeHourAligned + lastSelectMinute];
        [self selectDate:newDate];
    }
    self.lastSelectedFate = self.selectedDate;;
}

-(void)selectDate:(NSDate*)date{
    if (self.dateArray.count == 0) {
        return;
    }
    NSDate * day0 = self.dateArray[0].date;
    
    NSInteger dDay = [date distanceInDaysToDate:day0];
    
    NSInteger comp0Idx = dDay;
    
    NSInteger hour = date.hour;
    
    NSInteger firstHour = ((NSNumber*)[self objectForRow:0 forComponent:1 startHour:0 startMinute:0]).integerValue;
    
    NSInteger comp1Idx = hour - (comp0Idx == 0?self.startHourToday:firstHour);
    
    NSInteger min = date.minute;
    if (date.minute > 45 && [self.focusData isByUnit_15min]) {
        min = 0;
    }
    
    NSInteger comp2Idx = [self nextIndexOfMinute:min] ;//- [self nextIndexOfStartMinute];
    if (comp0Idx == 0 && comp1Idx == 0) {
        comp2Idx = comp2Idx -  [self nextIndexOfStartMinute];
    }
    
    [self.pickerView selectRow:comp0Idx inComponent:0 animated:NO];
    [self safe_pickerViewSelectRow:comp1Idx inComponent:1];
    [self safe_pickerViewSelectRow:comp2Idx inComponent:2];
    
//    [self.pickerView selectRow:comp1Idx inComponent:1 animated:NO];
//    [self.pickerView reloadComponent:1];
//    [self.pickerView selectRow:comp1Idx inComponent:1 animated:NO];
//
//    [self.pickerView selectRow:comp2Idx inComponent:2 animated:NO];
//    [self.pickerView reloadComponent:2];
//    [self.pickerView selectRow:comp2Idx inComponent:2 animated:NO];
    
    self.comp0Index = @(comp0Idx);
    self.comp1Index = @(comp1Idx);
    self.comp2Index = @(comp2Idx);
    
//    [self.pickerView reloadAllComponents];
}

//当前滚动到的是不是进入时的焦点的日期小时
-(BOOL)bFocusDataIsSelected
{
    BOOL ret = NO;
    NSInteger selectedRow_comp0 = [_pickerView selectedRowInComponent:0];
    BNDateModel * dateModel = [self pickerView:_pickerView objectForRow:selectedRow_comp0 forComponent:0];
    if(dateModel.date.day == self.focusData.day)
    {
        NSInteger hour;
        NSInteger selectedRow_comp1 = [_pickerView selectedRowInComponent:1];
        NSNumber * valueOfComp1 = [self pickerView:_pickerView objectForRow:selectedRow_comp1 forComponent:1];
        hour = valueOfComp1.integerValue;
        
        if(hour == [self.focusData hour])
        {
            ret = YES;
        }
    }

    return ret;
}


/**
 因为需要同时改变num和selectedRow，必须要用这种方法workaround

 @param row <#row description#>
 @param comp <#comp description#>
 */
-(void)safe_pickerViewSelectRow:(NSInteger)row inComponent:(NSInteger)comp{
//    NSLog(@"safe_pickerViewSelectRow %d %d",row, comp)
    if (row >= 0 && comp >= 0) {
        [self.pickerView selectRow:row inComponent:comp animated:NO];
        [self.pickerView reloadComponent:comp];
        [self.pickerView selectRow:row inComponent:comp animated:NO];
    }
}

-(NSDate*)selectedDate{
    NSInteger selectedRow_comp0 = [_pickerView selectedRowInComponent:0];
    NSInteger selectedRow_comp1 = [_pickerView selectedRowInComponent:1];
    NSInteger selectedRow_comp2 = [_pickerView selectedRowInComponent:2];
    
    BNDateModel * objOfComp0 = [self pickerView:_pickerView objectForRow:selectedRow_comp0 forComponent:0];
    NSNumber * valueOfComp1 = [self pickerView:_pickerView objectForRow:selectedRow_comp1 forComponent:1];
    NSNumber * valueOfComp2 = [self pickerView:_pickerView objectForRow:selectedRow_comp2 forComponent:2];
    
    if (!objOfComp0) {
        return [NSDate GMT_date];
    }
    
    NSDateComponents * comps = [[NSDateComponents alloc] init];
    [comps setYear:objOfComp0.year];
    [comps setMonth:objOfComp0.month];
    [comps setDay:objOfComp0.day];
    [comps setHour:valueOfComp1.integerValue];
    [comps setMinute:valueOfComp2.integerValue];
    
    NSCalendar *calendar = [NSCalendar currentCalendar];
    NSDate * selectedDate = [calendar dateFromComponents:comps];
    
    return selectedDate;
}

-(void)dismiss{
    [self dismissViewControllerAnimated:NO completion:^{
        if ([self.delegate respondsToSelector:@selector(datePickerDidDismiss:)]) {
            [self.delegate datePickerDidDismiss:self];
        }
    }];
}

#pragma mark button handler
-(void)didTapSelfView{
    [self dismiss];
}

-(void)didTapCancelButton{
    [self dismiss];
}

-(void)didTapOkButton{
//#ifdef DEBUG
//    NSDate * selectedDate = self.selectedDate;
//    NSLog(@"selected date: %@",selectedDate);
//    return;
//#endif
    NSDate * selectedDate = self.selectedDate;
//    NSLog(@"did tap ok with selected date: %@",selectedDate)
    //当前时间+最小eat>到达面板时间>当前时间，给toast1
    //到达面板时间<当前时间 ，给toast2
    NSDate * now = [NSDate GMT_date];
    if ([now earlierDate:selectedDate] == selectedDate) {
//        BNShowToast(@"到达时间不能早于当前时刻");
        NSLog(@"到达时间不能早于当前时刻, 当前时刻%@",now);
        return;
    } else if ( [selectedDate timeIntervalSince1970] < (self.miniTimeCost + [now timeIntervalSince1970]) )
    {
//        BNShowToast(@"当前时间无法到达，请重新设置");
        return;
    }
    
    if ([self.delegate respondsToSelector:@selector(dateArrialPickerDidTapOk:)]) {
        [self.delegate dateArrialPickerDidTapOk:self];
    }
    
    [self dismissViewControllerAnimated:NO completion:^{
        if ([self.delegate respondsToSelector:@selector(dateArrialPickerDidDismiss:)]) {
            [self.delegate dateArrialPickerDidDismiss:self];
        }
    }];
}

@end

@interface BNStartDatePickerViewController ()<UIPickerViewDelegate, UIPickerViewDataSource>

#pragma mark UI components
@property (nonatomic) UIPickerView * pickerView;

@property (nonatomic) UIView * bgView;

@property (nonatomic) UIButton * cancelButton;

@property (nonatomic) UILabel * titleLabel;

@property (nonatomic) UIButton * okButton;

#pragma mark time attributes

//@property (nonatomic) BOOL addStartNowForFirstRow; //在第一行加上"现在出发"

@property (nonatomic) NSArray<BNDateModel*> * dateArray;

@property (nonatomic) BOOL ignoreToday; //不显示今天

@property (nonatomic) NSInteger startHourToday;

@property (nonatomic) NSInteger startMinuteToday;

@property (nonatomic) NSNumber * comp0Index;
@property (nonatomic) NSNumber * comp1Index;
@property (nonatomic) NSNumber * comp2Index;

@property (nonatomic) NSDate * enterViewControllerDate; //进入vc的时间

@property (nonatomic) NSDate * miniData;
@property (nonatomic) NSDate * focusData;

@property (nonatomic) NSDate*  showStartDate;//展示的到达时间
//
//@property (nonatomic,assign) NSTimeInterval miniTimeCost;//当前光柱图里最小的eat

@property (nonatomic) NSDate * lastSelectedFate;

@property (nonatomic) BOOL hasInsertMinute; //分钟面板插入不规则时刻

@end

@implementation BNStartDatePickerViewController

- (id)initWithShownStartDate:(NSDate*)showStartDate
{
    self = [super init];
    if(self)
    {
        self.showStartDate = showStartDate;
    }
    
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    
    NSLog(@"当前时间：%@",[NSDate GMT_date]);
    
    [self initDateModel];
    
    self.view.backgroundColor = UIColorFromRGB(0x111111);
//    self.view.backgroundColor = BMThemeColor(@"BG22");
    
    CGFloat bgWidth = ADAPTOR_VALUE_750(730);
//    CGFloat bgWidth = BNFT_COMMON_VIEW_WIDTH;
    CGFloat bgHeight = ADAPTOR_VALUE_750(560);
    
    CGFloat bottomOffset = TRIP_VIEW_BOTTOM_OFFSET;
    CGRect bgRect = CGRectMake(([UIScreen mainScreen].bounds.size.width -bgWidth)/2, [UIScreen mainScreen].bounds.size.height - bgHeight - 10 - bottomOffset, bgWidth, bgHeight);
    _bgView = [[UIView alloc] initWithFrame:bgRect];
    _bgView.backgroundColor = UIColorFromRGB(0x111111); //BMThemeColor(@"BG51");
    [self.view addSubview:_bgView];
    _bgView.layer.masksToBounds = YES;
    _bgView.layer.cornerRadius = ADAPTOR_VALUE_750(10);;
    
    CGFloat pickerViewHeight = ADAPTOR_VALUE_750(87.5 * 4);
    _pickerView = [[UIPickerView alloc] initWithFrame:CGRectMake(0, ADAPTOR_VALUE_750(139), [UIScreen mainScreen].bounds.size.width, pickerViewHeight)];
    _pickerView.backgroundColor = UIColorFromRGB(0x111111); //BMThemeColor(@"BG51");
    _pickerView.delegate = self;
    _pickerView.dataSource = self;
    [_bgView addSubview:_pickerView];
    
    UIView *pickerTopLine = [[UIView alloc] initWithFrame:CGRectMake(0, _pickerView.frame.origin.y - 1, [UIScreen mainScreen].bounds.size.width, 1)];
    pickerTopLine.backgroundColor = UIColorFromRGB(0x1effffff); //BMThemeColor(@"SL13");
    [_bgView addSubview:pickerTopLine];
    UIView *pickerBottomLine = [[UIView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(_pickerView.frame), [UIScreen mainScreen].bounds.size.width, 1)];
    pickerBottomLine.backgroundColor = pickerTopLine.backgroundColor;
    [_bgView addSubview:pickerBottomLine];
    
    CGFloat buttonWidth = ADAPTOR_VALUE_750(140);
    _cancelButton = [UIButton buttonWithType:UIButtonTypeSystem];
    _cancelButton.frame = CGRectMake(0, 0, buttonWidth, ADAPTOR_VALUE_750(90));
    [_bgView addSubview:_cancelButton];
    [_cancelButton setTitle:@"退出" forState:UIControlStateNormal];
    [_cancelButton setTitleColor:UIColorFromRGB(0x4cffffff) forState:UIControlStateNormal]; //BMThemeColor(@"L31")
    [_cancelButton addTarget:self action:@selector(didTapCancelButton) forControlEvents:UIControlEventTouchUpInside];
    _cancelButton.center = CGPointMake(ADAPTOR_VALUE_750(10) + buttonWidth/2, (_bgView.frame.size.height + CGRectGetMaxY(_pickerView.frame))/2);
    
    _okButton = [UIButton buttonWithType:UIButtonTypeSystem];
    _okButton.frame = CGRectMake(0, 0, _cancelButton.frame.size.width, _cancelButton.frame.size.height);
    [_okButton setTitle:@"确定" forState:UIControlStateNormal];
    [_bgView addSubview:_okButton];
    [_okButton addTarget:self action:@selector(didTapOkButton) forControlEvents:UIControlEventTouchUpInside];
    _okButton.center = CGPointMake(_bgView.frame.size.width - _cancelButton.center.x, _cancelButton.center.y);
    
    _titleLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, ADAPTOR_VALUE_750(300), ADAPTOR_VALUE_750(29.5 * 4))];
    _titleLabel.text = @"选择出发时间";
    [_titleLabel sizeToFit];
    _titleLabel.center = CGPointMake(_bgView.frame.size.width/2, ADAPTOR_VALUE_750(29.5 * 4)/2);
    
    [_bgView addSubview:_titleLabel];
    
    [self.view addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(didTapSelfView)]];
    
    
}

//-(void)viewDidAppear:(BOOL)animated{
//    [super viewDidAppear:animated];
//
//    if (self.initialSelectedDateAligned) {
//        //每次进入，picker选中的项以最晚的时间为准
//        //如果进入时间大于选择时间，那么用进入时间
//        //如果进入时间小于用户选择时间，那么用用户选择时间
//        if ([self.enterViewControllerDate laterDate:self.initialSelectedDateAligned] == self.enterViewControllerDate) {
//            self.initialSelectedDateAligned = [self.enterViewControllerDate nextDateByUnit:15 * 60];
//        }
//        dispatch_async(dispatch_get_main_queue(), ^{
//            [self selectDate:self.initialSelectedDateAligned];
//        });
//    }
//
//}

//#define NORMAL_DISPLAY_DAY_COUNT 7 //正常的话，包括今天，显示7天时间。但如果今天没有剩余时间了，需要跳到明天的话，那么就是6天
//
//static NSCalendarUnit defaultCalendarUnit = (NSCalendarUnitYear |
//                                             NSCalendarUnitMonth |
//                                             NSCalendarUnitDay|
//                                             NSCalendarUnitWeekday|
//                                             NSCalendarUnitHour|
//                                             NSCalendarUnitMinute
//                                             );

-(void)initDateModel{
    
    //每次进入出发面板，面板最小值=（当前时刻）nextDateByUnit_15min
    NSCalendar * calendar = [NSCalendar currentCalendar];
    NSDate * now = [NSDate GMT_date];
    self.miniData = [now nextDateByUnit_15min];

    //每次进入出发面板，面板焦点值=外部显示的出发时间或面板最小值
    self.focusData = self.showStartDate;
    if (!self.showStartDate)//如果到达时间显示的是--:--
    {
        self.focusData = self.miniData;
    }
    if([self.focusData earlierDate:self.miniData] == self.focusData)
    {
        //如果出发时间大于当前时间，那么到达时间最为最小值插入
//        if([self.focusData laterDate:now] == self.focusData)
//        {
//            self.miniData = self.focusData;
//        }
//        else
        {
            self.focusData = self.miniData;
        }
        
    }
    
    //这时pickView还没创建，等加载完
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self selectDate:self.focusData];
    });
    
    //面板最小时间
    NSDateComponents * dateComponents = [calendar components:defaultCalendarUnit fromDate:self.miniData];
    self.startHourToday = dateComponents.hour;
    self.startMinuteToday = dateComponents.minute;
//    if(self.startHourToday == 23 && self.startMinuteToday >= 45){
//        self.ignoreToday = YES;
//    }
    if ([self.miniData isTomorrow])
    {
        self.ignoreToday = YES;
    }
    
    NSMutableArray * dateArray = [NSMutableArray array];
    if (!self.ignoreToday) {
        BNDateModel * todayModel = [[BNDateModel alloc] initWithDateComponents:dateComponents];
        todayModel.date = now;
        [dateArray addObject:todayModel];
        //不是大于23:45，那么看是否忽略当前小时
        if (self.startMinuteToday > 45 && [self.focusData isByUnit_15min])//如果需要插入不规则时刻，这里不能以45作为结束
        {
            self.startHourToday ++;
            self.startMinuteToday = 0;
        }
    }
    else {
        //越过今天，直达明天
        self.startHourToday = 0;
        self.startMinuteToday = 0;
    }
    
    NSDate * nextDate = [now dateByAddingTimeInterval:3600 * 24];
    for (int i=0; i<6; i++) {
        dateComponents =
        [calendar components:defaultCalendarUnit fromDate:nextDate];
        BNDateModel * dateModel = [[BNDateModel alloc] initWithDateComponents:dateComponents];
        dateModel.date = nextDate;
        [dateArray addObject:dateModel];
        nextDate = [nextDate dateByAddingTimeInterval:3600 * 24];
    }
    self.dateArray = dateArray;
    
}

- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView{
    return 3;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component{
    
    if (component == 0) {
        return self.dateArray.count;
    }  else if (component == 1) {
        NSInteger selectedComp0 = self.comp0Index?self.comp0Index.integerValue:[pickerView selectedRowInComponent:0];
        if (selectedComp0 == 0) {
            return 24 - self.startHourToday;
        }
        else {
            return 24;
        }
    }else if (component == 2) {
        NSInteger selectedComp0 = self.comp0Index?self.comp0Index.integerValue:[pickerView selectedRowInComponent:0];
        NSInteger selectedComp1 = self.comp1Index?self.comp1Index.integerValue:[pickerView selectedRowInComponent:1];
        if (selectedComp0 == 0 &&
            selectedComp1 == 0)
        {
            //当选中时间是不规则的15分钟，需要插入一个新分钟
            if(![self.focusData isByUnit_15min] && [self bFocusDataIsSelected])
            {
                return 4 - [self nextIndexOfStartMinute]+1;
            }
            else
            {
                return 4 - [self nextIndexOfStartMinute];
            }
        }
        else
        {
            if(![self.focusData isByUnit_15min] && [self bFocusDataIsSelected])
            {
                return 4+1;
            }
            else
            {
                return 4;
            }
        }
    }
    return 0;
}

- (CGFloat)pickerView:(UIPickerView *)pickerView widthForComponent:(NSInteger)component
{
    if (component == 0) {
        return self.view.frame.size.width/2;
    }
    else if (component == 1){
        return self.view.frame.size.width/6;
    }
    else {
        return self.view.frame.size.width/2 - self.view.frame.size.width/6;
    }
    return 100;
}

#pragma mark - UIPickerViewDelegate
- (nullable NSString *)pickerView:(UIPickerView *)pickerView
                      titleForRow:(NSInteger)row
                     forComponent:(NSInteger)component {
    if (component == 0) {
        BNDateModel * model = (BNDateModel *)[self pickerView:pickerView objectForRow:row forComponent:component];
        
        if (self.ignoreToday) {
            if (row == 0) {
                return [NSString stringWithFormat:@"明天 %@",model.weekdayString];
            }
        }
        else {
            if (row == 0) {
                return [NSString stringWithFormat:@"今天 %@",model.weekdayString];
            }
            else if (row == 1){
                return [NSString stringWithFormat:@"明天 %@",model.weekdayString];
            }
        }
        
        return [NSString stringWithFormat:@"%ld月%ld日 %@",(long)model.month, (long)model.day,model.weekdayString];
    }
    else if (component == 1) {
        NSNumber * number = [self pickerView:pickerView objectForRow:row forComponent:component];
        return [NSString stringWithFormat:@"%ld",(long)number.integerValue];
        
    }
    else if (component == 2) {
        NSNumber * number = [self pickerView:pickerView objectForRow:row forComponent:component];
        return [NSString stringWithFormat:@"%02d",(long)number.integerValue];
        
    }
    return nil;
}


/**
 获取不同的row component对应的对象

 @param pickerView <#pickerView description#>
 @param row <#row description#>
 @param component <#component description#>
 @return component_0:返回nil表示“现在出发”，返回BNDateModel表示有数据
 component2和3，返回对应的int
 */
- (nullable id)pickerView:(UIPickerView *)pickerView objectForRow:(NSInteger)row forComponent:(NSInteger)component {
    int comp0StartIndex = 0;
    if (component == 0) {
        NSInteger rowIndexShifted = row - comp0StartIndex;
        
        return [self objectForRow:rowIndexShifted forComponent:0 startHour:0 startMinute:0];
    }
    else if (component == 1) {
        if([pickerView selectedRowInComponent:0] == 0) {
            //今天的场景
            return [self objectForRow:row forComponent:1 startHour:self.startHourToday startMinute:self.startMinuteToday];
        }
        else {
            //明天及以后的场景
            return [self objectForRow:row forComponent:1 startHour:0 startMinute:0];
        }
    }
    else if (component == 2) {
        if([pickerView selectedRowInComponent:0] == 0&&
           [pickerView selectedRowInComponent:1] == 0) {
            //今天的场景
//            if(self.startMinuteToday > [self.focusData minute])
//            {
//                self.startMinuteToday = [self.focusData minute];
//            }
            return [self objectForRow:row forComponent:2 startHour:self.startHourToday startMinute:self.startMinuteToday];
        }
        else {
            //明天及以后的场景
            return [self objectForRow:row forComponent:2 startHour:0 startMinute:0];
        }
    }
    return nil;
}


-(nullable id)objectForRow:(NSInteger)row forComponent:(NSInteger)component startHour:(NSInteger)startHour startMinute:(NSInteger)startMinute{
    if (component == 0) {
        BNDateModel * model = self.dateArray[row];
        return model;
    }
    else if (component == 1) {
        
        NSInteger hour = startHour + row;
        
        return @(hour);
    }
    else if (component == 2) {
        
        NSInteger minute = ([self nextIndexOfMinute:startMinute] + row) * 15;
        BOOL bInsert = NO;
        if([self bFocusDataIsSelected])
        {
            //插入不规则时刻分钟的数值计算
            if(![self.focusData isByUnit_15min] && minute > [self.focusData minute])
            {
                NSInteger insertMinute = [self.focusData minute];
                //估计插入时刻最近的那个单位15
                if((insertMinute/15+1)*15 == minute)
                {
                    minute = insertMinute;
                    bInsert = YES;
                }
                else if(minute > (insertMinute/15+1)*15)//大于
                {
                    minute = ([self nextIndexOfMinute:startMinute] + row ) * 15-15;
                    bInsert = YES;
                }
    //            //恢复self.hasInsertMinute
    //            dispatch_async(dispatch_get_main_queue(), ^{
    //                self.hasInsertMinute = NO;
    //            });
            }
        }
        //解决滚动不到最小小时的问题
        if (!bInsert && minute > 45)
        {
            minute = startMinute;
        }
        return @(minute);
        
    }
    return nil;
}

/**
 根据当前的minute，返回对应的下一个index，以15为单位 ,例如
 0->0
 8->1
 15->1
 16->2
 30->2
 40->3
 45->进入下一周期

 @return <#return value description#>
 */
-(NSUInteger)nextIndexOfMinute:(NSInteger)minute{
    NSUInteger next = ceil((float)minute/15.);
    return next;
}

-(NSUInteger)nextIndexOfStartMinute{
    return [self nextIndexOfMinute:self.startMinuteToday];
}

- (CGFloat)pickerView:(UIPickerView *)pickerView rowHeightForComponent:(NSInteger)component
{
    return 35.0f;
}

- (void)pickerView:(UIPickerView *)pickerView
      didSelectRow:(NSInteger)row
       inComponent:(NSInteger)component {
    self.comp0Index = nil;
    self.comp1Index = nil;
    self.comp2Index = nil;
    
    if (component == 0) {
        [pickerView reloadComponent:1];
        [pickerView reloadComponent:2];
        
        if (row == 0) {
            //如果当前是“现在出发”， 必须选回空行
            [pickerView selectRow:0 inComponent:1 animated:NO];
            [pickerView selectRow:0 inComponent:2 animated:NO];
        }
    }
    else if (component == 1) {
        
            [pickerView reloadComponent:2];
    }
    else{

    }
    
    if (component == 0) {
        if (!self.lastSelectedFate) {
            self.lastSelectedFate = self.focusData;
        }
        
        NSTimeInterval seltime = [self.selectedDate.midnight timeIntervalSince1970] + [self.lastSelectedFate timeIntervalSinceDate:self.lastSelectedFate.midnight];
        NSDate * newDate = [NSDate dateWithTimeIntervalSince1970:seltime];
        if ([newDate earlierDate:self.miniData] == newDate) {
            newDate = self.miniData;
        }
        [self selectDate:newDate];
    }
    else if (component == 1) {

        if (!self.lastSelectedFate) {
            self.lastSelectedFate = self.focusData;
        }
        
        NSTimeInterval timeHourAligned = (((long long)[self.selectedDate timeIntervalSince1970])/3600) * 3600;
        NSTimeInterval lastSelectMinute = (((long long)[self.lastSelectedFate timeIntervalSince1970])%3600);
        
        NSDate * newDate = [NSDate dateWithTimeIntervalSince1970:timeHourAligned + lastSelectMinute];
        [self selectDate:newDate];
    }
    self.lastSelectedFate = self.selectedDate;;
}

-(void)selectDate:(NSDate*)date{
    if (self.dateArray.count == 0) {
        return;
    }
    NSDate * day0 = self.dateArray[0].date;
    
    NSInteger dDay = [date distanceInDaysToDate:day0];
    
    NSInteger comp0Idx = dDay;
    
    NSInteger hour = date.hour;
    
    NSInteger firstHour = ((NSNumber*)[self objectForRow:0 forComponent:1 startHour:0 startMinute:0]).integerValue;
    
    NSInteger comp1Idx = hour - (comp0Idx == 0?self.startHourToday:firstHour);
    
    NSInteger min = date.minute;
    if (date.minute > 45 && [self.focusData isByUnit_15min]) {
        min = 0;
    }
    
    NSInteger comp2Idx = [self nextIndexOfMinute:min] ;//- [self nextIndexOfStartMinute];
    if (comp0Idx == 0 && comp1Idx == 0) {
        comp2Idx = comp2Idx -  [self nextIndexOfStartMinute];
    }
    
    [self.pickerView selectRow:comp0Idx inComponent:0 animated:NO];
    [self safe_pickerViewSelectRow:comp1Idx inComponent:1];
    [self safe_pickerViewSelectRow:comp2Idx inComponent:2];
    
//    [self.pickerView selectRow:comp1Idx inComponent:1 animated:NO];
//    [self.pickerView reloadComponent:1];
//    [self.pickerView selectRow:comp1Idx inComponent:1 animated:NO];
//
//    [self.pickerView selectRow:comp2Idx inComponent:2 animated:NO];
//    [self.pickerView reloadComponent:2];
//    [self.pickerView selectRow:comp2Idx inComponent:2 animated:NO];
    
    self.comp0Index = @(comp0Idx);
    self.comp1Index = @(comp1Idx);
    self.comp2Index = @(comp2Idx);
    
//    [self.pickerView reloadAllComponents];
}

//当前滚动到的是不是进入时的焦点的日期小时
-(BOOL)bFocusDataIsSelected
{
    BOOL ret = NO;
    NSInteger selectedRow_comp0 = [_pickerView selectedRowInComponent:0];
    BNDateModel * dateModel = [self pickerView:_pickerView objectForRow:selectedRow_comp0 forComponent:0];
    if(dateModel.date.day == self.focusData.day)
    {
        NSInteger hour;
        NSInteger selectedRow_comp1 = [_pickerView selectedRowInComponent:1];
        NSNumber * valueOfComp1 = [self pickerView:_pickerView objectForRow:selectedRow_comp1 forComponent:1];
        hour = valueOfComp1.integerValue;
        
        if(hour == [self.focusData hour])
        {
            ret = YES;
        }
    }

    return ret;
}


/**
 因为需要同时改变num和selectedRow，必须要用这种方法workaround

 @param row <#row description#>
 @param comp <#comp description#>
 */
-(void)safe_pickerViewSelectRow:(NSInteger)row inComponent:(NSInteger)comp{
//    NSLog(@"safe_pickerViewSelectRow %d %d",row, comp)
    if (row >= 0 && comp >= 0) {
        [self.pickerView selectRow:row inComponent:comp animated:NO];
        [self.pickerView reloadComponent:comp];
        [self.pickerView selectRow:row inComponent:comp animated:NO];
    }
}

-(NSDate*)selectedDate{
    NSInteger selectedRow_comp0 = [_pickerView selectedRowInComponent:0];
    NSInteger selectedRow_comp1 = [_pickerView selectedRowInComponent:1];
    NSInteger selectedRow_comp2 = [_pickerView selectedRowInComponent:2];
    
    BNDateModel * objOfComp0 = [self pickerView:_pickerView objectForRow:selectedRow_comp0 forComponent:0];
    NSNumber * valueOfComp1 = [self pickerView:_pickerView objectForRow:selectedRow_comp1 forComponent:1];
    NSNumber * valueOfComp2 = [self pickerView:_pickerView objectForRow:selectedRow_comp2 forComponent:2];
    
    if (!objOfComp0) {
        return [NSDate GMT_date];
    }
    
    NSDateComponents * comps = [[NSDateComponents alloc] init];
    [comps setYear:objOfComp0.year];
    [comps setMonth:objOfComp0.month];
    [comps setDay:objOfComp0.day];
    [comps setHour:valueOfComp1.integerValue];
    [comps setMinute:valueOfComp2.integerValue];
    
    NSCalendar *calendar = [NSCalendar currentCalendar];
    NSDate * selectedDate = [calendar dateFromComponents:comps];
    
    return selectedDate;
}

-(void)dismiss{
    [self dismissViewControllerAnimated:NO completion:^{
        if ([self.delegate respondsToSelector:@selector(datePickerDidDismiss:)]) {
            [self.delegate datePickerDidDismiss:self];
        }
    }];
}

#pragma mark button handler
-(void)didTapSelfView{
    [self dismiss];
}

-(void)didTapCancelButton{
    [self dismiss];
}

-(void)didTapOkButton{
//#ifdef DEBUG
//    NSDate * selectedDate = self.selectedDate;
//    NSLog(@"selected date: %@",selectedDate);
//    return;
//#endif
    NSDate * selectedDate = self.selectedDate;
    
    NSLog(@"did tap ok with selected date: %@",selectedDate);
    
    NSDate * now = [NSDate GMT_date];
    if ([now earlierDate:selectedDate] == selectedDate) {
//        BNShowToast(@"出发时间不能早于当前时刻");
        NSLog(@"出发时间不能早于当前时刻, 当前时刻%@", now);
        return;
    }
    
    if ([self.delegate respondsToSelector:@selector(dateStartPickerDidTapOk:)]) {
        [self.delegate dateStartPickerDidTapOk:self];
    }
    
    [self dismissViewControllerAnimated:NO completion:^{
        if ([self.delegate respondsToSelector:@selector(dateStartPickerDidDismiss:)]) {
            [self.delegate dateStartPickerDidDismiss:self];
        }
    }];
}

@end
