//
//  BNDatePickerViewController.h
//  FutureTripDemo
//
//  Created by Liang,Zhiyuan(GIS)2 on 2019/1/30.
//  Copyright © 2019 Liang,Zhiyuan(GIS). All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class BNDatePickerViewController;
@class BNStartDatePickerViewController;
@class BNArrialDatePickerViewController;


@protocol BNDatePickerViewControllerDelegate <NSObject>

-(void)datePickerDidDismiss:(BNDatePickerViewController*)picker;

-(void)datePickerDidOK:(BNDatePickerViewController*)picker;


-(void)dateStartPickerDidDismiss:(BNStartDatePickerViewController*)picker;
-(void)dateStartPickerDidTapOk:(BNStartDatePickerViewController*)picker;


-(void)dateArrialPickerDidDismiss:(BNArrialDatePickerViewController*)picker;
-(void)dateArrialPickerDidTapOk:(BNArrialDatePickerViewController*)picker;



@end

@interface BNDatePickerViewController : UIViewController

/**
 界面初始化的时候，选择的时间
 */
@property (nonatomic) NSDate * initialSelectedDateAligned;

/**
 用户选择时间
 */
@property (nonatomic, readonly) NSDate * selectedDate;

@property (nonatomic, weak) id<BNDatePickerViewControllerDelegate> delegate;

@end


@interface BNArrialDatePickerViewController : UIViewController
/**
 用户选择时间
 */
@property (nonatomic, readonly) NSDate * selectedDate;

@property (nonatomic, weak) id<BNDatePickerViewControllerDelegate> delegate;

//
- (id)initWithShownArrialDate:(NSDate*)showArrialDate miniTimeCost:(NSTimeInterval)timeCost nowArrialTime:(NSString*)time;
@end


@interface BNStartDatePickerViewController : UIViewController
/**
 用户选择时间
 */
@property (nonatomic, readonly) NSDate * selectedDate;

@property (nonatomic, weak) id<BNDatePickerViewControllerDelegate> delegate;

//
- (id)initWithShownStartDate:(NSDate*)showStartDate;
@end



NS_ASSUME_NONNULL_END
