//
//  NaviSettingViewController.m
//  NaviSDKDemo
//
//  Created by Zhou,Weikang on 2017/12/4.
// 
//

#import "NaviSettingViewController.h"
#import "NaviSettingTableViewCell.h"
#import "BNaviService.h"
#import "NaviSettringManager.h"
#import "BNUtility.h"
@interface NaviSettingViewController () <UITableViewDelegate, UITableViewDataSource, NaviSettingTableViewCellDelegate>
{
    NSArray *_titleArray;
    NSArray *_optionArray;
    NSArray *_selectedArray;
    NSArray *_preferenceArray;
    BOOL _isOpenPreference;
}

@property (nonatomic, strong) UITableView *tableView;

@end

@implementation NaviSettingViewController

- (NSString *)title {
    return @"导航设置";
}

- (void)viewDidLoad {
    [super viewDidLoad];

    _titleArray = @[@"日夜模式",
                    @"诱导面板模式",
                    @"是否显示实景放大图",
                    @"显示到终点红线开关",
                    @"全览样式",
                    @"拦截提醒消息",
                    @"拦截干预消息",
                    @"导航中设置项隐藏和显示",
                    @"导航中播报设置隐藏和显示",
                    @"导航中上报项隐藏和显示",
                    @"导航中刷新项隐藏和显示",
                    @"导航语言项是否英文"];
    
    _optionArray = @[
                    @[@"自动", @"白天", @"夜间"],
                    @[@"经典", @"简洁"],
                    @[@"关闭", @"打开"],
                    @[@"关闭", @"打开"],
                    @[@"路况条", @"全览小窗"],
                    @[@"拦截", @"打开"],
                    @[@"拦截", @"打开"],
                    @[@"不读取本地配置", @"读取本地配置"],
                    @[@"隐藏", @"显示"],
                    @[@"隐藏", @"显示"],
                    @[@"隐藏", @"显示"],
                    @[@"中文", @"英文"]];

    self.view.backgroundColor = [UIColor whiteColor];
    
    self.tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
    UIWindow *window = UIApplication.sharedApplication.windows.firstObject;
    CGFloat topPadding = 64;
    if (@available(iOS 11.0, *)) {
        topPadding = window.safeAreaInsets.top;
    }
    self.tableView.frame = CGRectMake(0, topPadding, self.view.frame.size.width, self.view.frame.size.height - topPadding);
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.view addSubview:self.tableView];
    
    [self.tableView registerClass:[NaviSettingTableViewCell class] forCellReuseIdentifier:@"NaviSettingTableViewCell"];
    [self.tableView registerClass:[NaviSettingTextTableViewCell class] forCellReuseIdentifier:@"NaviSettingTextTableViewCell"];
    
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setTitle:@"获取CUID" forState:UIControlStateNormal];
    [btn addTarget:self action:@selector(tapBtn) forControlEvents:UIControlEventTouchUpInside];
    btn.frame = CGRectMake(0, 0, 50, 40);
    [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:btn];
}

- (void)tapBtn {
    NSString *cuid = [BNUtility getLBSCuid];
    NSString *title = [NSString stringWithFormat:@"cuid：%@", cuid];
    NSString *message = @"信息已复制到系统剪切板";
    
    // 复制到系统剪切板
    UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
    pasteboard.string = cuid;
    
    // 创建 UIAlertController
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:title
                                                                             message:message
                                                                      preferredStyle:UIAlertControllerStyleAlert];
    
    // 添加 "确定" 按钮
    UIAlertAction *confirmAction = [UIAlertAction actionWithTitle:@"确定"
                                                            style:UIAlertActionStyleDefault
                                                          handler:nil];
    [alertController addAction:confirmAction];
    
    // 显示弹窗
    [self presentViewController:alertController animated:YES completion:nil];
}


- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    _selectedArray = @[@(BNaviService_Strategy.dayNightType),
                       @(BNaviService_Strategy.simpleGuideMode),
                       @(BNaviService_Strategy.showLiveExpandRoadMap),
                       @(BNaviService_Strategy.redLineShow),
                       @(BNaviService_Strategy.showMapTinyView),
                       @(BNaviService_Strategy.supportNoticeMessage),
                       @(BNaviService_Strategy.supportInterveneMessage),
                       @(NO),
                       @(BNaviService_Strategy.showMuteButton),
                       @(BNaviService_Strategy.supportUGCReportButton),
                       @(BNaviService_Strategy.showRrefreshRouteButton),
                       @(BNaviService_Strategy.naviLanguageType)];
    [self.tableView reloadData];
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    
//    self.tableView.contentSize = CGSizeMake(0, (_titleArray.count) * 88 + 64 + 88);
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)syncCarNumber:(NSString *)carNumber {
    [BNaviService_Strategy syncCarNumber:carNumber];
}

- (void)syncTruckNumber:(NSString *)carNumber {
    BMTruckInfoModel *model = [[BMTruckInfoModel alloc] init];
    model.truckType = BMTruckTypeHeavy;
    model.powerType = BMTruckPowerTypeGasoline;
    model.carNumber = carNumber;
    model.emission = 6;
    model.weight = 70 * 1000;
    model.load = 100 * 1000;
    model.length = 20 * 1000;
    model.width = 4 * 1000;
    model.height = 5 * 1000;
    model.axleNumber = 6;
    model.plateColor = BNTruckPlateColorGreen;
    model.axleWeight = 80 * 1000;
    model.oilCost = 13 * 1000;
    model.truckCarType = BNTruckCarTypeCommon; /// 新能源 、普通车
    [BNaviService_Strategy syncTruckInfoModel:model];
}

- (void)syncMotoNumber:(NSString *)carNumber {
    BNMotorInfoModel *model = [[BNMotorInfoModel alloc] init];
    model.displacement = 5343;
    model.plate = carNumber;
    model.plateType = BNMotorPlateType_Yellow;
    model.powerType = BNMotorPowerType_Oil;
    [BNaviService_Strategy syncMotorInfoModel:model];
}

#pragma mark-
#pragma marked tableviewDelegate
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 88;
}

#pragma marked tableviewDatasource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 2;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if (section ==0) {
        return 3;
    } else {
        return _titleArray.count;
    }
    
}

- (UITableViewCell*)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.section == 0) { // 设置车牌
        NaviSettingTextTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"NaviSettingTextTableViewCell"];
        if (indexPath.row == 0) {
            cell.titleLabel.text = @"设置驾车车牌号";
            cell.textField.placeholder = @"请输入车牌号";
            cell.textField.text = BNaviService_Strategy.getCarNumber;
        } else if (indexPath.row == 1) {
            cell.titleLabel.text = @"设置货车车牌号";
            cell.textField.placeholder = @"请输入车牌号";
            cell.textField.text = BNaviService_Strategy.getTruckInfoModel.carNumber;
        } else if (indexPath.row == 2) {
            cell.titleLabel.text = @"设置摩托车车牌号";
            cell.textField.placeholder = @"请输入车牌号";
            cell.textField.text = @"";
        }
        cell.index = indexPath;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        __weak typeof(self) wself = self;
        cell.block = ^(NSString *text, NSIndexPath *index) {
            if (index.row == 0) {
                [wself syncCarNumber:text];
            } else if (index.row == 1) {
                [wself syncTruckNumber:text];
            } else if (index.row == 2) {
                [wself syncMotoNumber:text];
            }
        };
        return cell;
    } else {
        NaviSettingTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"NaviSettingTableViewCell"];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.delegate = self;
        cell.indexPath = indexPath;
        NSInteger row = indexPath.row;
        if (row < _titleArray.count) {
            cell.titleLabel.text = _titleArray[row];
        }
        
        if (row < _optionArray.count) {
            cell.optionList = _optionArray[row];
        }
        
        if (row < _selectedArray.count) {
            cell.selectIndex = [_selectedArray[row] integerValue];
        }
        return cell;
    }
}

#pragma mark - NaviSettingTableViewCellDelegate

- (void)tableViewCell:(NaviSettingTableViewCell *)naviSettingCell didSelectAtIndex:(NSUInteger)index {
    switch (naviSettingCell.indexPath.row) {
        case 0:
            BNaviService_Strategy.dayNightType = (BNDayNight_CFG_Type)index;
            break;
        case 1:
            BNaviService_Strategy.simpleGuideMode = (BN_Simple_Guide_Mode)index;
            break;
        case 2:
            BNaviService_Strategy.showLiveExpandRoadMap = index;
            break;
        case 3:
            BNaviService_Strategy.redLineShow = index;
            break;
        case 4:
            BNaviService_Strategy.showMapTinyView = index;
            break;
        case 5:
            BNaviService_Strategy.supportNoticeMessage = index;
            break;
        case 6:
            BNaviService_Strategy.supportInterveneMessage = index;
            break;
        case 7:
            [NaviSettringManager loadData:index];
            break;
        case 8:
            BNaviService_Strategy.showMuteButton = index;
            break;

        case 9:
            BNaviService_Strategy.supportUGCReportButton = index;
            break;

        case 10:
            BNaviService_Strategy.showRrefreshRouteButton = index;
            break;
        case 11:
        {
            if (index == 0) {
                BNaviService_Strategy.naviLanguageType = BNaviLanguageType_Chinese;
                BNaviService_Instance.naviMapView.languageType = kBMKMapLanguageTypeChinese;
            } else {
                BNaviService_Strategy.naviLanguageType = BNaviLanguageType_English;
                BNaviService_Instance.naviMapView.languageType = kBMKMapLanguageTypeEnglish;
            } 
        }
            break;
        default:
            break;
    }
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation {
    return NO;
}

- (BOOL)shouldAutorotate {
    return NO;
}

- (NSUInteger)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait;
}

@end
