//
//  NaviSettingTableViewCell.m
//  NaviSDKDemo
//
//  Created by Zhou,Weikang on 2017/12/4.
//
//

#import "NaviSettingTableViewCell.h"

@interface NaviSettingTableViewCell()

@property (nonatomic, strong) NSMutableArray *optionViewList;

@end

@implementation NaviSettingTableViewCell
{
    UIView *_lineView;
}

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self initUI];
    }
    return self;
}

- (void)initUI
{
    self.titleLabel = [[UILabel alloc] initWithFrame:CGRectMake(17, 16, [UIScreen mainScreen].bounds.size.width - 32, 16)];
    self.titleLabel.textColor = [UIColor blackColor];
    self.titleLabel.font = [UIFont systemFontOfSize:16];
    [self.contentView addSubview:self.titleLabel];
    self.optionViewList = [NSMutableArray array];
   
    _lineView = [[UIView alloc] initWithFrame:CGRectMake(0, self.frame.size.height - 0.5, [UIScreen mainScreen].bounds.size.width, 0.5)];
    _lineView.backgroundColor = [UIColor lightGrayColor];
    [self.contentView addSubview:_lineView];
}

- (void)setOptionList:(NSArray *)optionList
{
    for (UIView *view in self.optionViewList) {
        [view removeFromSuperview];
    }
    [self.optionViewList removeAllObjects];
    CGFloat width = (self.frame.size.width - 16*2 - 15 * MAX(optionList.count - 1, 0)) / MAX(1, optionList.count);
    for (int i = 0;i <optionList.count ; i ++) {
        UIButton *subView = [UIButton buttonWithType:UIButtonTypeCustom];
        id object = optionList[i];
        if ([object isKindOfClass:[UIImage class]])
        {
            subView.frame = CGRectMake(16 + (width + 15) * i, self.titleLabel.frame.origin.y + self.titleLabel.frame.size.height + 12, width, 67);
            [subView setBackgroundImage:object forState:UIControlStateNormal];
        } else {
            subView.frame = CGRectMake(16 + (width + 15) * i, self.titleLabel.frame.origin.y + self.titleLabel.frame.size.height + 12, width, 27);
            NSString *option = [optionList objectAtIndex:i];
            [subView setTitle:option forState:UIControlStateNormal];
            [subView setTitle:option forState:UIControlStateHighlighted];
        }
        [subView setTitleColor:[UIColor whiteColor] forState:UIControlStateSelected];
        subView.tag = 10000 + i;
        subView.titleLabel.font = [UIFont systemFontOfSize:14];
        [subView addTarget:self action:@selector(subViewDidSelect:) forControlEvents:UIControlEventTouchUpInside];
        [self.contentView addSubview:subView];
        [self.optionViewList addObject:subView];
    }
}

- (void)setSelectIndex:(NSInteger)selectIndex
{
    _selectIndex = selectIndex;
    for (int i = 0 ; i < self.optionViewList.count; i ++) {
        UIButton *btn = [self.optionViewList objectAtIndex:i];
        if (i == selectIndex) {
            [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
            btn.backgroundColor = [UIColor blueColor];
            btn.layer.cornerRadius = 3.0f;
            btn.layer.borderColor = [UIColor clearColor].CGColor;
            btn.layer.borderWidth = 0.0f;
            btn.clipsToBounds = YES;
            
        }else{
            [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
            btn.backgroundColor = [UIColor clearColor];
            btn.layer.cornerRadius = 3.0f;
            btn.layer.borderColor = [UIColor grayColor].CGColor;
            btn.layer.borderWidth = 0.5f;
            btn.clipsToBounds = YES;
        }
    }
}

- (void)subViewDidSelect:(UIButton *)btn
{
    for (UIButton *view in self.optionViewList) {
        [view setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        view.backgroundColor = [UIColor clearColor];
        view.layer.cornerRadius = 3.0f;
        view.layer.borderColor = [UIColor grayColor].CGColor;
        view.layer.borderWidth = 0.5f;
        view.clipsToBounds = YES;
    }
    [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    btn.backgroundColor = [UIColor blueColor];
    btn.layer.cornerRadius = 3.0f;
    btn.layer.borderColor = [UIColor clearColor].CGColor;
    btn.layer.borderWidth = 0.0f;
    btn.clipsToBounds = YES;
    if ([_delegate respondsToSelector:@selector(tableViewCell:didSelectAtIndex:)])
    {
        [_delegate tableViewCell:self didSelectAtIndex:btn.tag - 10000];
    }
}

- (void)layoutSubviews
{
    _lineView.frame = CGRectMake(0, self.frame.size.height - 0.5, [UIScreen mainScreen].bounds.size.width, 0.5);
}
@end

@implementation NaviSettingTextTableViewCell
{
    UIView *_lineView;
}

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self initUI];
    }
    return self;
}

- (void)initUI {
    _lineView = [[UIView alloc] initWithFrame:CGRectMake(0, self.frame.size.height - 0.5, [UIScreen mainScreen].bounds.size.width, 0.5)];
    _lineView.backgroundColor = [UIColor lightGrayColor];
    [self.contentView addSubview:_lineView];
    
    self.titleLabel = [[UILabel alloc] initWithFrame:CGRectMake(17, 16, [UIScreen mainScreen].bounds.size.width - 32, 16)];
    self.titleLabel.textColor = [UIColor blackColor];
    self.titleLabel.font = [UIFont systemFontOfSize:16];
    [self.contentView addSubview:self.titleLabel];
    
    self.textField = [[UITextField alloc] initWithFrame:CGRectMake(16, self.titleLabel.frame.origin.y + self.titleLabel.frame.size.height + 12, [UIScreen mainScreen].bounds.size.width - 82, 27)];
    self.textField.font = [UIFont systemFontOfSize:14];
    self.textField.textColor = [UIColor blackColor];
    self.textField.borderStyle = UITextBorderStyleRoundedRect;
    [self.contentView addSubview:self.textField];
    
    self.sureButton = [UIButton buttonWithType:UIButtonTypeSystem];
    self.sureButton.frame = CGRectMake(CGRectGetMaxX(self.textField.frame) + 10, CGRectGetMinY(self.textField.frame), 40, 27);
    [self.sureButton addTarget:self action:@selector(sureButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    [self.sureButton setTitle:@"确定" forState:UIControlStateNormal];
    [self.contentView addSubview:self.sureButton];
}

- (void)layoutSubviews {
    _lineView.frame = CGRectMake(0, self.frame.size.height - 0.5, [UIScreen mainScreen].bounds.size.width, 0.5);
}

- (void)sureButtonClick:(UIButton *)btn {
    [self.textField resignFirstResponder];
    
    if (_block) {
        _block(self.textField.text, self.index);
    }
}

@end
