//
//  NaviSettingTableViewCell.h
//  NaviSDKDemo
//
//  Created by Zhou,Weikang on 2017/12/4.
//  
//

#import <UIKit/UIKit.h>

@class NaviSettingTableViewCell;

@protocol NaviSettingTableViewCellDelegate <NSObject>

@required

- (void)tableViewCell:(NaviSettingTableViewCell *)naviSettingCell didSelectAtIndex:(NSUInteger)index;

@end

@interface NaviSettingTableViewCell : UITableViewCell

@property (nonatomic, weak) id<NaviSettingTableViewCellDelegate> delegate;
@property (nonatomic, strong) UILabel *titleLabel;
@property (nonatomic, strong) NSArray *optionList;
@property (nonatomic, assign) NSInteger selectIndex;
@property (nonatomic, strong) NSIndexPath *indexPath;

@end

typedef void(^NaviSettingTextTableViewCellBlock)(NSString *text, NSIndexPath *index);

@interface NaviSettingTextTableViewCell: UITableViewCell

@property (nonatomic,copy) NaviSettingTextTableViewCellBlock block;
@property (nonatomic, strong) UILabel *titleLabel;
@property (nonatomic, strong) UITextField *textField;
@property (nonatomic, strong) UIButton *sureButton;
@property (nonatomic, strong) NSIndexPath *index;
@end
