//
//  customBottomBar.m
//  NaviDemo
//
//  Created by v_xudihua on 2023/3/23.
//  Copyright © 2023 v_qinruiguang. All rights reserved.
//

#import "CustomBottomBar.h"
#import "BNNaviProtocol.h"
#import "BNaviService.h"
#import "BNaviModel.h"

@interface CustomBottomBar ()<BNaviModelDelegate>
@property (nonatomic, assign) NSInteger remainDistance;
@property (nonatomic, assign) NSInteger remainTime;
@property (nonatomic, assign) NSInteger remainTrafficlights;
@property (nonatomic, strong) UIButton *exitBtn;
@property (nonatomic, strong) UILabel *remainInfoLabe1;
@property (nonatomic, strong) UILabel *remainInfoLabe2;

@end

@implementation CustomBottomBar

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self creatUI];
    }
    return self;
}

- (void)creatUI {
    self.backgroundColor = UIColor.grayColor;
    self.layer.cornerRadius = 10;
    self.layer.masksToBounds = YES;
    [self addSubview:self.exitBtn];
    [self addSubview:self.remainInfoLabe1];
    [self addSubview:self.remainInfoLabe2];
    [[BNaviModel getInstance] addNaviModelListener:self];
}

- (void)setFrame:(CGRect)frame {
    if (!CGRectEqualToRect(self.frame, frame) && frame.size.width > 0 && frame.size.height > 0) {
        [super setFrame:frame];
        [self updateSubViews];
    }
}

- (void)updateSubViews {
    self.exitBtn.frame = CGRectMake(8, 0, 80, self.frame.size.height);
    self.remainInfoLabe1.frame = CGRectMake(CGRectGetMaxX(self.exitBtn.frame), 0, self.frame.size.width - CGRectGetMaxX(self.exitBtn.frame), self.frame.size.height/2);
    self.remainInfoLabe2.frame = CGRectMake(CGRectGetMaxX(self.exitBtn.frame), CGRectGetMaxY(self.remainInfoLabe1.frame), self.frame.size.width - CGRectGetMaxX(self.exitBtn.frame), self.frame.size.height/2);
}

- (void)updateData {
    self.remainInfoLabe1.text = [NSString stringWithFormat:@"剩余距离：%ld米 红绿灯：%ld个", self.remainDistance, self.remainTrafficlights];
    self.remainInfoLabe2.text = [NSString stringWithFormat:@"剩余时间%ld秒", self.remainTime];
}

- (void) btnClick {
//    退出
    [BNaviService_UI exitPage:EN_BNavi_ExitTopVC animated:YES extraInfo:nil];
}

#pragma mark ---- BNaviModelDelegate
/**
 *  处理剩余信息
 *
 *  @param remainInfo 剩余信息
 */
- (void)onHandleRemainInfo:(BNaviRemainInfo*)remainInfo {
    if (!remainInfo) return;
    _remainDistance = remainInfo.remainDist;
    _remainTime = remainInfo.remainTime;
    [self updateData];
}

/**
 *  处理剩余红绿灯信息
 *
 */
- (void)onHandleRemainTrafficlightsInfo:(BNaviRemainTrafficlightsInfo*)remainTrafficlightsInfo {
    if (!remainTrafficlightsInfo) return;
    _remainTrafficlights = remainTrafficlightsInfo.remainTrafficights;
    [self updateData];
}

#pragma mark --- getter
- (UIButton *)exitBtn {
    if (!_exitBtn) {
        UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
        [btn setTitle:@"退出" forState:UIControlStateNormal];
        [btn setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
        [btn addTarget:self action:@selector(btnClick) forControlEvents:UIControlEventTouchUpInside];
        _exitBtn = btn;
    }
    return _exitBtn;
}

- (UILabel *)remainInfoLabe1 {
    if (!_remainInfoLabe1) {
        UILabel *lab = [[UILabel alloc] init];
        lab.textColor = UIColor.blackColor;
        _remainInfoLabe1 = lab;
    }
    return _remainInfoLabe1;
}

- (UILabel *)remainInfoLabe2 {
    if (!_remainInfoLabe2) {
        UILabel *lab = [[UILabel alloc] init];
        lab.textColor = UIColor.blackColor;
        _remainInfoLabe2 = lab;
    }
    return _remainInfoLabe2;
}

@end
