//
//  SelectNodeRoutePlaneController.m
//  NaviDemo
//
//  Created by v_lisisi on 2023-12-25.
//  Copyright © 2023 v_qinruiguang. All rights reserved.
//

#import "SelectNodeRoutePlaneController.h"
#import "UIDevice+Ext.h"
#import "BNRoutePlanModel.h"
#import "BNaviService.h"
#import "SelectNodesViewController.h"
#import "MultiMapFunctionalExamplesList.h"

@interface SelectNodeRoutePlaneController ()
@property (nonatomic, strong) NSMutableArray *nodes;
@property (nonatomic, assign) int startIndex;
@property (nonatomic, assign) int wayIndex;
@property (nonatomic, assign) int endIndex;

@property (nonatomic, assign) BOOL isAddWay;
@end

@implementation SelectNodeRoutePlaneController

- (void)viewDidLoad {
    [super viewDidLoad];
    CLLocation *myLocation = [BNaviService_Location getLastLocation];

    self.nodes = [NSMutableArray arrayWithArray:@[
        [NSMutableArray arrayWithArray:@[
                     [NodeModel createSelectNodeModel:@"我的位置" x:myLocation.coordinate.longitude y:myLocation.coordinate.latitude eType:BNCoordinate_OriginalGPS],
                     [NodeModel createSelectNodeModel:@"腾讯大厦" x:113.940868 y:22.54647 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"国人" x:113.952253 y:22.543127 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"深圳百度大厦" x:113.949298 y:22.530242 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"故宫博物馆" x:116.403414 y:39.924091 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"广州塔" x:113.331084 y:23.112223 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"奎科科技大厦" x:116.313315 y:40.047682 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"深圳上海宾馆" x:114.070898 y:22.542938 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"香港深水埗区" x:114.175996 y:22.335941 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"香港沙田区" x:114.197843 y:22.389419 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"澳门塔" x:113.548352 y:22.182931 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"渔人码头" x:113.56764 y:22.196887 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"台北" x:121.572239 y:25.037382 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"高雄" x:120.344219 y:22.557532 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"北京祺邦园林" x:116.32545 y:39.789858 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"新城阳光写字楼" x:116.319595 y:39.853913 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"我的位置-北京市匈牙利大使馆" x:116.449237 y:39.942396 eType:BNCoordinate_GCJ],
                     [NodeModel createSelectNodeModel:@"栗庙路" x:114.423802 y:30.413211 eType:BNCoordinate_BaiduMapSDK],
                     ]],
        [NSMutableArray arrayWithArray:@[
                     [NodeModel createSelectNodeModel:@"腾讯大厦" x:113.940868 y:22.54647 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"国人" x:113.952253 y:22.543127 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"深圳百度大厦" x:113.949298 y:22.530242 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"故宫博物馆" x:116.403414 y:39.924091 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"广州塔" x:113.331084 y:23.112223 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"奎科科技大厦" x:116.313315 y:40.047682 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"深圳上海宾馆" x:114.070898 y:22.542938 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"香港深水埗区" x:114.175996 y:22.335941 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"香港沙田区" x:114.197843 y:22.389419 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"澳门塔" x:113.548352 y:22.182931 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"渔人码头" x:113.56764 y:22.196887 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"台北" x:121.572239 y:25.037382 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"高雄" x:120.344219 y:22.557532 eType:BNCoordinate_BaiduMapSDK],
                      [NodeModel createSelectNodeModel:@"长沙南站-东广场" x:113.075067 y:28.153196 eType:BNCoordinate_BaiduMapSDK],
                      [NodeModel createSelectNodeModel:@"北京市 北京市" x:116.40 y:39.90 eType:BNCoordinate_BaiduMapSDK],
                     ///116.433302,39.909622
                     [NodeModel createSelectNodeModel:@"北京天安门" x:116.433302 y:39.909622 eType:BNCoordinate_BaiduMapSDK],
                      [NodeModel createSelectNodeModel:@"北京某一点" x:116.306333 y:40.041690 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"北京荟聚宜家" x:116.331281 y:39.794892 eType:BNCoordinate_BaiduMapSDK uid:@"65f335dec9b88b61c2f1cf65"], // 65f335dec9b88b61c2f1cf65 //895d9912f77e240ad42ce2fe
                     [NodeModel createSelectNodeModel:@"北京丰台站P2停车场" x:116.311079 y:39.854544 eType:BNCoordinate_BaiduMapSDK uid:@"495530d6c2de6c0307026f72"],
                     [NodeModel createSelectNodeModel:@"上海南翔印象城MEGA" x:121.30596396419155 y:31.30491357950625 eType:BNCoordinate_BaiduMapSDK uid:@"1e05bcaec28d473c13293555"],

                     [NodeModel createSelectNodeModel:@"梅子湖公园北侧路侧停车场" x:100.99477053709425 y:22.76603509068343 eType:BNCoordinate_BaiduMapSDK uid:@"6d2a249dc5d87485118824e6"],
                     
///116.433302,39.909622
                     ]],
        [NSMutableArray arrayWithArray:@[
                     [NodeModel createSelectNodeModel:@"腾讯大厦" x:113.940868 y:22.54647 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"国人" x:113.952253 y:22.543127 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"深圳百度大厦" x:113.949298 y:22.530242 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"故宫博物馆" x:116.403414 y:39.924091 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"广州塔" x:113.331084 y:23.112223 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"奎科科技大厦" x:116.313315 y:40.047682 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"深圳上海宾馆" x:114.070898 y:22.542938 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"香港深水埗区" x:114.175996 y:22.335941 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"香港沙田区" x:114.197843 y:22.389419 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"澳门塔" x:113.548352 y:22.182931 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"渔人码头" x:113.56764 y:22.196887 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"台北" x:121.572239 y:25.037382 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"高雄" x:120.344219 y:22.557532 eType:BNCoordinate_BaiduMapSDK],
                      [NodeModel createSelectNodeModel:@"长沙南站-东广场" x:113.075067 y:28.153196 eType:BNCoordinate_BaiduMapSDK],
                      [NodeModel createSelectNodeModel:@"北京市 北京市" x:116.40 y:39.90 eType:BNCoordinate_BaiduMapSDK],
                     ///116.433302,39.909622
                     [NodeModel createSelectNodeModel:@"北京天安门" x:116.433302 y:39.909622 eType:BNCoordinate_BaiduMapSDK],
                      [NodeModel createSelectNodeModel:@"北京某一点" x:116.306333 y:40.041690 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"北京荟聚宜家" x:116.331281 y:39.794892 eType:BNCoordinate_BaiduMapSDK uid:@"65f335dec9b88b61c2f1cf65"], // 65f335dec9b88b61c2f1cf65 //895d9912f77e240ad42ce2fe
                     [NodeModel createSelectNodeModel:@"北京丰台站P2停车场" x:116.311079 y:39.854544 eType:BNCoordinate_BaiduMapSDK uid:@"495530d6c2de6c0307026f72"],
                     [NodeModel createSelectNodeModel:@"上海南翔印象城MEGA" x:121.30596396419155 y:31.30491357950625 eType:BNCoordinate_BaiduMapSDK uid:@"1e05bcaec28d473c13293555"],

                     [NodeModel createSelectNodeModel:@"梅子湖公园北侧路侧停车场" x:100.99477053709425 y:22.76603509068343 eType:BNCoordinate_BaiduMapSDK uid:@"6d2a249dc5d87485118824e6"],
                     [NodeModel createSelectNodeModel:@"宁阳服务区-东" x:117.07558 y:35.873616 eType:BNCoordinate_BaiduMapSDK uid:@"c509cf6d1ee42f3186420e66"],
                     [NodeModel createSelectNodeModel:@"广州大学城" x:113.389744 y:23.060479  eType:BNCoordinate_GCJ],
                     [NodeModel createSelectNodeModel:@"北京市匈牙利大使馆" x:116.450531 y:39.939878 eType:BNCoordinate_GCJ],
                     [NodeModel createSelectNodeModel:@"洪市枢纽" x:112.817577 y:26.851828 eType:BNCoordinate_GCJ],
                     [NodeModel createSelectNodeModel:@"德胜国际中心(提前向右变道-进入辅路" x:116.371843 y:39.952796 eType:BNCoordinate_GCJ],
                     [NodeModel createSelectNodeModel:@"北京市惠民小区" x:116.998399 y:40.063828 eType:BNCoordinate_GCJ],
                     [NodeModel createSelectNodeModel:@"北京市城市建设档案馆" x:116.340189 y:39.912058 eType:BNCoordinate_GCJ],
                     [NodeModel createSelectNodeModel:@"北大医学部10号楼" x:116.358372 y:39.981024 eType:BNCoordinate_GCJ],
                     [NodeModel createSelectNodeModel:@"解放军总医院第六医学中心" x:116.317520 y:39.920841 eType:BNCoordinate_GCJ],
                     [NodeModel createSelectNodeModel:@"南方报业传媒集团" x:113.309779 y:23.129222 eType:BNCoordinate_GCJ],
                     [NodeModel createSelectNodeModel:@"武汉市江夏区栗庙路纳帕溪谷" x:114.414594 y:30.414795 eType:BNCoordinate_BaiduMapSDK],
                     [NodeModel createSelectNodeModel:@"北京火车站" x:116.433608 y:39.911127 eType:BNCoordinate_BaiduMapSDK],
                     
//                     [NodeModel createSelectNodeModel:@"武汉市江夏区栗庙路纳帕溪谷" x:114.428834 y:30.418665 eType:BNCoordinate_BaiduMapSDK],
///116.433302,39.909622
                     ]]
                   ]
                  ];
    
    [self initUI];
}

- (void)initUI {
    [self.tableView registerClass:[UITableViewCell class] forCellReuseIdentifier:@"cell"];
    UIBarButtonItem *rightItem =  [[UIBarButtonItem alloc] initWithTitle:@"算路" style:UIBarButtonItemStylePlain target:self action:@selector(enterDrivePage)];
    
    UIBarButtonItem *addNodesItem = [[UIBarButtonItem alloc] initWithTitle:@"未加途径点" style:UIBarButtonItemStylePlain target:self action:@selector(addWayNode:)];
    self.navigationItem.rightBarButtonItems = @[rightItem, addNodesItem];
}

- (void)addWayNode:(UIBarButtonItem*)item {
    self.isAddWay = !self.isAddWay;
    if (self.isAddWay) {
        item.title = @"添加途径点";
    } else {
        item.title = @"未加途径点";
    }
    
}
- (void)enterDrivePage {
    if (self.nodes.count < 3) return;
    if ([self.nodes[0] count] < self.startIndex) return;
    if ([self.nodes[1] count] < self.wayIndex) return;
    if ([self.nodes[2] count] < self.endIndex) return;
    
    NodeModel *startModel = self.nodes[0][self.startIndex];
    NodeModel *wayModel = self.nodes[1][self.wayIndex];
    NodeModel *endModel = self.nodes[2][self.endIndex];
    if (self.startIndex == 0) {
        CLLocation *myLocation = [BNaviService_Location getLastLocation];
        startModel.node.pos.x = myLocation.coordinate.longitude;
        startModel.node.pos.y = myLocation.coordinate.latitude;
        startModel.node.pos.eType = BNCoordinate_OriginalGPS;
        startModel.node.floorID = @"4";
        startModel.node.buildingID = @"56";
    }
    
    NSMutableArray *nodes = [NSMutableArray array];
    [nodes addObject:startModel.node];
    if (self.isAddWay && wayModel) {
        [nodes addObject:wayModel.node];
    }
    [nodes addObject:endModel.node];
     
    MultiMapFunctionalExamplesList *drivePageVc = [[MultiMapFunctionalExamplesList alloc] init];
    drivePageVc.nodes = nodes;
    [self.navigationController pushViewController:drivePageVc animated:YES];
    
}

#pragma mark - UITableViewDelegate, UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return self.nodes.count;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if (section < self.nodes.count) {
        return [self.nodes[section] count];
    }
    return 0;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell"];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    if (indexPath.section < self.nodes.count) {
        NSArray *nodes = self.nodes[indexPath.section];
        
        if (indexPath.row < nodes.count) {
            NodeModel *model = nodes[indexPath.row];
            cell.textLabel.text = model.title;
            
            int index = 0;
            if (indexPath.section == 0) {
                index = self.startIndex;
            } else if (indexPath.section == 1) {
                index = self.wayIndex;
            } else {
                index = self.endIndex;
            }
            
            if (indexPath.row == index) {
                cell.textLabel.textColor = [UIColor blueColor];
            } else {
                cell.textLabel.textColor = [UIColor blackColor];
            }
        }
    }
    return cell;
}

- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
    if (section == 0) {
        return @"起点";
    } else if (section == 1) {
        return @"途径点";
    }else if (section == 2) {
        return @"终点";
    }
    return @"";
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.section < self.nodes.count) {
        NSArray *nodes = self.nodes[indexPath.section];
        
        if (indexPath.row < nodes.count) {
            if (indexPath.section == 0) {
                self.startIndex = (int)indexPath.row;
            } else if (indexPath.section == 1) {
                self.wayIndex = (int)indexPath.row;
            } else {
                self.endIndex = (int)indexPath.row;
            }
            
            [tableView reloadData];
        }
    }
}

@end
