//
//  MultiMapViewController.m
//  NaviDemo
//
//  Created by v_lisisi on 2023-12-05.
//  Copyright © 2023 v_qinruiguang. All rights reserved.
//

#import "MultiMapViewController.h"
#import "BNaviIndoorLocationProtocol.h"
#import <BaiduMapAPI_Map/BMKMapView.h>
#import <BaiduMapAPI_Map/BMKMapComponent.h>
#import "BNBackgroundNavigationViewManagerProtocol.h"
#import "BackgroundInterceptionTool.h"
#import "IndoorLocationManager.h"
@interface MultiMapViewController () <BNaviSettingListenerManagerDelegate>
@property (nonatomic, strong) UIButton *overviewBtn;
@property (nonatomic, strong) UIButton *set2DBtn;
@property (nonatomic, strong) UIButton *set3DBtn;
@property (nonatomic, strong) UIButton *returnCarPosition;
@property(nonatomic, strong)  IndoorLocationManager *locationManager;
@property (nonatomic, strong) BMKBackgroundMapView *bgMapView;
@property (nonatomic, assign) BOOL isBackgroundMap;
@property (nonatomic, assign) BOOL isNaviMap;
@property (nonatomic, strong) BackgroundInterceptionTool *toolModel;
@end

@implementation MultiMapViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self mapConfig];
    [self createUI];
    //添加 设备旋转 通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(orientChange:) name:UIApplicationDidChangeStatusBarOrientationNotification object:nil];
    [BNaviService_NaviSet addSettingListener:self];
}
- (void)dealloc {
    [BNaviService_backgroundManager stop];
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)willTransitionToTraitCollection:(UITraitCollection *)newCollection withTransitionCoordinator:(id <UIViewControllerTransitionCoordinator>)coordinator {
    [super willTransitionToTraitCollection:newCollection withTransitionCoordinator:coordinator];
    [coordinator animateAlongsideTransition:^(id <UIViewControllerTransitionCoordinatorContext> context) {
        CGFloat screeHeight = UIScreen.mainScreen.bounds.size.height;
        if (self.mapSize.width != 0) {
            self.multiMapView.frame = CGRectMake(10, screeHeight - 200-self.mapSize.height, self.mapSize.width, self.mapSize.height);
        } else {
            self.multiMapView.frame = CGRectMake(10, screeHeight - 400, 300, 300);
        }
        [self.view setNeedsLayout];
    } completion:nil];
}
 
/**屏幕旋转的通知回调*/
- (void)orientChange:(NSNotification *)noti {
    CGFloat screeHeight = UIScreen.mainScreen.bounds.size.height;
    if (self.mapSize.width != 0) {
        self.multiMapView.frame = CGRectMake(10, screeHeight - 200-self.mapSize.height, self.mapSize.width, self.mapSize.height);
    } else {
        self.multiMapView.frame = CGRectMake(10, screeHeight - 400, 300, 300);
    }
        
}

- (void)createUI {

    self.view.backgroundColor = [UIColor whiteColor];
    
    self.enterCarNaviBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.enterCarNaviBtn setTitle:@"多实例开始导航" forState:UIControlStateNormal];
    
    self.enterCarNaviBtn.titleLabel.font = [UIFont boldSystemFontOfSize:18];
    [self.enterCarNaviBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.enterCarNaviBtn.backgroundColor = [UIColor orangeColor];
    
    self.enterCarNaviBtn.frame = CGRectMake(20, 100, self.view.bounds.size.width-40, 60);
    [self.enterCarNaviBtn addTarget:self action:@selector(enterCarNavi) forControlEvents:UIControlEventTouchUpInside];
    self.enterCarNaviBtn.layer.cornerRadius = 15;
    self.enterCarNaviBtn.layer.masksToBounds = YES;
    [self.view addSubview:self.enterCarNaviBtn];
    
    self.enterCarSimulatorNaviBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.enterCarSimulatorNaviBtn setTitle:@"多实例开始模拟导航" forState:UIControlStateNormal];
    
    self.enterCarSimulatorNaviBtn.titleLabel.font = [UIFont boldSystemFontOfSize:18];
    [self.enterCarSimulatorNaviBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.enterCarSimulatorNaviBtn.backgroundColor = [UIColor orangeColor];
    
    self.enterCarSimulatorNaviBtn.frame = CGRectMake(20, CGRectGetMaxY(self.enterCarNaviBtn.frame)+10, self.view.bounds.size.width-40, 60);
    [self.enterCarSimulatorNaviBtn addTarget:self action:@selector(enterCarSimulatorNavi) forControlEvents:UIControlEventTouchUpInside];
    self.enterCarSimulatorNaviBtn.layer.cornerRadius = 15;
    self.enterCarSimulatorNaviBtn.layer.masksToBounds = YES;
    [self.view addSubview:self.enterCarSimulatorNaviBtn];
    
    self.backgroundNaviBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.backgroundNaviBtn setTitle:@"多实例后台渲染" forState:UIControlStateNormal];
    self.backgroundNaviBtn.titleLabel.font = [UIFont boldSystemFontOfSize:18];
    [self.backgroundNaviBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.backgroundNaviBtn.backgroundColor = [UIColor orangeColor];
    
    self.backgroundNaviBtn.frame = CGRectMake(20, CGRectGetMaxY(self.enterCarSimulatorNaviBtn.frame)+10, self.view.bounds.size.width-40, 60);
    [self.backgroundNaviBtn addTarget:self action:@selector(enterNavibackgroundNaviBtn) forControlEvents:UIControlEventTouchUpInside];
    self.backgroundNaviBtn.layer.cornerRadius = 15;
    self.backgroundNaviBtn.layer.masksToBounds = YES;
    [self.view addSubview:self.backgroundNaviBtn];

    self.mapNaviBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.mapNaviBtn setTitle:@"主地图后台渲染" forState:UIControlStateNormal];
    self.mapNaviBtn.titleLabel.font = [UIFont boldSystemFontOfSize:18];
    [self.mapNaviBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.mapNaviBtn.backgroundColor = [UIColor orangeColor];
    
    self.mapNaviBtn.frame = CGRectMake(20, CGRectGetMaxY(self.backgroundNaviBtn.frame)+10, self.view.bounds.size.width-40, 60);
    [self.mapNaviBtn addTarget:self action:@selector(enterMapNaviBtn) forControlEvents:UIControlEventTouchUpInside];
    self.mapNaviBtn.layer.cornerRadius = 15;
    self.mapNaviBtn.layer.masksToBounds = YES;
    [self.view addSubview:self.mapNaviBtn];
    
}
-(void)enterMapNaviBtn {
    self.isBackgroundMap = YES;
    self.isNaviMap = YES;
    [self enterNavi:self.naviType];
}
- (void)enterNavibackgroundNaviBtn {
    self.isBackgroundMap = YES;
    self.isNaviMap = NO;
    [self enterNavi:self.naviType];
}

- (void)startRoutePlan {
    [self addVdrIndoorLocation];
    [BNaviService_RoutePlan startNaviRoutePlan:BNRoutePlanMode_Recommend naviNodes:self.nodes time:nil delegete:self userInfo:nil];
    BNaviService_Strategy.supportBackgroundSimulatedNavi = YES;
}

- (void)addVdrIndoorLocation {
    self.locationManager = [[IndoorLocationManager alloc] init];
    [self.locationManager  addVdrIndoorLocation];
}
- (void)enterCarNavi {
    self.isBackgroundMap = NO;
    self.isNaviMap = NO;
    [self enterNavi:self.naviType];
}

- (void)enterCarSimulatorNavi {
    self.isBackgroundMap = NO;
    self.isNaviMap = NO;
    if (self.naviType == BN_NaviTypeReal) {
        [self enterNavi:BN_NaviTypeSimulator];
    } else if (self.naviType == BN_NaviTypeMoto) {
        [self enterNavi:BN_NaviTypeMotoSimulator];
    } else if (self.naviType == BN_NaviTypeTruck) {
        [self enterNavi:BN_NaviTypeTruckSimulator];
    }
}

- (void)enterNavi:(BN_NaviType)naviType {
    [BNaviService_UI showPage:BNaviUI_NormalNavi delegate:self extParams:@{BNaviUI_NormalNavi_TypeKey:@(naviType)}];
    
}



#pragma  mark -- 多实例
- (void)mapConfig {
//    [BNaviService_MapOverlay setDIYImageToMap:[UIImage imageNamed:@"car1"] imageType:BN_DIYImage_CarLogo];
//    [BNaviService_MapOverlay setDIYImageHidden:NO imageType:BN_DIYImage_CarLogo];
//    
//    [BNaviService_MapOverlay setDIYImageHidden:NO imageType:BN_DIYImage_EndPoint];
    [BNaviService_Location startUpdate];
    if (!self.isDeleteListener) {
        [[BNaviModel getInstance] addNaviModelListener:self];
    }
    
    
    if (self.mapSize.width != 0) {
        if (!self.isDeleteMapView) {
            self.multiMapView = [BNaviService_MultMap createNaviMapViewWithTag:@"mapView1" withFrame:CGRectMake(10, self.view.bounds.size.height - 200-self.mapSize.height, self.mapSize.width, self.mapSize.height)];
        }
    } else {
        if (!self.isDeleteMapView) {
            self.multiMapView = [BNaviService_MultMap createNaviMapViewWithTag:@"mapView1" withFrame:CGRectMake(10, self.view.bounds.size.height - 400, 300, 300)];
        }
    }
    
    [self.multiMapView setRouteShowRect: UIEdgeInsetsMake(10, 10, 10, 10)];
    self.multiMapView.naviMapViewDelegate = self;
    [self.multiMapView set3DMode];
    [self hideMapCarElement];

    if (self.diyCarLog) {
        [self.multiMapView setDIYIcon:[UIImage imageNamed:@"car3"] type:BNMI_DIYImage_CarLogo];
        [self.multiMapView setDIYImageShow:YES type:BNMI_DIYImage_CarLogo];
    }
    
    if (self.diyEndLog) {
        [self.multiMapView setDIYIcon:[UIImage imageNamed:@"car1"] type:BNMI_DIYImage_EndPoint];
        [self.multiMapView setDIYImageShow:YES type:BNMI_DIYImage_EndPoint];
    }
    
    if (self.diyWayLog) {
        [self.multiMapView setWayPointCustomImages:@[[UIImage imageNamed:@"car1"], [UIImage imageNamed:@"car2"]] indexes:@[@(0), @(1)]];
    }
    
    

    
}

#pragma  mark -- 隐藏图像标签
-(void)hideMapCarElement {
    if (self.hideMapCarElementArray) {
        [self.multiMapView hideMapCarElement:self.hideMapCarElementArray];
    }
}

#pragma  mark BNKMapViewDelegate
- (CGPoint)carOffsetFor2DMode {
    return CGPointMake(0, -70);
}

- (CGPoint)carOffsetFor3DMode {
    return CGPointMake(0, -70);
}

- (void)tapOverview:(UIButton *)sender {
    sender.selected = !sender.isSelected;
    if (sender.isSelected) {
        [sender setTitle:@"退出" forState:UIControlStateNormal];
        [self.multiMapView setRouteShowRect:UIEdgeInsetsMake(10, 10, 10, 10)];
        [self.multiMapView setViewAllMode:YES];
    } else {
        [sender setTitle:@"全览" forState:UIControlStateNormal];
        [self.multiMapView setRouteShowRect:UIEdgeInsetsMake(10, 10, 10, 10)];
        [self.multiMapView setViewAllMode:NO];
        [self.multiMapView set3DMode];
    }
 
}

- (void)tapReturnCarPosition:(UIButton *)sender {
    [self.multiMapView setRouteShowRect:UIEdgeInsetsMake(10, 10, 10, 10)];
    [self.multiMapView set3DMode];
}

- (void)tapSet2dMode:(UIButton *)sender {
    sender.selected = !sender.isSelected;
    if (sender.isSelected) {
        [self.multiMapView set3DMode];
    } else {
        [self.multiMapView set2DMode];
    }
}


#pragma mark -- BNNaviRoutePlanDelegate

- (void)onExitPage:(BNaviUIType)pageType extraInfo:(NSDictionary *)extraInfo {
    [self.multiMapView destroyController];
    [self.toolModel stop];
    NSLog(@"----");
}
#pragma mark -- BNNaviUIManagerDelegate
- (void)onHandleNaviViewDidLoad:(UIView *)naviView {
    if (!naviView) {
        return;
    }
    if (self.isBackgroundMap) {
        self.toolModel = [[BackgroundInterceptionTool alloc] init];
        self.toolModel.time = 5;
        self.bgMapView = [[BMKBackgroundMapView alloc] init];
        self.bgMapView.frame = CGRectMake(0, 0, self.view.frame.size.width, 300);
        self.bgMapView.navigationView = [BNaviService_backgroundManager backgroundNavigationView];
        self.bgMapView.navigationView.routePassedDisplayMode = BMKRoutePassedDisplayModeGrayed;
        if (self.isNaviMap) {
            self.bgMapView.mapview = [BNaviService getInstance].naviMapView;
            [[BNaviService getInstance].naviMapView setSupportBackgroundDraw:YES];
        } else {
            self.bgMapView.mapview = self.multiMapView;
            [self.multiMapView setSupportBackgroundDraw:YES];
        }
        self.bgMapView.frameRate = 60;
        self.bgMapView.navigationView.needDrawCompass = YES;
        [BNaviService_backgroundManager start];
        [self.bgMapView startRender];
        self.toolModel.capView = self.bgMapView;
        [self.toolModel start];
        
        [naviView addSubview:self.bgMapView];
        
    } else {
        UIViewController *vc = [BNaviService_UI navigationController];
        [vc.view addSubview:self.multiMapView];
        if (self.overviewBtn) {
            return;
        }
        self.overviewBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self.overviewBtn setTitle:@"全览" forState:UIControlStateNormal];
        [self.overviewBtn setBackgroundColor:[UIColor orangeColor]];
        self.overviewBtn.titleLabel.font = [UIFont systemFontOfSize:13];
        
        [self.overviewBtn setTitleColor:[UIColor redColor] forState:UIControlStateNormal];
        [self.overviewBtn addTarget:self action:@selector(tapOverview:) forControlEvents:UIControlEventTouchUpInside];
        self.overviewBtn.frame = CGRectMake(0, 250, 40, 40);
        [self.multiMapView addSubview:self.overviewBtn];
        self.overviewBtn.layer.cornerRadius = 12;
        [self.multiMapView  addUIViewBound:self.overviewBtn.frame];
        
        self.set2DBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self.set2DBtn setTitle:@"2d" forState:UIControlStateNormal];
        [self.set2DBtn setTitle:@"3d" forState:UIControlStateSelected];
        [self.set2DBtn setBackgroundColor:[UIColor orangeColor]];
        self.set2DBtn.titleLabel.font = [UIFont systemFontOfSize:13];
        
        [self.set2DBtn setTitleColor:[UIColor redColor] forState:UIControlStateNormal];
        [self.set2DBtn addTarget:self action:@selector(tapSet2dMode:) forControlEvents:UIControlEventTouchUpInside];
        self.set2DBtn.frame = CGRectMake(0, 200, 40, 40);
        [self.multiMapView addSubview:self.set2DBtn];
        self.set2DBtn.layer.cornerRadius = 12;
        [self.multiMapView  addUIViewBound:self.set2DBtn.frame];
        
        [self.returnCarPosition setTitleColor:[UIColor redColor] forState:UIControlStateNormal];
        [self.returnCarPosition addTarget:self action:@selector(tapReturnCarPosition:) forControlEvents:UIControlEventTouchUpInside];
        self.returnCarPosition.frame = CGRectMake(0, self.multiMapView.bounds.size.height - 40, 40, 40);
        [self.multiMapView addSubview:self.returnCarPosition];
        self.returnCarPosition.layer.cornerRadius = 12;
        [self.multiMapView  addUIViewBound:self.returnCarPosition.frame];
    }
    
}
- (void)onHandleMapRefresh:(BNaviMapRefreshInfo*)mapRefreshInfo {
    if (mapRefreshInfo.eMapRefreshType == BNaviMapRefresh_Type_RoadConditon ) {
        NSLog(@"---------0-------");
        for (int i = 0; i<mapRefreshInfo.roadCondition.count; i++) {
            BNaviRoadConditionItem *md = mapRefreshInfo.roadCondition[i];
            NSLog(@"BNaviMapRefresh_Type_RoadConditon endIndex = %d  eRoadConditionType = %lu", md.startPointToCurItemDistance, (unsigned long)md.eRoadConditionType);
            
        }
        
        
    }
    
}

/**导航视角：跟随车头、正北朝上、HUD*/
- (void)onHandleDidSettingNavigationPerspective:(BN_Navi_Perspective_Mode)mode {
    if (mode == BN_Navi_Perspective_Head) {
        [self.multiMapView set3DMode];
    } else if (mode == BN_Navi_Perspective_North) {
        [self.multiMapView set2DMode];
    } else {
        [self.multiMapView set3DMode];
    }
}

/**日夜模式：自动、白天、夜间*/
- (void)onHandleDidSettingDayNightMode:(BNDayNight_CFG_Type)mode {
    switch (mode) {
        case BNDayNight_CFG_Type_Auto:
        {
            if (BNaviService_Strategy.realDayNightType ==  BNDayNight_Type_Day) {
                [self.multiMapView setNight:NO];
            } else {
                [self.multiMapView setNight:YES];
            }
        }
            break;
        case BNDayNight_CFG_Type_Day:
            [self.multiMapView setNight:NO];
            break;
        case BNDayNight_CFG_Type_Night:
            [self.multiMapView setNight:YES];
            break;
        default:
            break;
    }
}

/** 实时路况开关 */
- (void)onHandleDidRoadConditionSwitch:(BN_Navi_RoadCondition_Mode)mode {
    [self.multiMapView showRoadCondition: mode == BN_Navi_RoadCondition_Open];
}



@end
