//
//  MultiMapViewController.h
//  NaviDemo
//
//  Created by v_lisisi on 2023-12-05.
//  Copyright © 2023 v_qinruiguang. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "BNMultiMapManagerProtocol.h"
#import "BNaviService.h"
#import "BNaviModel.h"
#import "BNaviLanesIconModel.h"
#import "BNGuideViewModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface MultiMapViewController : UIViewController <BNKMapViewDelegate, BNaviModelDelegate, BNNaviRoutePlanDelegate, BNNaviUIManagerDelegate>
@property (nonatomic, assign) BN_NaviType naviType;
@property (nonatomic, strong) UIButton *enterCarNaviBtn;
@property (nonatomic, strong) UIButton *enterCarSimulatorNaviBtn; 
@property (nonatomic, strong) UIButton *backgroundNaviBtn;
@property (nonatomic, strong) UIButton *mapNaviBtn;

@property (nonatomic, strong) BNKMapView *multiMapView;

@property (nonatomic, copy) NSArray *nodes;

@property (nonatomic, assign) CGSize  mapSize;

@property (nonatomic, assign) BOOL  diyCarLog;

@property (nonatomic, assign) BOOL  diyWayLog;

@property (nonatomic, assign) BOOL  diyEndLog;

@property (nonatomic, copy) NSArray *hideMapCarElementArray;
@property (nonatomic, assign) BOOL  isDeleteListener;

@property (nonatomic, assign) BOOL  isDeleteMapView;
@end

NS_ASSUME_NONNULL_END
