//
//  MultiMapFunctionalExamplesList.m
//  NaviDemo
//
//  Created by v_lisisi on 2023-12-07.
//  Copyright © 2023 v_qinruiguang. All rights reserved.
//

#import "MultiMapFunctionalExamplesList.h"
#import "ExpandMapViewController.h"
#import "LaneViewController.h"
#import "GuideViewViewController.h"
#import "ETAViewController.h"
#import "ComplexInterfaceViewController.h"
@interface MultiMapFunctionalExamplesList ()

@property (nonatomic, strong) NSArray *data;
@end

@implementation MultiMapFunctionalExamplesList

- (void)viewDidLoad {
    [super viewDidLoad];
    
    
    self.data = @[@"放大图", @"车信", @"诱导面板", @"ETA面板数据", @"小地图（200*200）", @"小地图（300*350）", @"小地图（300*450）", @"自定义车标Icon", @"自定义终点Icon", @"自定义途径点Icon", @"电子眼、路名、拥堵", @"路线、安全提示、UGC外露", @"机动点诱导、路线可理解性、终点", @"红绿灯标签、路况预测标签", @"不添加小地图", @"不加消息", @"不加小地图和消息", @"综合放大图车信诱导面板eta"];
    
    [self.tableView registerClass:[UITableViewCell class] forCellReuseIdentifier:@"Cell"];
    self.tableView.rowHeight = 60;
    self.tableView.tableFooterView = [UIView new];
   
}

#pragma mark - Table view data source


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.data.count;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    // 从重用池中获取 UITableViewCell
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Cell" forIndexPath:indexPath];
    
    // 如果没有可重用的 cell，则创建一个新的
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"Cell"];
    }
    
    // 设置 cell 的内容
    cell.textLabel.text = self.data[indexPath.row];
    
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row==0) {
        ExpandMapViewController *vc = [[ExpandMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 1) {
        LaneViewController *vc = [[LaneViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 2) {
        GuideViewViewController *vc = [[GuideViewViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 3) {
        ETAViewController *vc = [[ETAViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 4) {
        MultiMapViewController *vc = [[MultiMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.mapSize = CGSizeMake(200, 200);
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 5) {
        MultiMapViewController *vc = [[MultiMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.mapSize = CGSizeMake(300, 350);
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 6) {
        MultiMapViewController *vc = [[MultiMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.mapSize = CGSizeMake(300, 450);
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 7) {
        MultiMapViewController *vc = [[MultiMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.diyCarLog = YES;
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 8) {
        MultiMapViewController *vc = [[MultiMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.diyEndLog = YES;
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 9) {
        MultiMapViewController *vc = [[MultiMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.diyWayLog = YES;
        [self.navigationController pushViewController:vc animated:YES];
    }  else if (indexPath.row == 10) {
        MultiMapViewController *vc = [[MultiMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.hideMapCarElementArray = @[@(BNMapCarElementType_Camera), @(BNMapCarElementType_EnterRoad), @(BNMapCarElementType_Jam)];
        [self.navigationController pushViewController:vc animated:YES];
    }  else if (indexPath.row == 11) {
        MultiMapViewController *vc = [[MultiMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.hideMapCarElementArray = @[@(BNMapCarElementType_Route), @(BNMapCarElementType_RouteDesc), @(BNMapCarElementType_Ugc)];
        [self.navigationController pushViewController:vc animated:YES];
    }  else if (indexPath.row == 12) {
        MultiMapViewController *vc = [[MultiMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.hideMapCarElementArray = @[@(BNMapCarElementType_Guide), @(BNMapCarElementType_TrafficSign), @(BNMapCarElementType_DestNode)];
        [self.navigationController pushViewController:vc animated:YES];
    }  else if (indexPath.row == 13) {
        MultiMapViewController *vc = [[MultiMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.hideMapCarElementArray = @[@(BNMapCarElementType_TrafficLight), @(BNMapCarElementType_RouteConditionForecast)];
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 14) {
        ExpandMapViewController *vc = [[ExpandMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.isDeleteMapView =  YES;
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 15) {
        ExpandMapViewController *vc = [[ExpandMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.isDeleteListener =  YES;
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 16) {
        ExpandMapViewController *vc = [[ExpandMapViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        vc.isDeleteMapView =  YES;
        vc.isDeleteListener =  YES;
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 17) {
        ComplexInterfaceViewController *vc = [[ComplexInterfaceViewController alloc] init];
        vc.title = self.data[indexPath.row];
        vc.nodes = self.nodes;
        [self.navigationController pushViewController:vc animated:YES];
    }

    
}


@end
