//
//  LaneViewController.m
//  NaviDemo
//
//  Created by v_lisisi on 2023-12-08.
//  Copyright © 2023 v_qinruiguang. All rights reserved.
//

#import "LaneViewController.h"

@interface LaneViewController ()<BNaviModelDelegate, BNNaviRoutePlanDelegate, BNNaviUIManagerDelegate>

@property (nonatomic, strong) UIView *multiSubView;

@end

@implementation LaneViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"车道线";
    
    
    self.multiSubView = [[UIView alloc] init];
    self.multiSubView.backgroundColor = [UIColor colorWithRed:0 green:0.48 blue:1 alpha:1];
    self.multiSubView.frame = CGRectMake(10, 55, 280, 50);
    [self.multiMapView addSubview:self.multiSubView];
    self.multiSubView.layer.cornerRadius = 10;
    self.multiSubView.layer.masksToBounds = YES;
    self.multiSubView.hidden = YES;
}

 

- (void)onHandleNaviLaneInfoChanged:(BNaviLaneInfo *)param withLanesIcons:(NSArray<BNaviLanesIconModel*> *)array {
    if (param.eAction == BNaviMessage_Action_Update || param.eAction ==  BNaviMessage_Action_Show) {
        self.multiSubView.hidden = NO;
    } else {
        self.multiSubView.hidden = YES;
    }
    
    for (UIView *sb in self.multiSubView.subviews) {
        [sb removeFromSuperview];
    }

    for (int i = 0; i<array.count; i++) {
        UIImageView *imgView = [[UIImageView alloc] init];
        imgView.contentMode =  UIViewContentModeScaleAspectFit;
        BNaviLanesIconModel *model = array[i];
        NSString *imagePath = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:[NSString stringWithFormat:@"baiduNaviSDK.bundle/image/%@", model.iconStr]];
        UIImage *image = [UIImage imageWithContentsOfFile:imagePath];
        imgView.image = image;
        imgView.frame = CGRectMake((20*i), 0, 20, 50);
        [self.multiSubView addSubview:imgView];
    }
    
}


@end
