//
//  LocationManager.m
//  NaviDemo
//
//  Created by v_lisisi on 2024/9/25.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//
#import <BMKLocationkit/BMKLocationComponent.h>
#import "BNaviService.h"
#import "IndoorLocationManager.h"

@interface IndoorLocationManager ()
@property(nonatomic, strong) BMKLocationManager *locationManager;
@end

@implementation IndoorLocationManager

+(void)locationAuth:(NSString *)key {
    [[BMKLocationAuth sharedInstance] checkPermisionWithKey:key authDelegate:nil];
}

- (void)addVdrIndoorLocation {
     [[BMKLocationAuth sharedInstance] setAgreePrivacy:YES];
     self.locationManager = [[BMKLocationManager alloc] init];
//    设置返回位置的坐标系类型
     self.locationManager.coordinateType = BMKLocationCoordinateTypeBMK09LL;
//    设置距离过滤参数
     self.locationManager.distanceFilter = kCLDistanceFilterNone;
//    设置预期精度参数
     self.locationManager.desiredAccuracy = kCLLocationAccuracyBest;
//    设置应用位置类型
     self.locationManager.activityType = CLActivityTypeAutomotiveNavigation;
//    设置是否自动停止位置更新
     self.locationManager.pausesLocationUpdatesAutomatically = NO;
//    设置是否允许后台定位
     self.locationManager.allowsBackgroundLocationUpdates = YES;
//    设置位置获取超时时间
     self.locationManager.locationTimeout = 10;
//    设置获取地址信息超时时间
     self.locationManager.reGeocodeTimeout = 10;
     [self.locationManager startUpdatingLocation];
     [BNaviService_NaviIndoorLocation setLocationManager: self.locationManager];
 }

@end
