//
//  GuideViewViewController.m
//  NaviDemo
//
//  Created by v_lisisi on 2023-12-08.
//  Copyright © 2023 v_qinruiguang. All rights reserved.
//

#import "GuideViewViewController.h"

@interface GuideViewViewController ()
///驾车
@property (nonatomic, strong) UIView *guideView;
///诱导转向icon
@property (nonatomic, strong) UIImageView *guideTurnIconImg;
///xx+距离单位
@property (nonatomic, strong) UILabel *remainDistWithUnitLab;
///出口 lab 高速出口
@property (nonatomic, strong) UILabel *exitInfoLab;
///衔接词
@property (nonatomic, strong) UILabel *cohesiveWordLab;
///方向、主路
//@property (nonatomic, strong) UILabel *assistWordLab;
////loading
@property (nonatomic, strong) UILabel *loadingLab;

///摩托车
//随后 text
@property (nonatomic, strong) UILabel *afterLab;
///随后转向
@property (nonatomic, strong) UIImageView *afterIconImg;

@end

@implementation GuideViewViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.title = @"诱导面板";
    
    self.guideView = [[UIView alloc] init];
    self.guideView.backgroundColor = [UIColor systemOrangeColor];
    self.guideView.frame = CGRectMake(0, 30, 300, 100);
    [self.multiMapView addSubview:self.guideView];
    
    self.guideTurnIconImg = [[UIImageView alloc] init];
    [self.guideView addSubview:self.guideTurnIconImg];
    
    self.remainDistWithUnitLab = [[UILabel alloc] init];
    self.remainDistWithUnitLab.numberOfLines = 0;
    self.remainDistWithUnitLab.font = [UIFont boldSystemFontOfSize:25];
    [self.guideView addSubview:self.remainDistWithUnitLab];
    
    self.exitInfoLab = [[UILabel alloc] init];
    self.exitInfoLab.numberOfLines = 0;
    self.exitInfoLab.font = [UIFont boldSystemFontOfSize:18];
    [self.guideView addSubview:self.exitInfoLab];
    
    self.cohesiveWordLab = [[UILabel alloc] init];
    self.cohesiveWordLab.numberOfLines = 0;
    self.cohesiveWordLab.font = [UIFont systemFontOfSize:14];
    [self.guideView addSubview:self.cohesiveWordLab];
    
    self.loadingLab = [[UILabel alloc] init];
    self.loadingLab.numberOfLines = 0;
    self.loadingLab.font = [UIFont boldSystemFontOfSize:20];
    [self.guideView addSubview:self.loadingLab];
    
    
    self.afterIconImg = [[UIImageView alloc] init];
    [self.guideView addSubview:self.afterIconImg];
    
    self.afterLab = [[UILabel alloc] init];
    self.afterLab.font = [UIFont boldSystemFontOfSize:20];
    [self.guideView addSubview:self.afterLab];
    
    [self setCarUIFrame];
    
}
- (void)setCarUIFrame {
    self.guideTurnIconImg.frame =  CGRectMake(10, 20, 40, 40);
    
    self.remainDistWithUnitLab.frame = CGRectMake(60, 20, 200, 30);
    
    self.exitInfoLab.frame = CGRectMake(180, 30, 80, 20);
    
    self.cohesiveWordLab.frame = CGRectMake(60, 60, 280, 20);
    
    self.loadingLab.frame = CGRectMake(60, 20, 200, 60);
    self.loadingLab.hidden = YES;
    
    
    self.afterLab.frame = CGRectMake(240, 60, 50, 20);
    self.afterIconImg.frame = CGRectMake(240, 10, 50, 50);
}

/// 驾车诱导面板
- (void)onHandleNewSimpleGuideUIInfo:(BNGuideViewCombinationModel *)model {
    if (model) {
        NSString *text ;
        BNGuideViewMainModel    *mainModel = model.mainModel;
        if ([mainModel isKindOfClass:[BNGuideViewExitMainModel class]]) {
            self.guideView.backgroundColor = [UIColor colorWithRed:46/255.0 green:139/255.0 blue:87/255.0 alpha:1];
            self.guideTurnIconImg.image = [self getImgWithString:mainModel.turnIconStr];
            self.remainDistWithUnitLab.text = [NSString stringWithFormat:@"%@%@", mainModel.remainDistNumStr, mainModel.remainDistUnitStr];
            self.exitInfoLab.text = mainModel.exitInfo?:@"";
            self.cohesiveWordLab.text = [NSString stringWithFormat:@"%@ %@", mainModel.cohesiveWord, mainModel.supplementWord];
            self.loadingLab.hidden = YES;
            NSLog(@"onHandleNewSimpleGuideUIInfo - BNGuideViewExitMainModel");
        } else if ([mainModel isKindOfClass:[BNGuideViewWithoutExitMainModel class]]) {
            self.guideView.backgroundColor = [UIColor grayColor];
            NSLog(@"onHandleNewSimpleGuideUIInfo - BNGuideViewWithoutExitMainModel BNGuideViewDefaultMainModel");
            BNGuideViewWithoutExitMainModel *outeExitModel = (BNGuideViewWithoutExitMainModel*)mainModel;
            self.guideTurnIconImg.hidden = NO;
            /// 车标自由 或  模糊诱导
            if (outeExitModel.isCarFree || outeExitModel.state == BNGuideDefaultViewStateFuzzy) {
                
                self.guideTurnIconImg.image = [self getImgWithString:mainModel.turnIconStr];
                self.loadingLab.text = outeExitModel.fuzzyText;
                if (outeExitModel.state == BNGuideDefaultViewStateFuzzy) {
                    self.guideTurnIconImg.hidden = NO;
                } else {
                    self.guideTurnIconImg.hidden = YES;
                }
                
                self.remainDistWithUnitLab.hidden = YES;
                self.exitInfoLab.hidden = YES;
                self.cohesiveWordLab.hidden = YES;
                self.loadingLab.hidden = NO;
            } else if (outeExitModel.isLoading) {
                self.loadingLab.text = outeExitModel.loadingText;
                self.guideTurnIconImg.image = [self getImgWithString:mainModel.turnIconStr];
                self.remainDistWithUnitLab.hidden = YES;
                self.exitInfoLab.hidden = YES;
                self.cohesiveWordLab.hidden = YES;
                self.loadingLab.hidden = NO;
            } else {
                self.guideTurnIconImg.image = [self getImgWithString:outeExitModel.turnIconStr];
                if (outeExitModel.state == BNGuideDefaultViewStateNormal) {
                    if (outeExitModel.roadType == BNGuideViewRoadNormalType) {
                        self.remainDistWithUnitLab.text = [NSString stringWithFormat:@"%@ %@ %@", outeExitModel.remainDistNumStr, outeExitModel.remainDistUnitStr?:@"", outeExitModel.cohesiveWord ?:@""];
                        self.cohesiveWordLab.text =[NSString stringWithFormat:@"%@", outeExitModel.supplementWord?:@""];
                        self.exitInfoLab.text = @"";
                    } else if (outeExitModel.roadType == BNGuideViewRoadVDRType) {
                        self.remainDistWithUnitLab.text = [NSString stringWithFormat:@"%@ %@ %@", outeExitModel.cohesiveWord , outeExitModel.supplementWord, outeExitModel.assistWord];
                        self.exitInfoLab.text = @"";
                    }
                } else if (outeExitModel.state == BNGuideDefaultViewStateHighway) {
                    if (outeExitModel.roadType == BNGuideViewRoadNormalType) {
                        NSString *roadName = outeExitModel.supplementWord?:@"";
                        NSString *cohesive = outeExitModel.cohesiveWord?:@"";
                        NSString *assist = outeExitModel.assistWord?:@"";
                        self.cohesiveWordLab.text = [NSString stringWithFormat:@"%@ %@ %@", cohesive, roadName, assist];
                        self.remainDistWithUnitLab.text = [NSString stringWithFormat:@"%@ %@", outeExitModel.remainDistNumStr, outeExitModel.remainDistUnitStr?:@""];
                        self.exitInfoLab.text = outeExitModel.exitInfo?:@"";
                    } else if (outeExitModel.roadType == BNGuideViewRoadStraightType) {
                        self.remainDistWithUnitLab.text = [NSString stringWithFormat:@"%@ %@", outeExitModel.remainDistNumStr, outeExitModel.remainDistUnitStr?:@""];
                        NSString *roadName = outeExitModel.supplementWord?:@"";
                        NSString *cohesive = outeExitModel.cohesiveWord?:@"";
                        self.cohesiveWordLab.text =[NSString stringWithFormat:@"%@ %@", cohesive, roadName];
                        self.exitInfoLab.text = @"";
                    }
                }
                
                self.guideTurnIconImg.hidden = NO;
                self.remainDistWithUnitLab.hidden = NO;
                self.exitInfoLab.hidden = NO;
                self.cohesiveWordLab.hidden = NO;
                self.loadingLab.hidden = YES;
                text = [NSString stringWithFormat:@"%@-%@-%@-%@-%@-%@-%@-%@-%@",
                        outeExitModel.turnIconStr,
                        outeExitModel.remainDistNumStr?:@"",
                        outeExitModel.remainDistUnitStr?:@"",
                        outeExitModel.exitInfo?:@"",
                        outeExitModel.cohesiveWord?:@"",
                        outeExitModel.assistWord?:@"",
                        outeExitModel.supplementWord?:@"",
                        @(outeExitModel.isCarFree),
                        outeExitModel.fuzzyText?:@""
                ];
            }
            NSLog(@"onHandleNewSimpleGuideUIInfo - BNGuideViewMiniMainModel");
        } else if ([mainModel isKindOfClass:[BNGuideViewMainModel class]]) {
            NSLog(@"onHandleNewSimpleGuideUIInfo -  BNGuideViewMainModel");
        }
        
    }
    
    
}

- (UIImage *)getImgWithString:(NSString*)imgStr {
    NSString *imagePath = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:[NSString stringWithFormat:@"baiduNaviSDK.bundle/image/%@", imgStr]];
    UIImage *image = [UIImage imageWithContentsOfFile:imagePath];
    return image;
}



@end
