//
//  ExpandMapViewController.m
//  NaviDemo
//
//  Created by v_lisisi on 2023-12-07.
//  Copyright © 2023 v_qinruiguang. All rights reserved.
//

#import "ExpandMapViewController.h"
#import "BNaviModel.h"
#import "BNaviExpandGuideModel.h"

@interface ExpandMapViewController ()<BNaviModelDelegate, BNNaviRoutePlanDelegate, BNNaviUIManagerDelegate>

@property (nonatomic, strong) UIView *expView;

@property (nonatomic, strong) UIImageView *rasterExpandMap;

@property (nonatomic, strong) UIView *progressView;

@property (nonatomic, strong) UILabel *progressLab;

@property (nonatomic, strong) UILabel *remainDist;
@property (nonatomic, strong) UIImageView  *midTurnImage;
@property (nonatomic, strong) UILabel *exitRoad;
@property (nonatomic, strong) UILabel *roadName;
@property (nonatomic, strong) UILabel *nextTurnStr;
@property (nonatomic, strong) UIImageView *nextTurnImage;


@end

@implementation ExpandMapViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    
    self.view.backgroundColor = [UIColor whiteColor];
    [self addUIView];
    
}

-(void)addUIView {
    self.expView = [[UIView alloc] init];
    self.expView.frame  = CGRectMake(50, 0, 200, 200);
    [self.multiMapView addSubview:self.expView];
    
    self.rasterExpandMap = [[UIImageView alloc] init];
    self.rasterExpandMap.frame  = CGRectMake(0, 0, 200, 200);
    [self.expView addSubview:self.rasterExpandMap];
    
    self.progressView = [[UIView alloc] init];
    self.progressView.backgroundColor = [UIColor orangeColor];
    self.progressView.frame  = CGRectMake(50, 240, 250, 60);
    [self.multiMapView addSubview:self.progressView];
   
    self.progressLab = [[UILabel alloc] init];
    [self.progressView addSubview:self.progressLab];
    
    self.remainDist = [[UILabel alloc] init];
    [self.progressView addSubview:self.remainDist];
    
    self.midTurnImage = [[UIImageView alloc] init];
    [self.progressView addSubview:self.midTurnImage];
    
    self.exitRoad = [[UILabel alloc] init];
    [self.progressView addSubview:self.exitRoad];
    
    self.roadName = [[UILabel alloc] init];
    [self.progressView addSubview:self.roadName];
    
    self.nextTurnStr = [[UILabel alloc] init];
    [self.progressView addSubview:self.nextTurnStr];
    
    self.nextTurnImage = [[UIImageView alloc] init];
    [self.progressView addSubview:self.nextTurnImage];
    
    self.progressLab.frame = CGRectMake(0, 0, 60, 18);
    
    self.remainDist.frame = CGRectMake(60, 0, 70, 18);
    
    self.midTurnImage.frame = CGRectMake(140, 0, 30, 18);
    
    self.exitRoad.frame = CGRectMake(170, 0, 70, 18);
    
    self.roadName.frame = CGRectMake(0, 20, 200, 20);
    
    self.nextTurnStr.frame = CGRectMake(0, 40, 60, 20);
    
    self.nextTurnImage.frame = CGRectMake(70, 40, 20, 20);
    
    
}

#pragma mark -- BNaviModelDelegate
/**
 *  处理路口动态放大图消息
 *  rasterExpandMap是对外的view视图。
 *  注意事项：
 *  1、不可以对rasterExpandMap进行frame、bound的修改，仅做外部截屏使用。
 *  2、rasterExpandMap是手机导航内部使用的view，禁止将rasterExpandMap 添加在其他view上（[self.view addSubview:rasterExpandMap]），或将其他自定义view 添加在rasterExpandMap之上（[rasterExpandMap addSubview:自定义View]）。
 *  3、禁止将rasterExpandMap  =  nil；禁止 [rasterExpandMap removeFromSuperview];
 *
 *  @param rasterExpandMap 为nil 代表图片不需要修改。跟上一次的图片是一样的。
 *  @param model 如果为nil代表放大图需要隐藏。不为nil 代表需要展示
 */
- (void)onHandleExpandMap:(UIView *)rasterExpandMap guideModel:(BNaviExpandGuideModel *)model {
    if (model) {
        if (rasterExpandMap && [rasterExpandMap isKindOfClass:[UIView class]]) {
            UIImage *img = [self screenshotView:rasterExpandMap];
            self.rasterExpandMap.image = img;
            
        }
    }
    [self subViewUpate:model];
       
}



- (void)subViewUpate:(BNaviExpandGuideModel *)model {
    if (model) {
        self.expView.hidden = NO;
        self.progressLab.text = [NSString stringWithFormat:@"%f", model.progress];
        
        self.remainDist.text = [NSString stringWithFormat:@"%@", model.remainDist];

        NSString *midTurnImagePath = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:[NSString stringWithFormat:@"baiduNaviSDK.bundle/image/%@", model.midTurnImageStr]];
        UIImage *midTurnImage = [UIImage imageWithContentsOfFile:midTurnImagePath];
        self.midTurnImage.image = midTurnImage;
        
        self.exitRoad.text = model.exitRoad;
        
        self.roadName.text = model.roadName;
        
        self.nextTurnStr.text = model.nextTurnStr;
        
//        self.nextTurnImage.image = model.nextTurnImage;
        NSString *nextTurnPath = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:[NSString stringWithFormat:@"baiduNaviSDK.bundle/image/%@", model.nextTurnImageStr]];
        UIImage *nextTurnImg = [UIImage imageWithContentsOfFile:nextTurnPath];
        self.nextTurnImage.image = nextTurnImg;
        
    } else {
        self.expView.hidden = YES;
        self.progressLab.text = @"";
        
        self.remainDist.text = @"";
        
        self.midTurnImage.image = nil;
        
        self.exitRoad.text = @"";
        
        self.roadName.text = @"";
        
        self.nextTurnStr.text = @"";
        
        self.nextTurnImage.image = nil;
    }
}

- (UIImage *)screenshotView:(UIView *)viewToScreenshot {
    // 开始截图
    UIGraphicsBeginImageContextWithOptions(viewToScreenshot.bounds.size, NO, [UIScreen mainScreen].scale);
    // 将指定的视图的内容绘制到当前图形上下文中
    [viewToScreenshot drawViewHierarchyInRect:viewToScreenshot.bounds afterScreenUpdates:YES];
    // 从当前图形上下文中获取截图
    UIImage *screenshot = UIGraphicsGetImageFromCurrentImageContext();
    // 结束图形上下文
    UIGraphicsEndImageContext();
    return screenshot;
}

@end
