//
//  ETAViewController.m
//  NaviDemo
//
//  Created by v_lisisi on 2023-12-12.
//  Copyright © 2023 v_qinruiguang. All rights reserved.
//

#import "ETAViewController.h"
#import "LightDataHelper.h"
@interface ETAViewController ()

@property (nonatomic, strong) UIView *etaView;

@property (nonatomic, strong) UILabel *remainLabel;

@property (nonatomic, strong) UILabel *trafficlightLabel;

@end

@implementation ETAViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.title = @"ETA";
    self.etaView = [[UIView alloc] init];
    self.etaView.backgroundColor = [UIColor orangeColor];
    
    [self.multiMapView addSubview:self.etaView];
    self.etaView.frame = CGRectMake(20, 20, 250, 50);
    
    self.remainLabel = [[UILabel alloc] init];
    self.remainLabel.numberOfLines = 0;
    self.remainLabel.font = [UIFont systemFontOfSize:14];
    [self.etaView addSubview:self.remainLabel];
    
    
    self.trafficlightLabel = [[UILabel alloc] init];
    self.trafficlightLabel.numberOfLines = 0;
    self.trafficlightLabel.font = [UIFont systemFontOfSize:14];
    [self.etaView addSubview:self.trafficlightLabel];
    
    self.remainLabel.frame = CGRectMake(0, 0, self.etaView.bounds.size.width, 30);
    self.trafficlightLabel.frame = CGRectMake(0, 30, 100, 20);
    
}


/**
 * ETA 剩余信息
 *
 *  @param remainInfo 剩余信息
 */
- (void)onHandleRemainInfo:(BNaviRemainInfo*)remainInfo {
    
    self.remainLabel.text = [NSString stringWithFormat:@"%@ %@", [self mUnitToKm:remainInfo.remainDist], [LightDataHelper seconds2HourAndMinDescription:remainInfo.remainTime]];
    
}

- (void)onHandleRemainUIInfo:(BNaviEtaRemainUIInfo *)remainInfo {
    
    self.remainLabel.text = [NSString stringWithFormat:@"%@ %@ %@", remainInfo.remainDist, remainInfo.remainTime, remainInfo.arrivalTime];
}
/**
 *  处理剩余红绿灯信息
 *
 */
- (void)onHandleRemainTrafficlightsInfo:(BNaviRemainTrafficlightsInfo*)remainTrafficlightsInfo {
    self.trafficlightLabel.text = [NSString stringWithFormat:@"剩余红绿灯 %ld", remainTrafficlightsInfo.remainTrafficights];
}

- (void)onHandleDrivingRouteChange:(BNCarRouteModel *)routeModel {
    self.remainLabel.text = @"";
    self.trafficlightLabel.text = @"";
}

-(NSString *)mUnitToKm:(NSInteger)dist {
    if (dist < 1000) {
        return [NSString stringWithFormat:@"%ldm", (long)dist];
    } else {
        CGFloat distKm = dist / 1000.0;
        return [NSString stringWithFormat:@"%0.1fkm", distKm];
    }
}


@end
