//
//  BackgroundInterceptionTool.m
//  NaviDemo
//
//  Created by v_lisisi on 2024-03-20.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "BackgroundInterceptionTool.h"

@interface BackgroundInterceptionTool ()
@property (nonatomic, strong) NSTimer *screenshotTimer;
@end

@implementation BackgroundInterceptionTool

- (void)start {
    if (!self.capView) {
        return;
    }
    // 监听应用程序进入后台的通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationDidEnterBackground) name:UIApplicationDidEnterBackgroundNotification object:nil];
    
    // 监听应用程序进入前台的通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationDidBecomeActive) name:UIApplicationDidBecomeActiveNotification object:nil];
}

- (void)stop {
    [self applicationDidBecomeActive];
    // 移除通知监听
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIApplicationDidEnterBackgroundNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIApplicationDidBecomeActiveNotification object:nil];
}

- (void)applicationDidEnterBackground {
    if (!self.capView) {
        return;
    }
    // 启动定时器
    self.screenshotTimer = [NSTimer scheduledTimerWithTimeInterval:self.time target:self selector:@selector(takeScreenshot) userInfo:nil repeats:YES];
}

- (void)applicationDidBecomeActive {
    // 当应用程序进入前台时停止定时器
    [self.screenshotTimer invalidate];
    self.screenshotTimer = nil;
}

- (void)takeScreenshot {
    if (!self.capView) {
        return;
    }
    // 截取当前屏幕的图片
    UIGraphicsBeginImageContextWithOptions(self.capView.bounds.size, NO, 0.0);
    [self.capView drawViewHierarchyInRect:self.capView.bounds afterScreenUpdates:YES];
    UIImage *screenshot = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    // 保存图片到相册
    UIImageWriteToSavedPhotosAlbum(screenshot, nil, nil, nil);
}


@end
