//
//  MainViewController.m
//  NaviDemo
//
//  Created by Baidu on 15/1/14.
//  Copyright (c) 2015年 Baidu. All rights reserved.
//

#import "MainViewController.h"
#import "ExternalGPSViewController.h"
#import "PhoneGPSViewController.h"
#import "DigitDogViewController.h"
#import "SelectNodesViewController.h"
#import "TruckGPSViewController.h"
#import "BMKPointAnnotationPage.h"
#import "BMKPolylineOverlayPage.h"
#import "LightNaviViewController.h"

#import "BNaviService.h"
#import "DrivePageViewController.h"
#import "BNRoutePlanModel.h"
#import "MapViewDemoViewController.h"
#import "TruckGPSViewController.h"
#import "BMKPointAnnotationPage.h"
#import "BMKPolylineOverlayPage.h"

#import "WayPointPreferncerouteViewController.h"
#import "NaviSettingViewController.h"
#import "MultiMapFunctionalExamplesList.h"
#import "SelectNodeRoutePlaneController.h"
#import "CustomNaviMainViewController.h"
#import "RoutePlanViewController.h"
#import "CustomNaviNoUIViewController.h"
#import "MultiMapFunctionalExamplesList.h"


#define CAR_BOTTOMHEIGHT  50
#define CAR_NAVILOCATIONOFFSET 50
#define CAR_TOOLBARVIEWTOPSPACE 40

@interface MainViewController () <UITableViewDelegate, UITableViewDataSource, BNNaviUIManagerDelegate>

@property (strong, nonatomic) NSArray *titles;
@property (strong, nonatomic) NSArray *menuData;

@property (strong, nonatomic) NSArray *data;
@property (nonatomic, strong) UILabel *customizeTopView;
@property (nonatomic, strong) UIView *customizeBottomView;
@end

@implementation MainViewController

- (instancetype)initWithStyle:(UITableViewStyle)style {
    if (self = [super initWithStyle:style]) {
        self.titles = @[@"驾车导航", @"货车导航", @"摩托车导航", @"导航自定义", @"电子狗",@"其他"];
        self.menuData = @[@[@"路线结果页", @"轻导航", @"自定义UI控件", @"未来出行"],
                          @[@"路线结果页", @"轻导航",@"途经点偏好算路",@"自定义UI控件"],
                          @[@"路线结果页", @"自定义UI控件"],
                          @[@"多实例自定义",@"无UI导航进入SDK默认导航UI", @"多实例和后台渲染"],
                          @[@"电子狗导航"],
                          @[@"外部GPS导航", @"导航中设置"],
                          ];
    }
    return self;
}

- (void)initTableViewData {
    
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"百度导航SDK Demo"; 
}

#pragma mark - UITableViewDelegate, UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return self.menuData.count;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if (section < self.menuData.count) {
        return [self.menuData[section] count];
    }
    return 0;
}

- (UITableViewCell*)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString* cellIdentifier = @"Cell";
    
    UITableViewCell* cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellIdentifier];
        cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    }
    if (indexPath.section < self.menuData.count && indexPath.row < [self.menuData[indexPath.section] count]) {
        cell.textLabel.text = self.menuData[indexPath.section][indexPath.row];
    }
    return cell;
}

- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
    if (section < self.titles.count) {
        return self.titles[section];
    }
    return nil;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    __weak typeof(self) ws = self;
    if (indexPath.section == 0) {
        RoutePlanViewController *vc = [[RoutePlanViewController alloc] init];
        vc.naviType = BN_NaviTypeReal;
        if (indexPath.row == 3) {
            vc.isFuture = YES;
        }
        vc.block = ^(BOOL isSuccess, BN_NaviType naviType) {
            if (isSuccess) {
                if (indexPath.row == 0 || indexPath.row ==3) {
                    DrivePageViewController *drivePageVc = [[DrivePageViewController alloc] init];
                    drivePageVc.naviTye = naviType;
                    [self.navigationController pushViewController:drivePageVc animated:YES];
                } else if (indexPath.row == 1) {
                    LightNaviViewController *lightNavi = [[LightNaviViewController alloc] init];
                    lightNavi.naviType = @"Car";
                    [self.navigationController pushViewController:lightNavi animated:YES];
                } else if (indexPath.row == 2) {
                    BNaviService_Strategy.bottomButtonHeight = CAR_BOTTOMHEIGHT;
                    BNaviService_Strategy.toolBarViewTopSpace = CAR_TOOLBARVIEWTOPSPACE;
                    BNaviService_Strategy.naviLocationOffset = CAR_NAVILOCATIONOFFSET;
                    [BNaviService_UI showPage:BNaviUI_NormalNavi delegate:self extParams:nil];
                }
            }
        };
        [self.navigationController pushViewController:vc animated:YES];
    }        ///驾车
    else if (indexPath.section == 1) {
        if (indexPath.row == 2) {
            WayPointPreferncerouteViewController *vc = [[WayPointPreferncerouteViewController alloc] init];
            [self.navigationController pushViewController:vc animated:YES];
        } else {
            RoutePlanViewController *vc = [[RoutePlanViewController alloc] init];
            vc.naviType = BN_NaviTypeTruck;
            vc.block = ^(BOOL isSuccess, BN_NaviType naviType) {
                if (isSuccess) {
                    if (indexPath.row == 0) {
                        DrivePageViewController *drivePageVc = [[DrivePageViewController alloc] init];
                        drivePageVc.naviTye = naviType;
                        [self.navigationController pushViewController:drivePageVc animated:YES];
                    } else if (indexPath.row == 1) {
                        LightNaviViewController *lightNavi = [[LightNaviViewController alloc] init];
                        lightNavi.naviType = @"Truck";
                        [self.navigationController pushViewController:lightNavi animated:YES];
                    } else if (indexPath.row == 3) {
                        BNaviService_Strategy.bottomButtonHeight = CAR_BOTTOMHEIGHT;
                        BNaviService_Strategy.toolBarViewTopSpace = CAR_TOOLBARVIEWTOPSPACE;
                        BNaviService_Strategy.naviLocationOffset = CAR_NAVILOCATIONOFFSET;
                        [BNaviService_UI showPage:BNaviUI_NormalNavi delegate:self extParams:@{BNaviUI_NormalNavi_TypeKey:@(BN_NaviTypeTruck)}];
                    }
                }
            };
            [self.navigationController pushViewController:vc animated:YES];
        }
    }   /// 货车
    else if (indexPath.section == 2) {
        RoutePlanViewController *vc = [[RoutePlanViewController alloc] init];
        vc.naviType = BN_NaviTypeMoto;
        vc.block = ^(BOOL isSuccess, BN_NaviType naviType) {
            if (isSuccess) {
                if (indexPath.row == 0) {
                    DrivePageViewController *drivePageVc = [[DrivePageViewController alloc] init];
                    drivePageVc.naviTye = naviType;
                    [self.navigationController pushViewController:drivePageVc animated:YES];
                }  else if (indexPath.row == 1) {
                    BNaviService_Strategy.bottomButtonHeight = CAR_BOTTOMHEIGHT;
                    BNaviService_Strategy.toolBarViewTopSpace = CAR_TOOLBARVIEWTOPSPACE;
                    BNaviService_Strategy.naviLocationOffset = CAR_NAVILOCATIONOFFSET;
                    [BNaviService_UI showPage:BNaviUI_NormalNavi delegate:self extParams:@{BNaviUI_NormalNavi_TypeKey:@(BN_NaviTypeMoto)}];
                }
            }
        };
        [self.navigationController pushViewController:vc animated:YES];
    }   ///摩托车
    else if (indexPath.section == 3) {
        
        RoutePlanViewController *vc = [[RoutePlanViewController alloc] init];
        vc.isCustomUI = YES;
        vc.block = ^(BOOL isSuccess, BN_NaviType naviType) {
            if (isSuccess) {
                if (indexPath.row == 0) {
                    [ws.navigationController pushViewController:[[CustomNaviMainViewController alloc] init] animated:YES];
                } else if (indexPath.row == 1) {
                    [ws.navigationController pushViewController:[[CustomNaviNoUIViewController alloc] init] animated:YES];
                } else if (indexPath.row == 2) {
                    MultiMapFunctionalExamplesList *listVc = [[MultiMapFunctionalExamplesList alloc] init];
                    listVc.naviType = naviType;
                    [ws.navigationController pushViewController:listVc animated:YES];
                }
            }
        };
        [self.navigationController pushViewController:vc animated:YES];
    }   ///多实例
    else if (indexPath.section == 4) {
        if (indexPath.row == 0) {
            [self.navigationController pushViewController:[[DigitDogViewController alloc] init] animated:YES];
        }
    }   /// 电子狗
    else if (indexPath.section == 5) {
        if (indexPath.row == 0) {
            [self.navigationController pushViewController:[[ExternalGPSViewController alloc] init] animated:YES];
        } else if (indexPath.row == 1) {
            [self.navigationController pushViewController:[[NaviSettingViewController alloc] init] animated:YES];
        }
    }   ///其他
}


- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation {
    return NO;
}

- (BOOL)shouldAutorotate {
    return NO;
}


#pragma mark - 禁止横屏
- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait;
}

- (UIInterfaceOrientation)preferredInterfaceOrientationForPresentation {
    return UIInterfaceOrientationPortrait;
}
@end
