//
//  LoadingView.h
//  NaviDemo
//
//  Created by linbiao on 2019/5/10.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef void(^TimeOut)(void);

@interface LoadingView : UIView

/**
 开始动画
 */
- (void)startAnimation;

/**
 开始动画并设置timeout
 
 @param time timeout时间
 @param timeout 回调
 */
- (void)startAnimation:(NSInteger)time withTimeOutBlock:(void(^)(void))timeout;

/**
 结束动画
 */
- (void)stopAnimation;

/*
 *中间过程中更改卡片高度或者frame的
 */
- (void)resetLoadingContentWhenFrameChange;

/**
 更新底部文案&控制文案是否显示
 
 @param message 底部文案
 @param isShow 是否显示
 */
- (void)updateMessage:(NSString *)message withLabel:(BOOL)isShow;

@end

NS_ASSUME_NONNULL_END
