//
//  LoadingFailedView.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/10.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "LoadingFailedView.h"
#import "CommonDefine.h"
#import "UtilUITool.h"

@interface LoadingFailedView ()

@property (nonatomic, strong) UIView *contentView;
@property (nonatomic, strong) UILabel *tipsView;
@property (nonatomic, strong) UIButton *retryButton;
@property (nonatomic, strong) UIView *layerVIew;
@property (nonatomic, strong) UIImageView *iconView;

@end

@implementation LoadingFailedView

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self initViewWithFrame:frame];
    }
    return self;
}

#define kContentViewWidth 115
#define kContentViewHeight 32
#define kContentViewDis 5

#define kRetryButtonW 36

- (void)initViewWithFrame:(CGRect)frame {
    UIView *layerVIew = [[UIView alloc]initWithFrame:CGRectMake((frame.size.width-28-4)/2.0, (frame.size.height - 38-4)/2.0-7, 28, 38)];
    CAShapeLayer *shapeLayer1 = [CAShapeLayer layer];
    shapeLayer1.path = [UtilUITool loadingBezierPath].CGPath;
    
    shapeLayer1.strokeColor = UIColorFromRGBA(0xc6c7ca, 1).CGColor;
    shapeLayer1.lineWidth = 1.5;
    shapeLayer1.fillColor = [[UIColor clearColor] CGColor];
    shapeLayer1.strokeStart = 0.0;
    shapeLayer1.strokeEnd = 1.0;
    [layerVIew.layer addSublayer:shapeLayer1];
    [self addSubview:layerVIew];
    self.layerVIew = layerVIew;
   
    UIImageView *view = [[UIImageView alloc]initWithFrame:CGRectMake(1.5+(frame.size.width-26-4)/2.0, 2+(frame.size.height - 36-4)/2.0-7, 15, 12)];
    [view setImage:[UIImage imageNamed:@"du_failed_loading"]];
    view.center = layerVIew.center;
    view.frame = CGRectMake(view.origin.x, layerVIew.origin.y + 9, view.frame.size.width, view.frame.size.height);
    self.iconView = view;
    [self addSubview:view];
    
    _contentView = [[UIView alloc]initWithFrame:CGRectMake((frame.size.width - kContentViewWidth)/2.0f, CGRectGetMaxY(layerVIew.frame)+kContentViewDis, kContentViewWidth, kContentViewHeight)];
    [self addSubview:_contentView];
    
    _tipsView = [[UILabel alloc]initWithFrame:CGRectMake(0, kContentViewDis, kContentViewWidth, kContentViewHeight)];
    [_tipsView setText:@"路线规划失败,"];
    [_tipsView setTextColor:UIColorFromRGBA(0x666666, 1)];
    [_tipsView setFont:[UIFont systemFontOfSize:12.0f]];
    [self.tipsView sizeToFit];
    [_contentView addSubview:_tipsView];
    
    _retryButton = [[UIButton alloc]initWithFrame:CGRectMake(CGRectGetMaxX(_tipsView.frame)+3, -3.7, kRetryButtonW, kContentViewHeight)];
    [_retryButton setTitle:@"重试" forState:UIControlStateNormal];
    [_retryButton.titleLabel setFont:[UIFont systemFontOfSize:12.0f]];
    [_retryButton addTarget:self action:@selector(retryAction:) forControlEvents:UIControlEventTouchUpInside];
    [_retryButton setTitleColor:UIColorFromRGBA(0x3385ff, 1) forState:UIControlStateNormal];
    [_contentView addSubview:_retryButton];
    
    float width = _tipsView.frame.size.width + kRetryButtonW;
    
    _contentView.frame = CGRectMake((frame.size.width - width)/2.0f, CGRectGetMaxY(layerVIew.frame)+kContentViewDis, width, kContentViewHeight);
}

- (void)updateFailedMessage:(NSString *)message withRetryButton:(BOOL)isShow {
    if (message == nil) {
        if (isShow) {
            [_tipsView setText:@"路线规划失败,"];
        } else {
            [_tipsView setText:@"路线规划失败"];
        }
    } else {
        [_tipsView setText:message];
    }
    [_tipsView sizeToFit];
    float width;
    if (isShow) {
        _retryButton.hidden = NO;
        _retryButton.frame = CGRectMake(CGRectGetMaxX(_tipsView.frame)+3, -3.7, kRetryButtonW, kContentViewHeight);
        width = _tipsView.frame.size.width + kRetryButtonW;
    } else {
        _retryButton.hidden = YES;
        width = _tipsView.frame.size.width;
    }
    _contentView.frame = CGRectMake((self.frame.size.width - width)/2.0f, _contentView.frame.origin.y, width, kContentViewHeight);
    self.iconView.hidden = NO;
    self.layerVIew.hidden = NO;
}

- (void)updateFailedImage:(NSString *)imageName {
    self.layerVIew.hidden = YES;
    self.iconView.hidden = YES;
    UIImageView *failedImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:imageName]];
    failedImageView.frame = CGRectMake((self.width - 57)/2, (self.height - 57)/2 - kContentViewHeight/2, 57, 57);
    
    _contentView.top = failedImageView.bottom - 10;
    [self addSubview:failedImageView];
}

- (void)retryAction:(id)sender{
    if (_delegate && [_delegate respondsToSelector:@selector(retry)]) {
        [_delegate retry];
    }
}

- (void)updateLayout
{
    self.layerVIew.frame = CGRectMake((self.frame.size.width-28-4)/2.0, (self.frame.size.height - 38-4)/2.0-7, 28, 38);
    self.iconView.center = self.layerVIew.center;
    self.iconView.frame = CGRectMake(self.iconView.origin.x,  self.layerVIew.origin.y + 9, 15, 12);
    _tipsView.frame = CGRectMake(0, kContentViewDis, kContentViewWidth, kContentViewHeight);
    [_tipsView sizeToFit];
    float width;
    if (!_retryButton.hidden) {
        width = _tipsView.frame.size.width + kRetryButtonW;
    } else {
        width = _tipsView.frame.size.width;
    }
    
    _contentView.frame = CGRectMake((self.frame.size.width - width)/2.0f, CGRectGetMaxY(self.layerVIew.frame)+kContentViewDis, width, kContentViewHeight);
}

- (void)hideIconView:(BOOL)hide;
{
    self.iconView.hidden = hide;
    self.layerVIew.hidden = hide;
}

@end
