//
//  LoadingAnimationBar.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/10.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "LoadingAnimationBar.h"
#import "CommonDefine.h"

#define kAnimationViewSize          ADAPTOR_VALUE_750(100)
#define kRetryLabel                 @"重试"

@interface LoadingAnimationBar () <LoadingFailedViewDelegate>

@end

@implementation LoadingAnimationBar

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self constructUI];
    }
    return self;
}

- (void)constructUI {
    // loading 动画
    _animationView = [[LoadingView alloc] initWithFrame:CGRectMake((self.width - kAnimationViewSize)/2, (self.height - kAnimationViewSize - ADAPTOR_VALUE_750(20) - ADAPTOR_VALUE_750(24))/2, kAnimationViewSize, kAnimationViewSize)];
    [self addSubview:_animationView];
    
    _failedView = [[LoadingFailedView alloc] initWithFrame:CGRectMake(0, 0, self.width, self.height)];
    [self addSubview:_failedView];
    _failedView.delegate = self;
    _failedView.hidden = YES;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    if (_failedView.hidden) {
        _animationView.centerY = self.centerY;
        _animationView.left = (self.width - kAnimationViewSize)/2; //处理横竖屏
    } else {
        _failedView.frame = CGRectMake(0, 0, self.width, self.height);
        [_failedView updateLayout];
    }
}

- (void)setLoadingText:(NSString *)text {
    return;
}

- (void)updateFailedMessage:(NSString *)message withRetryButtonShow:(BOOL)isShowed {
    _animationView.hidden = YES;
    [_animationView stopAnimation];
    _failedView.hidden = NO;
    [self setNeedsLayout];
    [_failedView updateFailedMessage:message withRetryButton:isShowed];
}

- (void)startAnimation {
    _failedView.hidden = YES;
    _animationView.hidden = NO;
    [self setNeedsLayout];
    [_animationView startAnimation];
}

- (void)stopAnimation {
    [_animationView stopAnimation];
}

#pragma mark - delegate
- (void)retry{
    if ([self.delegate respondsToSelector:@selector(retryRoutePlan)]){
        [self.delegate retryRoutePlan];
    }
}

- (void)hideIconView:(BOOL)hide {
    if (!_failedView.hidden) {
        [_failedView hideIconView:hide];
    }
}

@end
