//
//  LightThreeTapCell.m
//  NaviDemo
//
//  Created by v_qinruiguang on 2021/5/27.
//  Copyright © 2021 v_qinruiguang. All rights reserved.
//

#import "LightThreeTapCell.h"

@interface LightThreeTapCell()
@property (weak, nonatomic) IBOutlet UILabel *titleLabel;
@property (weak, nonatomic) IBOutlet UILabel *timeLabel;

@property (weak, nonatomic) IBOutlet UILabel *kmLabel;

@property (weak, nonatomic) IBOutlet UIImageView *iconImg;

@property (weak, nonatomic) IBOutlet UILabel *signLabel;
@end



@implementation LightThreeTapCell

- (void)awakeFromNib {
    [super awakeFromNib];
    self.iconImg.image = [UIImage imageNamed:@"carscene_trafficlight"];
}
-(void)setModel:(BNLightOneRouteModel *)model {
    _model = model;
    self.titleLabel.text = model.labelInfo;
    self.timeLabel.text = model.expectedArriveTime;
    self.kmLabel.text = [NSString stringWithFormat:@"%@", [self mUnitToKm:model.remainDistance]];
    self.signLabel.text = [NSString stringWithFormat:@"%d", model.remainTrafficLights];
    
}
-(NSString *)mUnitToKm:(NSInteger)dist {
    if (dist < 1000) {
        return [NSString stringWithFormat:@"%ld米", (long)dist];
    } else {
        CGFloat distKm = dist / 1000.0;
        return [NSString stringWithFormat:@"%0.1f公里", distKm];
    }
}


- (void)setSelected:(BOOL)selected{
    [super setSelected:selected];
    if(selected) {
        UIColor *color = [UIColor colorWithRed:30/255.0 green:144/255.0 blue:255/255.0 alpha:1];
        
        self.titleLabel.textColor = color;
        self.timeLabel.textColor = color;
        self.kmLabel.textColor = color;
        self.signLabel.textColor = color;
        self.iconImg.image = [UIImage imageNamed:@"carscene_trafficlight_sel"];
    }else{
        self.titleLabel.textColor = [UIColor blackColor];
        self.timeLabel.textColor = [UIColor blackColor];
        self.kmLabel.textColor = [UIColor blackColor];
        self.signLabel.textColor = [UIColor blackColor];
        self.iconImg.image = [UIImage imageNamed:@"carscene_trafficlight"];
    }
    
}



@end
