//
//  LightRouteContentView.m
//  NaviDemo
//
//  Created by lisisi on 2019/5/14.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "LightRouteContentView.h"
#import "LightNaviSelectLineViewController.h"

#define BarHeight (44+SAFE_AREA_INSETS_TOP)

@interface LightRouteContentView ()
@property(nonatomic, strong)UIButton *starBtn;
@end

@implementation LightRouteContentView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor whiteColor];
        [self _initView];
    }
    return self;
}
-(void)_initView {
    self.tabPanel = [[LightThreeTapView alloc] initWithFrame:CGRectMake(0, 0, self.bounds.size.width, 100)];
    [self addSubview:self.tabPanel];
    self.layer.masksToBounds = YES;
    self.layer.cornerRadius = 10;
    self.starBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.starBtn setTitle:@"开始导航" forState:UIControlStateNormal];
    [self.starBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.starBtn.backgroundColor = [UIColor colorWithRed:224/255.0 green:102/255.0 blue:255/255.0 alpha:1];
    self.starBtn.frame = CGRectMake(30, self.tabPanel.bottom, self.bounds.size.width - 60, 40);
    [self addSubview:self.starBtn];
    self.starBtn.layer.masksToBounds = YES;
    self.starBtn.layer.cornerRadius = 20;
    [self.starBtn addTarget:self  action:@selector(tapNaviRoute) forControlEvents:UIControlEventTouchUpInside];
}

-(void)tapNaviRoute {
    [self.lightNaviVc enterNaviPage];
}



@end

