//
//  LightNaviTopRouteInfoView.m
//  NaviDemo
//
//  Created by v_qinruiguang on 2021/5/25.
//  Copyright © 2021 v_qinruiguang. All rights reserved.
//

#import "LightNaviTopRouteInfoView.h"
#import "LightDataHelper.h"
@interface LightNaviTopRouteInfoView()

@property(nonatomic, strong) UIView *bgView;
///全程距离和时间
@property(nonatomic, strong) UILabel *historyDistanceLabel;
@property(nonatomic, strong) UILabel *historyTimeLabel;
///剩余距离 和时间
@property(nonatomic, strong) UILabel *residueDistanceLabel;
@property(nonatomic, strong) UILabel *residueTimeLabel;

@end

@implementation LightNaviTopRouteInfoView




- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self _initView];
        [self _initViewFrame];
    }
    return self;
}


-(void)_initView {
    self.bgView = [[UIView alloc] init];
    self.bgView.backgroundColor = [UIColor colorWithRed:240/255.0 green:255/255.0 blue:255/255.0 alpha:1];
    [self addSubview:self.bgView];
    
    self.historyDistanceLabel = [[UILabel alloc] init];
    self.historyDistanceLabel.text = @"全程 ";
    self.historyDistanceLabel.font = [UIFont boldSystemFontOfSize:15];
    [self.bgView addSubview:self.historyDistanceLabel];
    
    self.historyTimeLabel = [[UILabel alloc] init];
    self.historyTimeLabel.text = @"全程时间 ";
    self.historyTimeLabel.font = [UIFont boldSystemFontOfSize:15];
    [self.bgView addSubview:self.historyTimeLabel];
    
    self.residueDistanceLabel = [[UILabel alloc] init];
    self.residueDistanceLabel.text = @"剩余 ";
    self.residueDistanceLabel.font = [UIFont boldSystemFontOfSize:15];
    [self.bgView addSubview:self.residueDistanceLabel];
    
    self.residueTimeLabel = [[UILabel alloc] init];
    self.residueTimeLabel.text = @"剩余 ";
    self.residueTimeLabel.font = [UIFont boldSystemFontOfSize:15];
    [self.bgView addSubview:self.residueTimeLabel];
    
    
}


-(void)_initViewFrame {
    
    self.bgView.frame = self.bounds;
    self.historyDistanceLabel.frame = CGRectMake(10,
                                                 10,
                                                 (self.bgView.bounds.size.width - 20) /2,
                                                 20);
    self.historyTimeLabel.frame = CGRectMake(10,
                                             CGRectGetMaxY(self.historyDistanceLabel.frame)+10,
                                             (self.bgView.bounds.size.width - 20) /2,
                                             20);
    
    self.residueDistanceLabel.frame = CGRectMake(CGRectGetMaxX(self.historyDistanceLabel.frame),
                                                 10,
                                                 (self.bgView.bounds.size.width - 20) /2,
                                                 20);
    self.residueTimeLabel.frame = CGRectMake(CGRectGetMaxX(self.historyTimeLabel.frame),
                                             CGRectGetMaxY(self.residueDistanceLabel.frame)+10,
                                             (self.bgView.bounds.size.width - 20) /2,
                                             20);
    
    self.bgView.layer.cornerRadius = 10;
    self.bgView.layer.masksToBounds = YES;
    
}

-(void)setRemainInfo:(BNaviRemainInfo *)remainInfo {
    self.residueDistanceLabel.text = [NSString stringWithFormat:@"剩余 %@", [self mUnitToKm:remainInfo.remainDist]];
    
    self.residueTimeLabel.text = [NSString stringWithFormat:@"剩余 %@", [LightDataHelper seconds2HourAndMinDescription:remainInfo.remainTime]];
}

-(void)setOneRouteModel:(BNCarOneRouteModel *)oneRouteModel {
    self.historyDistanceLabel.text = [NSString stringWithFormat:@"全程 %@", [self mUnitToKm:oneRouteModel.distance]];
    
    self.historyTimeLabel.text = [NSString stringWithFormat:@"全程 %@", [LightDataHelper seconds2HourAndMinDescription:oneRouteModel.time]];
    
}

-(NSString *)mUnitToKm:(NSInteger)dist {
    if (dist < 1000) {
        return [NSString stringWithFormat:@"%ldm", (long)dist];
    } else {
        CGFloat distKm = dist / 1000.0;
        return [NSString stringWithFormat:@"%0.1fkm", distKm];
    }
}


@end
