//
//  LightNaviRouteModelView.m
//  NaviDemo
//
//  Created by v_qinruiguang on 2021/5/26.
//  Copyright © 2021 v_qinruiguang. All rights reserved.
//

#import "LightNaviRouteModelView.h"


@interface LightNaviRouteModelView()<UITableViewDelegate, UITableViewDataSource>
@property(nonatomic, strong)UITableView *table;
@property(nonatomic, copy) NSArray *dataArr;
@property(nonatomic, copy) NSArray *dataTypeArr;
@end

@implementation LightNaviRouteModelView



- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.alpha = 0;
        [self _initView];
    }
    return self;
}
-(void)_initView {
    
    self.table = [[UITableView alloc] initWithFrame:self.bounds];
    [self.table registerClass:[UITableViewCell class] forCellReuseIdentifier:@"cell"];
    self.table.delegate = self;
    self.table.dataSource = self;
    self.table.tableFooterView = [UIView new];
    [self addSubview:self.table];
    self.dataArr = @[@"推荐",@"不走高速",@"少收费",@"躲避拥堵",@"时间优先",@"高速优先",@"省钱路线",@"距离最短"];
    self.dataTypeArr = @[@(BNRoutePlanMode_Recommend),@(BNRoutePlanMode_NoHeighWay),@(BNRoutePlanMode_LessToll),@(BNRoutePlanMode_LessJam),@(BNRoutePlanMode_SaveTime),@(BNRoutePlanMode_MainRoad),@(BNRoutePlanMode_EconomicRoute),@(BNRoutePlanMode_RoadFirst),];
    
}

-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    return 1;
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
-(UITableViewCell*)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell" forIndexPath:indexPath];
    
    cell.textLabel.text= self.dataArr[indexPath.row];
    return cell;
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (self.block) {
        self.block([self.dataTypeArr[indexPath.row] intValue],self.dataArr[indexPath.row]);
        [self hide];
    }
    
}
-(void)show {
    self.alpha = 0;
    [UIView animateWithDuration:0.3 animations:^{
        self.alpha = 1;
        self.frame =CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height);
    }];
}


-(void)hide {
    self.alpha = 1;
    [UIView animateWithDuration:0.3 animations:^{
        self.alpha = 1;
        self.frame =CGRectMake(0, self.bounds.size.height, self.bounds.size.width, self.bounds.size.height);
    }];
    
}
@end
