//
//  LightNaviPresentRouteInfoView.m
//  NaviDemo
//
//  Created by v_qinruiguang on 2021/5/25.
//  Copyright © 2021 v_qinruiguang. All rights reserved.
//

#import "LightNaviPresentRouteInfoView.h"

@interface LightNaviPresentRouteInfoView()
@property(nonatomic, strong) UIView *bgView;
///下一个距离
@property(nonatomic, strong) UILabel *nextRouteDistanceLabel;
/// 方向
@property(nonatomic, strong) UIImageView *directionImg;
//@property(nonatomic, strong) UIImageView *zhuan
///路名称
@property(nonatomic, strong) UILabel *nextRouteNameLabel;
///红绿灯
@property(nonatomic, strong) UILabel *signLabel;

@property(nonatomic, strong) UIStackView *stackView;

@end

@implementation LightNaviPresentRouteInfoView



- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self _initView];
        [self _initViewFrame];
    }
    return self;
}


-(void)_initView {
    self.bgView = [[UIView alloc] init];
    self.bgView.backgroundColor = [UIColor colorWithRed:240/255.0 green:255/255.0 blue:255/255.0 alpha:1];
    [self addSubview:self.bgView];
    
    self.nextRouteDistanceLabel = [[UILabel alloc] init];
    self.nextRouteDistanceLabel.text = @"距离 ";
    self.nextRouteDistanceLabel.font = [UIFont boldSystemFontOfSize:17];
  
    self.directionImg = [[UIImageView alloc] init];

    self.directionImg.backgroundColor = [UIColor redColor];
    
    self.nextRouteNameLabel = [[UILabel alloc] init];
    self.nextRouteNameLabel.text = @"路名";
    self.nextRouteNameLabel.textAlignment = NSTextAlignmentRight;
    self.nextRouteNameLabel.font = [UIFont boldSystemFontOfSize:17];
    
    self.stackView = [[UIStackView alloc] init];
    self.stackView.distribution = UIStackViewAlignmentCenter;
    self.stackView.alignment = UIStackViewAlignmentCenter;
    [_stackView addArrangedSubview:self.nextRouteDistanceLabel];
    [_stackView addArrangedSubview:self.directionImg];
    [_stackView addArrangedSubview:self.nextRouteNameLabel];
    [self.bgView addSubview:_stackView];

    self.signLabel = [[UILabel alloc] init];
    self.signLabel.text = @"红绿灯";
    self.signLabel.textAlignment = NSTextAlignmentLeft;
    self.signLabel.font = [UIFont boldSystemFontOfSize:17];
    [self.bgView addSubview:self.signLabel];
    
    
}


-(void)_initViewFrame {
    
    self.bgView.frame = self.bounds;
    self.stackView.frame = CGRectMake(10, 10, self.bgView.bounds.size.width-20, 50);
    self.signLabel.frame = CGRectMake(10, self.stackView.bottom+10, 200, 20);
    self.bgView.layer.cornerRadius = 10;
    self.bgView.layer.masksToBounds = YES;
    
}
-(void)setSignString:(NSString *)str {
    self.signLabel.text = [NSString stringWithFormat:@"红绿灯 %@", str];
}
-(void)setGuideInfo:(BNaviSimpleGuideInfo *)guideInfo {
    _guideInfo = guideInfo;
    self.nextRouteDistanceLabel.text =  [self mUnitToKm:guideInfo.remainDist];

    guideInfo.turnIconName  = [guideInfo.turnIconName stringByReplacingOccurrencesOfString:@".png"withString:@""];
    NSString *imagePath = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:[NSString stringWithFormat:@"baiduNaviSDK.bundle/image/%@", guideInfo.turnIconName]];
    self.directionImg.image = [UIImage imageWithContentsOfFile:imagePath];

    self.nextRouteNameLabel.text = guideInfo.nextNextRoadName;
}

-(NSDictionary*)nextTurnDict {
    return @{
      @(BNaviManeuver_Kind_Front):@"请直行",@(BNaviManeuver_Kind_Right_Front):@"向右前方行驶",
      @(BNaviManeuver_Kind_Right):@"右转",@(BNaviManeuver_Kind_Right_Back):@"向右后方转弯",
      @(BNaviManeuver_Kind_Back):@"请调头",@(BNaviManeuver_Kind_Left_Back):@"向左后方转弯",
      @(BNaviManeuver_Kind_Left):@"左转",@(BNaviManeuver_Kind_Left_Front):@"向左前方行驶",
      @(BNaviManeuver_Kind_Ring):@"进入环岛",@(BNaviManeuver_Kind_RingOut):@"驶出环岛",
      @(BNaviManeuver_Kind_Left_Side):@"靠左前方行驶",@(BNaviManeuver_Kind_Right_Side):@"靠右前方行驶",
      @(BNaviManeuver_Kind_Left_Side_Main):@"靠左前方行驶",@(BNaviManeuver_Kind_Branch_Left_Main):@"三岔路靠最左侧行驶",
      @(BNaviManeuver_Kind_Right_Side_Main):@"靠右前方行驶",@(BNaviManeuver_Kind_Branch_Right_Main):@"三岔路靠最右侧行驶",
      @(BNaviManeuver_Kind_Center_Main):@"三岔路沿中间行驶",@(BNaviManeuver_Kind_Left_Side_IC):@"靠左前方行驶",
      @(BNaviManeuver_Kind_Right_Side_IC):@"靠右前方行驶",@(BNaviManeuver_Kind_Branch_Left):@"三岔路靠最左侧行驶",
      @(BNaviManeuver_Kind_Branch_Right):@"三岔路靠最右侧行驶",@(BNaviManeuver_Kind_Branch_Center):@"三岔路沿中间行驶",
      @(BNaviManeuver_Kind_Start):@"",@(BNaviManeuver_Kind_Dest):@"到达目的地",
      @(BNaviManeuver_Kind_VIA1):@"到达途经点",@(BNaviManeuver_Kind_VIA2):@"到达途经点",
      @(BNaviManeuver_Kind_VIA3):@"到达途经点",@(BNaviManeuver_Kind_VIA4):@"到达途经点",
      @(BNaviManeuver_Kind_InFerry):@"到达渡口入口",@(BNaviManeuver_Kind_OutFerry):@"到达渡口出口",
      @(BNaviManeuver_Kind_TollGate):@"进入收费站",@(BNaviManeuver_Kind_Left_Side_Straight_IC):@"靠左前方行驶",
      @(BNaviManeuver_Kind_Right_Side_Straight_IC):@"靠右前方行驶",@(BNaviManeuver_Kind_Left_Side_Straight):@"靠左前方行驶",
      @(BNaviManeuver_Kind_Right_Side_Straight):@"靠右前方行驶",@(BNaviManeuver_Kind_Branch_Left_Straight):@"三岔路靠最左侧行驶",
      @(BNaviManeuver_Kind_Branch_Center_Straight):@"三岔路沿中间行驶",@(BNaviManeuver_Kind_Branch_Right_Straight):@"三岔路靠最右侧行驶",
      @(BNaviManeuver_Kind_Branch_Left_IC):@"三岔路靠最左侧行驶",@(BNaviManeuver_Kind_Branch_Center_IC):@"三岔路沿中间行驶",
      @(BNaviManeuver_Kind_Branch_Right_IC):@"三岔路靠最右侧行驶",@(BNaviManeuver_Kind_Branch_Left_IC_Straight):@"三岔路靠最左侧行驶",
      @(BNaviManeuver_Kind_Branch_Center_IC_Straight):@"三岔路沿中间行驶",@(BNaviManeuver_Kind_Branch_Right_IC_Straight):@"三岔路靠最右侧行驶",
      @(BNaviManeuver_Kind_Straight_2Branch_Left_Base):@"靠左前方行驶",@(BNaviManeuver_Kind_Straight_2Branch_Right_Base):@"靠右前方行驶",
      @(BNaviManeuver_Kind_Straight_3Branch_Left_Base):@"三岔路靠最左侧车道行驶",@(BNaviManeuver_Kind_Straight_3Branch_Middle_Base):@"三岔路沿中间车道行驶",
      @(BNaviManeuver_Kind_Straight_3Branch_Right_Base):@"三岔路靠最右侧车道行驶",@(BNaviManeuver_Kind_Left_2Branch_Left_Base):@"左转,驶入左侧车道",
      @(BNaviManeuver_Kind_Left_2Branch_Right_Base):@"左转,驶入右侧车道",@(BNaviManeuver_Kind_Left_3Branch_Left_Base):@"左转,驶入最左侧车道",
      @(BNaviManeuver_Kind_Left_3Branch_Middle_Base):@"左转,驶入中间车道",@(BNaviManeuver_Kind_Left_3Branch_Right_Base):@"左转,驶入最右侧车道",
      @(BNaviManeuver_Kind_Right_2Branch_Left_Base):@"右转,驶入左侧车道",@(BNaviManeuver_Kind_Right_2Branch_Right_Base):@"右转,驶入右侧车道",
      @(BNaviManeuver_Kind_Right_3Branch_Left_Base):@"右转,驶入最左侧车道",@(BNaviManeuver_Kind_Right_3Branch_Middle_Base):@"右转,驶入中间车道",
      @(BNaviManeuver_Kind_Right_3Branch_Right_Base):@"右转,驶入最右侧车道",
      @(BNaviManeuver_Kind_Left_Front_2Branch_Left_Base):@"靠左前方",
      @(BNaviManeuver_Kind_Left_Front_2Branch_Right_Base):@"靠右前方",
      @(BNaviManeuver_Kind_Right_Front_2Branch_Left_Base):@"靠左前方",
      @(BNaviManeuver_Kind_Right_Front_2Branch_Right_Base):@"靠右前方"
  } ;
}


-(NSString *)mUnitToKm:(NSInteger)dist {
    if (dist < 1000) {
        return [NSString stringWithFormat:@"%ldm", (long)dist];
    } else {
        CGFloat distKm = dist / 1000.0;
        return [NSString stringWithFormat:@"%0.1fkm", distKm];
    }
}

@end
