//
//  LightWebViewController.m
//  NaviDemo
//
//  Created by v_qinruiguang on 2021/6/29.
//  Copyright © 2021 v_qinruiguang. All rights reserved.
//

#import "LightWebViewController.h"
#import <WebKit/WKWebView.h>
@interface LightWebViewController ()
@property(nonatomic, strong) WKWebView *webview;
@property(nonatomic, strong) UIButton *backBtn;
@end

@implementation LightWebViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    self.webview = [[WKWebView alloc]init];
    [self.view addSubview:self.webview];
    self.webview.frame = self.view.bounds;
    [_webview loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:@"https://www.baidu.com"]]];
    
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setTitle:@"< 返回" forState:UIControlStateNormal];
    btn.frame = CGRectMake(30, 40, 150, 40);
    btn.backgroundColor = [UIColor orangeColor];
    [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [btn addTarget:self action:@selector(tapBack) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn];
    btn.layer.masksToBounds = YES;
    btn.layer.cornerRadius = 10;
}

-(void)tapBack {
    [self dismissViewControllerAnimated:YES completion:nil];
}


@end
