//
//  LightNaviViewController.m
//  NaviDemo
//
//  Created by chenxintao on 2021/5/19.
//  Copyright © 2021 v_qinruiguang. All rights reserved.
//

#import "LightNaviViewController.h"
#import "BNRoutePlanModel.h"
#import "BNaviService.h"
#import "CommonDefine.h"
#import "BNCarRouteData.h"
#import "LightNaviSelectLineViewController.h"

#import "LightNaviTopRouteInfoView.h"
#import "LightNaviPresentRouteInfoView.h"
#import "LightNaviRouteModelView.h"
#import "LocationManager.h"
#import "BNaviModel.h"
#import "LightWebViewController.h"
//#import <BMKLocationKit/BMKLocationManager.h>
#define TRUCK_BOTTOMHEIGHT  50
#define TRUCK_NAVILOCATIONOFFSET 60
#define TRUCK_TOOLBARVIEWTOPSPACE 40

#define CAR_BOTTOMHEIGHT  50
#define CAR_NAVILOCATIONOFFSET 50
#define CAR_TOOLBARVIEWTOPSPACE 40

@interface LightNaviViewController () <BNNaviRoutePlanDelegate, BNLightNaviManagerDelegate, LightNaviSelectLineViewControllerDelegate, BNaviViewDelegate, BNNaviUIManagerDelegate, BNaviModelDelegate>
@property (nonatomic, strong) UIButton *locationBtn;
@property (nonatomic, strong) UIButton *inNaviBtn;
@property (nonatomic, strong) UIButton *oneRouteBtn;
@property (nonatomic, strong) UIButton *routeModelViewBtn;
@property (nonatomic, strong) NSMutableArray *nodsArray;
@property (nonatomic, strong) LightNaviTopRouteInfoView *topRouteInfoView;
@property (nonatomic, strong) LightNaviPresentRouteInfoView *routeInfoView;
@property (nonatomic, strong) LightNaviRouteModelView *routeModelView;
@property (nonatomic, assign) BNRoutePlanMode  planModel;
@property (nonatomic, assign) BOOL enterNavi;
@property (nonatomic, assign) BOOL naviEnd;

@property (nonatomic, strong) UIButton *testBtn;
@property (nonatomic, strong) UIViewController *naviViewController;
@property (nonatomic, strong) UILabel *customizeTopView;
@property (nonatomic, strong) UIView *customizeBottomView;


@end

@implementation LightNaviViewController
// 设置货车信息
- (void)setTruckInfo {
    
    BMTruckInfoModel *model = [[BMTruckInfoModel alloc] init];
    model.truckType = BMTruckTypeMedium;
    model.powerType = BMTruckPowerTypeGasoline;
    model.carNumber = @"京A66666";
    model.emission = 1 * 1000;
    model.weight = 2.565 * 1000;
    model.load = 1.73 * 1000;
    model.length = 6 * 1000;
    model.width = 2.15 * 1000;
    model.height = 3.5 * 1000;
    model.axleNumber = 2;
    model.plateColor = BNTruckPlateColorGreen;
    model.axleWeight = 2 * 1000;
    model.oilCost = 13;
    model.truckCarType = BNTruckCarTypeEnegry; /// 新能源 、普通车
    [BNaviService_Strategy syncTruckInfoModel:model];
}
-(void)setCarInfo {
    BMCarInfoModel *model = [[BMCarInfoModel alloc] init];
    model.carNumber = @"京A66666";
    model.truckCarType = BNTruckCarTypeEnegry; /// 新能源 、普通车
    [BNaviService_Strategy syncCarModel:model];
}
- (void)viewDidLoad {
    [super viewDidLoad];
    [BNaviService_Location startUpdate];
    if ([self.naviType isEqualToString:@"Truck"]) {
        [self setTruckInfo];
    } else {
        [self setCarInfo];
    }
    self.view.backgroundColor = [UIColor whiteColor];
    // Do any additional setup after loading the view.
    [self configureBackButton];
    [self initView];
    self.planModel = BNRoutePlanMode_Recommend;
    if ([self.naviType isEqualToString:@"Truck"]) {
        self.title = @"货车-单线路";
    } else {
        self.title = @"驾车-单线路";
    }
    
    BNaviService_LightNavi.delegate = self;
    BNaviService_LightNavi.deleteRouteWhenArriveDestination = NO;
    [[BNaviModel getInstance] addNaviModelListener:self];
    BNaviService_Strategy.supportMoreSettings = YES;
    
    
}
- (void)onHandleExpandViewHiddenChange:(BOOL)hidden {
    if (!hidden) {
        self.customizeTopView.hidden = YES;
        BNaviService_Strategy.toolBarViewTopSpace = 0;
    } else {
        if ([self.naviType isEqualToString:@"Truck"]) {
            BNaviService_Strategy.toolBarViewTopSpace = TRUCK_TOOLBARVIEWTOPSPACE; //;
        } else {
            BNaviService_Strategy.toolBarViewTopSpace = CAR_TOOLBARVIEWTOPSPACE;
        }
        self.customizeTopView.hidden = NO;
    }
}

- (void)onHandleRoadConditionTypeChange:(BNNaviRoadConditionType)type {
    if (type == BNNaviRoadConditionTypeConciseRoadCondition) {
        NSLog(@"显示eta 顶部路况条");
    } else {
        NSLog(@"隐藏 eta 顶部路况条");
    }
    
    CGFloat btnHeight = 40;
    CGFloat top = BNaviService_Strategy.carBottomButtonTop - btnHeight; // -5;
    self.customizeTopView.frame = CGRectMake(0, top, self.customizeTopView.width, btnHeight);
}

- (void)onHandleNavigationMapLaneMode:(BNMultiMapsStatus)status {
    NSLog(@"onHandleNavigationMapLaneMode -- %lu", (unsigned long)status);
    if (status ==  BNMultiMapsStatusMulti) {
        self.customizeTopView.hidden = YES;
        self.customizeBottomView.hidden = YES;
        BNaviService_Strategy.bottomButtonHeight = 0;
        BNaviService_Strategy.toolBarViewTopSpace = 0;
        BNaviService_Strategy.naviLocationOffset = 0;

    } else {
        BNaviService_Strategy.bottomButtonHeight = CAR_BOTTOMHEIGHT; //CAR_BOTTOMHEIGHT;
        BNaviService_Strategy.toolBarViewTopSpace =  CAR_TOOLBARVIEWTOPSPACE; //CAR_TOOLBARVIEWTOPSPACE;
        BNaviService_Strategy.naviLocationOffset = CAR_NAVILOCATIONOFFSET;
        self.customizeTopView.hidden = NO;
        self.customizeBottomView.hidden = NO;
    }
    
}

-(void)onHandleNaviRouteWillChangedByType:(BNCalculateSourceType)type {
    NSLog(@"onHandleNaviRouteStart -- %d", type);
    
}
- (void)onHandleNaviRouteWillRefresh {
    NSLog(@"按了导航的刷新按钮");
}
/// 导航中刷新按钮刷新后回调
-(void)onHandleNaviRouteDidRefreshWithType:(BNaviMessage_OtherRoute_Enum)type {
    NSLog(@"按了导航的刷新结果");
}


- (void)onHandleNaviRouteDidChangedByType:(BNCalculateSourceType)type node:(BNRoutePlanNode *)node  index:(int)index error:(NSError *)error {
    NSLog(@"删除的index=%d 个途径点, 途径点名字=%@ 是否成功=%@",index, node.title,error);
    
}
-(void)initView {
    self.locationBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.locationBtn setTitle:@"定位" forState:UIControlStateNormal];

    [self.locationBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [self.locationBtn setBackgroundColor:[UIColor colorWithRed:255 / 255.0 green:231 / 255 blue:186/255 alpha:1]];
    [self.view addSubview:self.locationBtn];
    [self.locationBtn addTarget:self action:@selector(tapLocationBtn) forControlEvents:UIControlEventTouchUpInside];
    
    self.locationBtn.frame = CGRectMake(10, self.view.height - 100, 60, 40);
    self.locationBtn.layer.masksToBounds = YES;
    self.locationBtn.layer.cornerRadius = 10;
    
    self.oneRouteBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.oneRouteBtn setTitle:@"专业导航" forState:UIControlStateNormal];
    self.oneRouteBtn.selected=NO;
    self.oneRouteBtn.titleLabel.numberOfLines = 0;
    [self.oneRouteBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [self.oneRouteBtn setBackgroundColor:[UIColor colorWithRed:255 / 255.0 green:231 / 255 blue:186/255 alpha:1]]; //    255 231 186
    [self.view addSubview:self.oneRouteBtn];
    [self.oneRouteBtn addTarget:self action:@selector(tapInNaviBtn) forControlEvents:UIControlEventTouchUpInside];
    self.oneRouteBtn.layer.masksToBounds = YES;
    self.oneRouteBtn.layer.cornerRadius = 10;
        
    self.inNaviBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.inNaviBtn setTitle:@"多路线" forState:UIControlStateNormal];
    [self.inNaviBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [self.inNaviBtn setBackgroundColor:[UIColor colorWithRed:255 / 255.0 green:231 / 255 blue:186/255 alpha:1]];
    [self.view addSubview:self.inNaviBtn];
    [self.inNaviBtn addTarget:self action:@selector(tapSelectNaviRouteBtn) forControlEvents:UIControlEventTouchUpInside];
    
    
    self.inNaviBtn.layer.masksToBounds = YES;
    self.inNaviBtn.layer.cornerRadius = 10;
    //获取导航栏的高度
    CGFloat navHeight = CGRectGetMaxY(self.navigationController.navigationBar.frame);
    self.topRouteInfoView = [[LightNaviTopRouteInfoView alloc] initWithFrame:CGRectMake(10, navHeight + 30, self.view.bounds.size.width - 20, 80)];
    [self.view addSubview:self.topRouteInfoView];
    self.routeInfoView = [[LightNaviPresentRouteInfoView alloc] initWithFrame:CGRectMake(10, self.view.frame.size.height - 100, self.view.bounds.size.width -20, 100)];
    [self.view addSubview:self.routeInfoView];
    
    self.inNaviBtn.frame = CGRectMake(self.view.width - 90, CGRectGetMinY(self.routeInfoView.frame) - 60, 60, 40);
    self.oneRouteBtn.frame = CGRectMake(self.view.width - 90, CGRectGetMinY(self.inNaviBtn.frame) - 100, 60, 80);
    self.locationBtn.frame = CGRectMake(10, CGRectGetMinY(self.routeInfoView.frame) - 60, 60, 40);
    
    self.routeModelViewBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.routeModelViewBtn setTitle:@"推荐" forState:UIControlStateNormal];
    [self.routeModelViewBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [self.routeModelViewBtn setBackgroundColor:[UIColor colorWithRed:255 / 255.0 green:231 / 255 blue:186/255 alpha:1]];
    [self.view addSubview:self.routeModelViewBtn];
    [self.routeModelViewBtn addTarget:self action:@selector(tapSelectRouteModel) forControlEvents:UIControlEventTouchUpInside];
    
    self.routeModelViewBtn.frame = CGRectMake(10, self.view.height - 100-120, 80, 40);
    self.routeModelViewBtn.layer.masksToBounds = YES;
    self.routeModelViewBtn.layer.cornerRadius = 10;
    
    
}

-(void)tapSelectRouteModel {
    [self.routeModelView show];
    self.locationBtn.frame = CGRectMake(10, CGRectGetMinY(self.routeInfoView.frame) - 60, 60, 40);

}
- (void)configureBackButton {
    UIBarButtonItem *returnButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"< 返回" style:UIBarButtonItemStylePlain target:self action:@selector(backButtonPressed:)];
    self.navigationItem.leftBarButtonItem = returnButtonItem;
}

- (void)backButtonPressed:(id)sender {
    [BNaviService_LightNavi stopLightNavi];
    BNaviService_Strategy.bottomButtonHeight = 0;
    BNaviService_Strategy.naviLocationOffset = 0;
    BNaviService_Strategy.toolBarViewTopSpace = 0;
    [self.navigationController popViewControllerAnimated:YES];
    
}

- (void)multiRouteBackButtonPressed:(BOOL)naviEnd {
    if (!naviEnd) {
        [BNaviService_RoutePlan showMultiRoute:NO];
        [BNaviService_LightNavi zoomToSpan:self.zoomToSpanInsets];
    } else {
        [self hideUIControl];
    }
}

- (NSArray *)getNodes {
    BOOL useMyLocation = YES;
    NSMutableArray *nodesArray = [[NSMutableArray alloc]initWithCapacity:2];
    //起点 传入的是原始的经纬度坐标，若使用的是百度地图坐标，可以使用BNTools类进行坐标转化
    CLLocation *myLocation = [LocationManager getInstance].lastLocation;
    BNRoutePlanNode *startNode = [[BNRoutePlanNode alloc] init];
    startNode.pos = [[BNPosition alloc] init];
    if (useMyLocation) {
        startNode.pos.x = myLocation.coordinate.longitude;
        startNode.pos.y = myLocation.coordinate.latitude;
        startNode.pos.eType = BNCoordinate_OriginalGPS;
    }
    else {
        startNode.pos.x = 113.948222;
        startNode.pos.y = 22.549555;
        startNode.pos.eType = BNCoordinate_BaiduMapSDK;
    }
    [nodesArray addObject:startNode];
    
    //终点
    BNRoutePlanNode *endNode = [[BNRoutePlanNode alloc] init];
    endNode.pos = [[BNPosition alloc] init];
    endNode.pos.x = 113.940868;
    endNode.pos.y = 22.54647;
    endNode.pos.eType = BNCoordinate_BaiduMapSDK;
    endNode.title = @"腾讯大厦";
//    endNode.cityID = @"340";
//    endNode.uid = @"72e57fd7346dc5d2f8dc8560";
    [nodesArray addObject:endNode];
    return nodesArray;
}

- (void)startRoutePlan
{
    
    [BNaviService_Strategy setEnableMultiRoute:YES];
//    BNaviService_NaviSet.UGCReportButtonHidden = NO;
    NSArray *nodesArray = [self getNodes];
    self.nodsArray = [NSMutableArray array];
    [self.nodsArray addObjectsFromArray:nodesArray];
    //关闭openURL,不想跳转百度地图可以设为YES
    [BNaviService_RoutePlan setDisableOpenUrl:YES];
    [BNaviService_MapOverlay setDIYImageToMap:[UIImage imageNamed:@"car1"] imageType:BN_DIYImage_StartPoint];
    [BNaviService_MapOverlay setDIYImageHidden:YES imageType:BN_DIYImage_StartPoint];
//    if ([self.naviType isEqualToString:@"Truck"]) {
//        ///货车算路
//        [BNaviService_RoutePlan startNaviRoutePlan:self.planModel naviNodes:nodesArray time:nil delegete:self userInfo:@{BNaviTripTypeKey: @(BN_NaviTypeTruck), BNaviForceSwitchInValidKey:@(1)}];
//    } else {
//        ///驾车算路
//        [BNaviService_RoutePlan startNaviRoutePlan:self.planModel naviNodes:nodesArray time:nil delegete:self userInfo:nil];
//    }
    BNCarRouteModel *routeModel =  [BNaviService_DriveRoute getCurrentCarRouteData]; //userInfo[BNDriveRouteDataKey];
    BNCarOneRouteModel *oneRouteModel = routeModel.carRoutes.firstObject;
    self.topRouteInfoView.oneRouteModel = oneRouteModel;
    [self.routeInfoView setSignString:[NSString stringWithFormat:@"%ld", (long)oneRouteModel.lightNum]];
    //选择最后一条路线
    NSInteger selectRouteIndex = routeModel.carRoutes.count - 1;
    NSLog(@"路线条数 = %ld, 选择路线序号 = %ld",routeModel.carRoutes.count, selectRouteIndex);
    if (selectRouteIndex < 0) {
        selectRouteIndex = 0;
    }
    [BNaviService_RoutePlan selectRouteIndex:selectRouteIndex completion:^{
        [BNaviService_RoutePlan showMultiRoute:NO];
        [BNaviService_LightNavi startLightNavi];
        [BNaviService_LightNavi zoomToSpan:[self zoomToSpanInsets]];
        self.oneRouteBtn.selected = YES;
    }];
   
}
- (void)routePlanDidFinished:(NSDictionary *)userInfo {
    [self.routeModelView hide];
    
    BNCarRouteModel *routeModel =  userInfo[BNDriveRouteDataKey];
    BNCarOneRouteModel *oneRouteModel = routeModel.carRoutes.firstObject;
    self.topRouteInfoView.oneRouteModel = oneRouteModel;
    [self.routeInfoView setSignString:[NSString stringWithFormat:@"%ld", (long)oneRouteModel.lightNum]];
    //选择最后一条路线
    NSInteger selectRouteIndex = routeModel.carRoutes.count - 1;
    NSLog(@"路线条数 = %ld, 选择路线序号 = %ld",routeModel.carRoutes.count, selectRouteIndex);
    if (selectRouteIndex < 0) {
        selectRouteIndex = 0;
    }
    [BNaviService_RoutePlan selectRouteIndex:selectRouteIndex completion:^{
        [BNaviService_RoutePlan showMultiRoute:NO];
        [BNaviService_LightNavi startLightNavi];
        [BNaviService_LightNavi zoomToSpan:[self zoomToSpanInsets]];
        self.oneRouteBtn.selected = YES;
    }];
}

- (void)routePlanDidFailedWithError:(NSError *)error andUserInfo:(NSDictionary *)userInfo {
    switch ([error code]%10000) {
        case BNAVI_ROUTEPLAN_ERROR_LOCATIONFAILED:
            NSLog(@"暂时无法获取您的位置,请稍后重试");
            break;
        case BNAVI_ROUTEPLAN_ERROR_ROUTEPLANFAILED:
            NSLog(@"无法发起导航");
            break;
        case BNAVI_ROUTEPLAN_ERROR_LOCATIONSERVICECLOSED:
            NSLog(@"定位服务未开启,请到系统设置中打开定位服务。");
            break;
        case BNAVI_ROUTEPLAN_ERROR_NODESTOONEAR:
            NSLog(@"起终点距离起终点太近");
            break;
        case BNAVI_ROUTEPLAN_ERROR_DAYQUOTAEXCEEDED: {
            UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"提示" message:@"天配额超限制" delegate:self cancelButtonTitle:@"确认" otherButtonTitles:nil];
            [alertView show];
            break;
        }
        case BNAVI_ROUTEPLAN_ERROR_CONCURRENCYEXCEEDED: {
            UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"提示" message:@"并发超限" delegate:self cancelButtonTitle:@"确认" otherButtonTitles:nil];
            [alertView show];
            break;
        }
        default:
            NSLog(@"算路失败");
            break;
    }
}

- (UIEdgeInsets)zoomToSpanInsets {
    return UIEdgeInsetsMake(CGRectGetMaxY(self.topRouteInfoView.frame), 0, self.routeInfoView.height, 0);
}

-(void)viewWillAppear:(BOOL)animated {
    BNaviService_LightNavi.delegate = self;
    [super viewWillAppear:animated];
    [BNaviService_LightNavi viewWillAppear:self.view];
    [self tapLocationBtn];
}

-(void)viewWillDisAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    [BNaviService_LightNavi viewWillDisAppear:self.view];
}

/// 回到浏览态
-(void)tapLocationBtn {
    [BNaviService_LightNavi zoomToSpan:[self zoomToSpanInsets]];
}
// 进多路线
-(void)tapSelectNaviRouteBtn {
    BNaviService_Strategy.bottomButtonHeight = 0;
    BNaviService_Strategy.toolBarViewTopSpace = 0;
    BNaviService_Strategy.naviLocationOffset = 0;
    BNaviService_Strategy.showMuteButton = NO;
    BNaviService_Strategy.showRrefreshRouteButton = NO;
    [self.routeModelView hide];
//    [BNaviService_LightNavi stopLightNavi];
    LightNaviSelectLineViewController *selectLine = [[LightNaviSelectLineViewController alloc] init];
    selectLine.naviType = self.naviType;
    selectLine.nodes = [self getNodes];
    selectLine.delegate = self;
    [self.navigationController pushViewController:selectLine animated:YES];
    
}


// 进专业导航
-(void)tapInNaviBtn {
    
    if (!self.oneRouteBtn.isSelected) {
        return;
    }
    [self.routeModelView hide];
     
    BNaviService_Strategy.bottomButtonHeight = CAR_BOTTOMHEIGHT;//CAR_BOTTOMHEIGHT;
    BNaviService_Strategy.toolBarViewTopSpace = CAR_TOOLBARVIEWTOPSPACE; //CAR_TOOLBARVIEWTOPSPACE;
    BNaviService_Strategy.naviLocationOffset = CAR_NAVILOCATIONOFFSET;
    
   
    if ([BNaviService_LightNavi switchToRealNav:self withNaviType:self.naviType]) {
        [BNaviService_RoutePlan showMultiRoute:YES];
        [[BNaviModel getInstance] addNaviModelListener:self];
        self.enterNavi = YES;
    }
    
    
}

- (CGFloat)safeAreaBottomHeight {
    CGFloat bottomHeight = 0;
    if (@available(iOS 11.0, *)) {
        bottomHeight = [UIApplication sharedApplication].keyWindow.safeAreaInsets.bottom;
    }
    return bottomHeight;
}

-(void)onHandleProfessionalNaviViewDidLoad:(UIView *)naviView {
    if (naviView) {
        __weak __typeof(UIView *) weakNaviView = naviView;
        self.customizeTopView = [[UILabel alloc] init];
        self.customizeTopView.userInteractionEnabled = YES;
        self.customizeTopView.text = @"顶部区域";
        self.customizeTopView.textAlignment = NSTextAlignmentCenter;
        self.customizeTopView.backgroundColor = RGBA(0, 191, 255, 1);
        [weakNaviView addSubview:self.customizeTopView];
        
        
        UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
        [btn setTitle:@"跳转webview" forState:UIControlStateNormal];
        CGFloat btnHeight = 40;
        CGFloat top = BNaviService_Strategy.carBottomButtonTop - btnHeight; // -5;
        self.customizeTopView.frame = CGRectMake(0, top, weakNaviView.width, btnHeight);
        
        UILabel *customizeBottomView = [[UILabel alloc] init];
        customizeBottomView.text = @"底部自定义区域";
        customizeBottomView.textColor = [UIColor whiteColor];
        customizeBottomView.textAlignment = NSTextAlignmentCenter;
        customizeBottomView.backgroundColor = RGBA(0, 139, 139, 1);
        [weakNaviView addSubview:customizeBottomView];
        self.customizeBottomView = customizeBottomView;
        if (@available(iOS 11.0, *)) {
            CGFloat safeArea = [[UIApplication sharedApplication] keyWindow].safeAreaInsets.bottom;
            customizeBottomView.frame = CGRectMake(0, weakNaviView.height - BNaviService_Strategy.bottomButtonHeight - safeArea, weakNaviView.width, BNaviService_Strategy.bottomButtonHeight + safeArea);
        } else {
            // Fallback on earlier versions
        }
        customizeBottomView.layer.masksToBounds = YES;
        customizeBottomView.layer.cornerRadius = 6;
        
        
        self.customizeTopView.layer.masksToBounds = YES;
        self.customizeTopView.layer.cornerRadius = 6;
        
        btn.frame = CGRectMake(5, 0, 150, btnHeight);
        btn.backgroundColor = [UIColor orangeColor];
        [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [btn addTarget:self action:@selector(tapWebViewBtn) forControlEvents:UIControlEventTouchUpInside];
        [self.customizeTopView addSubview:btn];
        
        UIButton *alertBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [alertBtn setTitle:@"弹 窗" forState:UIControlStateNormal];
        alertBtn.frame = CGRectMake(naviView.right - 105, 0, 100, btnHeight);
       
        alertBtn.backgroundColor = [UIColor orangeColor];
        [alertBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [alertBtn addTarget:self action:@selector(tapAlertBtn) forControlEvents:UIControlEventTouchUpInside];
        [self.customizeTopView addSubview:alertBtn];
        
      
        
    }
    
}



-(void)tapAlertBtn {
       BNRoutePlanNode *endNode = [[BNRoutePlanNode alloc] init];
       endNode.pos = [[BNPosition alloc] init];
       endNode.pos.x = 114.189863;
       endNode.pos.y = 22.546236;
       endNode.pos.eType = BNCoordinate_BaiduMapSDK;
       [[BNaviModel getInstance] resetNaviEndPoint:endNode];
   
}
-(void)tapWebViewBtn {
    NSLog(@"tapTest");
    LightWebViewController *webV = [[LightWebViewController alloc]init];
    
    [(UIViewController *)[BNaviService_UI navigationController] presentViewController:webV animated:YES completion:nil];
    
}
- (void)hideUIControl {
    _routeModelViewBtn.hidden = YES;
    _inNaviBtn.hidden = YES;
    _oneRouteBtn.hidden = YES;
    _routeModelView.hidden = YES;
    _topRouteInfoView.hidden = YES;
    _routeModelView.hidden = YES;
    _routeInfoView.hidden = YES;
}

/// 从导航中切换回轻导航失败的回调，开发者需要重新算路并开始轻导航
- (void)onHandleSwitchToLightNaviFail {
    [self startRoutePlan];
}

/// 退出导航回调
- (void)onHandleExitNavi:(NSDictionary *)dict {
   
    if (self.enterNavi && self.naviEnd) {
    } else {
        [BNaviService_RoutePlan showMultiRoute:NO];
    }
    self.enterNavi =  NO;
    NSLog(@"onHandleExitNavi:%@", dict);
    
}

- (void)onHandleNaviStatusChange:(BNaviStatusInfo *)naviStatusInfo {
    
    if (!self.enterNavi) {
        if (naviStatusInfo.eNaviStatusType == BNaviStatus_Type_End2) {
            [self hideUIControl];
        }
    } else {
        if (naviStatusInfo.eNaviStatusType == BNaviStatus_Type_End2) {
            [self hideUIControl];
        }
    }
    
}
/// 返回剩余距离和 剩余时间
-(void)onHandleRemainInfo:(BNaviRemainInfo *)remainInfo {
    if (remainInfo.eAction == BNaviMessage_Action_Hide) {
        self.topRouteInfoView.hidden = YES;
    } else {
        self.topRouteInfoView.hidden = NO;
        self.topRouteInfoView.remainInfo = remainInfo;
    }
}
//// 时刻返回导航信息
-(void)onHandleSimpleGuideInfo:(BNaviSimpleGuideInfo*)simpleGuideInfo {
    self.routeInfoView.guideInfo = simpleGuideInfo;
    
}
///偏航后准备重新规划路线前的通知回调。
-(void)onHandleDrivingRouteChange:(BNCarRouteModel *)carRouteModel {
    [self.routeModelView hide];
    NSInteger selectedRouteIndex = [BNaviService_RoutePlan GetCurrentSelectRouteIdx];
    self.topRouteInfoView.oneRouteModel = carRouteModel.carRoutes.firstObject;
    NSLog(@"selectedRouteIndex = %ld",(long)selectedRouteIndex);
    if ([self.naviType isEqualToString:@"Truck"]) {
        BNaviService_Strategy.toolBarViewTopSpace = TRUCK_TOOLBARVIEWTOPSPACE; //;
    } else {
        BNaviService_Strategy.toolBarViewTopSpace =  CAR_TOOLBARVIEWTOPSPACE;
    }
    self.customizeTopView.hidden = NO;
}

//偏航的时候会走
- (void)onHandleSimpleGuideInfoHide:(BNaviSimpleGuideInfo*)simpleGuideInfo {
    [self.routeModelView hide];
}

-(void)dealloc {
    BNaviService_Strategy.bottomButtonHeight = 0;
    BNaviService_Strategy.toolBarViewTopSpace = 0;
    BNaviService_Strategy.naviLocationOffset = 0;
    
}

-(LightNaviRouteModelView *)routeModelView {
    if (!_routeModelView) {
        _routeModelView = [[LightNaviRouteModelView alloc] initWithFrame:CGRectMake(20, self.view.height, self.view.bounds.size.width - 40, self.view.bounds.size.height)];
        __weak typeof(self) weakSelf = self;
        _routeModelView.block = ^(BNRoutePlanMode type, NSString * _Nonnull typeName) {
            [weakSelf.routeModelViewBtn setTitle:typeName forState:UIControlStateNormal];
            weakSelf.planModel = type;
        };
        [self.view addSubview:_routeModelView];
    }
    
    return _routeModelView;
}
-(void)setPlanModel:(BNRoutePlanMode)planModel {
    _planModel = planModel;
    [self startRoutePlan];
}

#pragma mark - 禁止横屏
- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait;
}

- (UIInterfaceOrientation)preferredInterfaceOrientationForPresentation {
    return UIInterfaceOrientationPortrait;
}
@end
