//
//  LightNaviSelectLineViewController.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/5.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "LightNaviSelectLineViewController.h"
#import "BNRoutePlanModel.h"
#import "BNaviService.h"
#import "CommonDefine.h"
#import "LightRouteContentView.h"
#import "RadarSwitchView.h"
#import "RadarLocationView.h"
#import "BNLightRoutesModel.h"
#import "BNaviModel.h"
#define kPanelHeight        (ADAPTOR_VALUE_750(302) + SAFE_AREA_INSETS_BOTTOM) //底部面板显示区域高度
#define kPanelLessHeight    (ADAPTOR_VALUE_750(266) + SAFE_AREA_INSETS_BOTTOM)
#define kLeftOffset         (CR_MAP_VIEW_ENTRANCE_RIGHT_MARGIN+4+1)

@interface LightNaviSelectLineViewController () <BNaviModelDelegate, BNNaviRoutePlanDelegate, RadarLocationViewDelegate, BNNaviUIManagerDelegate, BMKMapViewDelegate, BNLightNaviManagerDelegate>

@property (nonatomic, assign) BNRoutePlanMode strategy;
@property (nonatomic, strong) LightRouteContentView *contentView;
@property (nonatomic, strong) RadarLocationView *radarLocationView;
@property (nonatomic, strong) UIView *logoView;
@property (nonatomic, assign) BOOL enterNavi;
@property (nonatomic, assign) BOOL naviEnd;

@end
@implementation LightNaviSelectLineViewController

- (void)dealloc {
//    [BNaviService_DriveRoute stopUpdateLocation];
    NSLog(@"LightNaviSelectLineViewController Dealloc");
}

- (NSString *)title {
    return @"多路线驾车页";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    
    self.strategy = BNRoutePlanMode_Recommend;

    [BNaviService_RoutePlan showMultiRoute:YES];
    
//    [BNaviService_Instance naviMapView].delegate = self;
    BNaviService_LightNavi.delegate = self;
    [self configureBackButton];
    [self resetUIFrame];
    
}
- (void)configureBackButton {
    UIBarButtonItem *returnButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"< 返回" style:UIBarButtonItemStylePlain target:self action:@selector(backButtonPressed:)];
    self.navigationItem.leftBarButtonItem = returnButtonItem;
}

- (void)backButtonPressed:(id)sender {
    [self backVc];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [BNaviService_LightNavi viewWillAppear:self.view];
    [self showRouteViewAll];
}

-(void)backVc {
    if (self.delegate && [self.delegate respondsToSelector:@selector(multiRouteBackButtonPressed:)]) {
        [self.delegate multiRouteBackButtonPressed:self.naviEnd];
    }
    [self.navigationController popViewControllerAnimated:YES];
    
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [BNaviService_LightNavi viewWillDisAppear:self.view];
}


#pragma mark - Public
- (void)carRouteDidSelectAtIndex:(NSInteger)index {
    if (index >= 0 && index < self.carRoute.carRoutes.count) {
        [self routeSelectIndex:index needSelectRoute:YES];
    }
}

- (void)enterNaviPage {
    if (!self.naviType) {
        self.naviType  = @"Truck";
    }
    BOOL ret = [BNaviService_LightNavi switchToRealNav:self withNaviType:self.naviType];
    if (ret) {
        self.enterNavi = YES;
        [[BNaviModel getInstance] addNaviModelListener:self];
    }
}



#pragma mark - Private
- (void)routeSelectIndex:(NSInteger)selectIndex needSelectRoute:(BOOL)needSelectRoute {
    self.selectIndex = selectIndex;
    [self.contentView.tabPanel selectIndex:(int)selectIndex];
}

- (CGFloat)bottomPaneHeight{
    if (self.carRoute.carRoutes.count == 1) {
        return kPanelLessHeight;
    } else {
        return kPanelHeight;
    }
}

- (void)resetUIFrame {
    self.contentView.frame = CGRectMake(0, IPHONE_SCREEN_HEIGHT-[self bottomPaneHeight], IPHONE_SCREEN_WIDTH, [self bottomPaneHeight]);
    self.radarLocationView.frame = CGRectMake(kLeftOffset, IPHONE_SCREEN_HEIGHT-[self bottomPaneHeight]-kRAButtonHeight-5, kRAButtonWidth, kRAButtonHeight);
    self.logoView.frame = CGRectMake(CGRectGetMaxX(self.radarLocationView.frame)+5, IPHONE_SCREEN_HEIGHT-[self bottomPaneHeight]-self.logoView.height-5, self.logoView.width, self.logoView.height);
}

- (void)showRouteViewAll {
    [BNaviService_LightNavi zoomToSpan:UIEdgeInsetsMake(40, 20, self.view.height-self.contentView.y, 20)];
}

- (void)hideUIControl {
    _contentView.hidden = YES;
}


#pragma mark - BNNaviRoutePlanDelegate

- (UIEdgeInsets)zoomToSpanInsets {
    return UIEdgeInsetsMake(20, 20, self.view.height-self.contentView.y, 20);
}

- (void)onHandleNaviStatusChange:(BNaviStatusInfo*)naviStatusInfo {
    if (!self.enterNavi) {
        if (naviStatusInfo.eNaviStatusType == BNaviStatus_Type_End2) {
            NSLog(@"轻导航中到达目的地");
            [self hideUIControl];
            self.naviEnd = YES;
        }
    } else {
        if (naviStatusInfo.eNaviStatusType == BNaviStatus_Type_End2) {
            NSLog(@"专业导航中到达目的地");
            self.naviEnd = YES;
        }
    }
    
}

#pragma mark - RadarLocationViewDelegate
- (void)radarLocation:(RadarLocationView *)locationView {
    [self showRouteViewAll];
}

#pragma mark - BNLightNaviManagerDelegate
/**
 用户在地图上点击了某条路线（如果需要高亮该路线，要调用selectRouteAtIndex:接口）
 
 @param routeDetailIndex 路线序号（从0开始）
 */
- (void)onHandleClickRoute:(NSInteger)routeDetailIndex {
    if (routeDetailIndex < self.carRoute.carRoutes.count) {
        [self routeSelectIndex:routeDetailIndex needSelectRoute:NO];
    }
    
}
- (void)onHandleRouteDetailChange:(BNLightRoutesModel *)model {
    self.contentView.tabPanel.routesModel = model;
    self.selectIndex = model.selectRouteIndex;
    [self.contentView.tabPanel selectIndex:(int)self.selectIndex];
    
    
}
/// 退出专业导航的回调
- (void)onHandleExitNavi:(NSDictionary *)dict {
    [self backVc];
}
//// 时刻返回导航信息
-(void)onHandleSimpleGuideInfo:(BNaviSimpleGuideInfo*)simpleGuideInfo {
    
    NSLog(@"onHandleSimpleGuideInfo:---%@", simpleGuideInfo);
    
}
///偏航后准备重新规划路线前的通知回调。
-(void)onHandleDrivingRouteChange:(BNCarRouteModel *)carRouteModel {
    
    NSLog(@"onHandleDrivingRouteChange:---%@", carRouteModel);

        self.carRoute = carRouteModel;
        [self resetUIFrame];
}

//偏航的时候会走
- (void)onHandleSimpleGuideInfoHide:(BNaviSimpleGuideInfo*)simpleGuideInfo {
    
    NSLog(@"onHandleSimpleGuideInfoHide:---%@", simpleGuideInfo);
    
    
}



#pragma mark - Lazy loading
- (LightRouteContentView *)contentView {
    if (!_contentView) {
        _contentView = [[LightRouteContentView alloc] initWithFrame:CGRectMake(0, IPHONE_SCREEN_HEIGHT-[self bottomPaneHeight], IPHONE_SCREEN_WIDTH, [self bottomPaneHeight])];
        _contentView.lightNaviVc = self;
        __weak typeof(self) weakSelf = self;
        _contentView.tabPanel.block = ^(BNLightOneRouteModel *oneRouteModel, int index) {
            weakSelf.selectIndex = index;
            [BNaviService_LightNavi selectRouteWithRouteDetailIndex:index];
        };
        [self.view addSubview:_contentView];
    }
    return _contentView;
}


- (RadarLocationView *)radarLocationView {
    if (!_radarLocationView) {
        _radarLocationView = [[RadarLocationView alloc] initWithFrame:CGRectMake(kLeftOffset, IPHONE_SCREEN_HEIGHT-[self bottomPaneHeight]-kRAButtonHeight-5, kRAButtonWidth, kRAButtonHeight)];
        _radarLocationView.delegate = self;
        [self.view insertSubview:_radarLocationView belowSubview:self.contentView];
    }
    return _radarLocationView;
}

#pragma mark - 禁止横屏
- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait;
}

- (UIInterfaceOrientation)preferredInterfaceOrientationForPresentation {
    return UIInterfaceOrientationPortrait;
}

@end
