//
//  LightNaviSelectLineViewController.h
//  NaviDemo
//
//  Created by v_qinruiguang on 2021/5/24.
//  Copyright © 2021 v_qinruiguang. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "CommonDefine.h"
#import "BNCarRouteData.h"

NS_ASSUME_NONNULL_BEGIN

@protocol LightNaviSelectLineViewControllerDelegate <NSObject>

//导航是否结束（专业导航 or 轻导航）
- (void)multiRouteBackButtonPressed:(BOOL)naviEnd;

@end


@interface LightNaviSelectLineViewController : UIViewController

@property (weak, nonatomic) id <LightNaviSelectLineViewControllerDelegate> delegate;

@property (nonatomic, copy) NSString *naviType;
@property (nonatomic, strong) NSArray *nodes;
@property (nonatomic, assign) NSInteger selectIndex;
@property (nonatomic, strong) BNCarRouteModel *carRoute;

- (void)carRouteDidSelectAtIndex:(NSInteger)index;
- (void)enterNaviPage;
- (void)retryRoutePlan;
@end

NS_ASSUME_NONNULL_END
