//
//  InitializeViewContoller.m
//  NaviDemo
//
//  Created by v_lisisi on 2025/5/20.
//  Copyright © 2025 v_qinruiguang. All rights reserved.
//

#import "InitializeViewContoller.h"
#import "BNaviService.h"
#import "MainViewController.h"
#import <BaiduMapAPI_Base/BMKBaseComponent.h>
#import "LocationManager.h"
#import "BNUtility.h"
#import "BNCommonDef.h"
#import "IndoorLocationManager.h"
//导航开放平台注册
#define BNAVI_APP_KEY       @"cMEqDYQScfg60t46ufAMfu0wUzHdFFN3"
//语音开放平台注册
#define TTS_APP_ID          @"10881846"
#define TTS_API_KEY         @"cMEqDYQScfg60t46ufAMfu0wUzHdFFN3"
#define TTS_SECRET_KEY      @"aaxDmiQ7V98DowELgPCXwv1EU31E3ifS"
@interface InitializeViewContoller ()<CLLocationManagerDelegate>

@property (strong, nonatomic) MainViewController *mainViewController;
@property (strong, nonatomic) UINavigationController *naviViewController;
@property (strong, nonatomic) BMKMapManager *mapManager;
@property (strong, nonatomic) CLLocationManager *locationManager;

@property (nonatomic, strong) UIButton *navInitButton;
@property (nonatomic, strong) UIButton *startLocationButton;
@property (nonatomic, strong) UIButton *enterNaviDemoButton;

@property (nonatomic, assign) BOOL hasAgreedPrivacy; // 是否同意了隐私协议

@end

@implementation InitializeViewContoller

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    // 初始化按钮并添加到页面
    [self setupButtons];
    
}

- (void)setupButtons {
    self.navInitButton = [UIButton buttonWithType:UIButtonTypeSystem];
    [self.navInitButton setTitle:@"初始化导航" forState:UIControlStateNormal];
    [self.navInitButton addTarget:self action:@selector(handleInitNav) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.navInitButton];

    self.startLocationButton = [UIButton buttonWithType:UIButtonTypeSystem];
    [self.startLocationButton setTitle:@"开启定位" forState:UIControlStateNormal];
    [self.startLocationButton addTarget:self action:@selector(handleStartLocation) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.startLocationButton];

    self.enterNaviDemoButton = [UIButton buttonWithType:UIButtonTypeSystem];
    [self.enterNaviDemoButton setTitle:@"进入 Navi Demo" forState:UIControlStateNormal];
    [self.enterNaviDemoButton addTarget:self action:@selector(handleEnterNaviDemo) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.enterNaviDemoButton];

    // 禁用 AutoresizingMask 转约束
    self.navInitButton.translatesAutoresizingMaskIntoConstraints = NO;
    self.startLocationButton.translatesAutoresizingMaskIntoConstraints = NO;
    self.enterNaviDemoButton.translatesAutoresizingMaskIntoConstraints = NO;

    // 水平方向居中
    [NSLayoutConstraint activateConstraints:@[
        [self.navInitButton.centerXAnchor constraintEqualToAnchor:self.view.centerXAnchor],
        [self.startLocationButton.centerXAnchor constraintEqualToAnchor:self.view.centerXAnchor],
        [self.enterNaviDemoButton.centerXAnchor constraintEqualToAnchor:self.view.centerXAnchor],
    ]];

    // 垂直方向从上到下排列，居中对齐
    [NSLayoutConstraint activateConstraints:@[
        [self.startLocationButton.topAnchor constraintEqualToAnchor:self.navInitButton.bottomAnchor constant:20],
        [self.enterNaviDemoButton.topAnchor constraintEqualToAnchor:self.startLocationButton.bottomAnchor constant:20],
        [self.navInitButton.centerYAnchor constraintEqualToAnchor:self.view.centerYAnchor constant:-40]
    ]];
}


- (void)handleEnterNaviDemo {
    if (!self.hasAgreedPrivacy) {
        __weak typeof(self) ws = self;
        UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"提示"
                                                                       message:@"请先初始化导航并同意隐私协议"
                                                                preferredStyle:UIAlertControllerStyleAlert];
        
        UIAlertAction *ok = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleCancel handler:nil];
        [alert addAction:ok];
        
        [ws presentViewController:alert animated:YES completion:nil];
        return;
    }
    
    [self enterNaviDemo];
}

- (void)handleInitNav {
    __weak typeof(self) ws = self;
    if (self.hasAgreedPrivacy) {
        // 弹出提示框说明限制
        UIAlertController *notice = [UIAlertController alertControllerWithTitle:@"提示"
                                                                        message:@"导航已初始化成功可以进入Navi Demo"
                                                                 preferredStyle:UIAlertControllerStyleAlert];
        UIAlertAction *ok = [UIAlertAction actionWithTitle:@"确认" style:UIAlertActionStyleDefault handler:nil];
        [notice addAction:ok];
        [ws presentViewController:notice animated:YES completion:nil];
        return;
    }
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"隐私协议"
                                                                   message:@"欢迎您使用百度地图开放平台产品和服务,为响应工信部针对进一步加强用户隐私安全保障措施的号召，以便更好地为广大用户提供更合规、更安全、更稳定的服务体验，平台全面更新了《百度地图开放平台产品和服务隐私政策》,请认真阅读并同意隐私服务政策。"
                                                            preferredStyle:UIAlertControllerStyleAlert];
    
    UIAlertAction *agreeAction = [UIAlertAction actionWithTitle:@"同意" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        NSLog(@"用户已同意隐私协议，可以继续初始化导航");
        [ws initializeNavigation]; // 初始化导航逻辑
    }];
    
    UIAlertAction *declineAction = [UIAlertAction actionWithTitle:@"不同意" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        ws.hasAgreedPrivacy = NO;
        NSLog(@"用户未同意隐私协议");
        // 弹出提示框说明限制
        UIAlertController *notice = [UIAlertController alertControllerWithTitle:@"提示"
                                                                        message:@"您不同意隐私协议，将无法使用导航算路和导航功能。"
                                                                 preferredStyle:UIAlertControllerStyleAlert];
        UIAlertAction *ok = [UIAlertAction actionWithTitle:@"知道了" style:UIAlertActionStyleDefault handler:nil];
        [notice addAction:ok];
        [ws presentViewController:notice animated:YES completion:nil];
    }];
    
    [alert addAction:agreeAction];
    [alert addAction:declineAction];
    
    [self presentViewController:alert animated:YES completion:nil];
}

- (void)handleStartLocation {
    NSLog(@"开启定位逻辑");
    // 写你的位置服务授权和启动代码
    [self requestAlwaysAuthorization];
}

- (void) initializeNavigation {
    [self initMapSDK];
    [self initNaviSDK];
    [self authorizeLicense];
}

- (void)initMapSDK {
    // 地图SDK隐私权限授权
    [BMKMapManager setAgreePrivacy:YES];
    BMKMapManager *mapManager = [[BMKMapManager alloc] init];
    self.mapManager = mapManager;
    // 如果要关注网络及授权验证事件，请设定generalDelegate参数
    BOOL ret = [self.mapManager start:BNAVI_APP_KEY  generalDelegate:nil];
    if (!ret) {
        NSLog(@"启动引擎失败");
    }
    [IndoorLocationManager locationAuth:BNAVI_APP_KEY];
}
- (void)initNaviSDK {
    [BNaviService setAgreePrivacy:YES];
    __weak typeof(self) ws = self;
    [BNaviService_Instance initNaviService:nil success:^{
        NSLog(@"sdkVersion %@", [BNaviService  sdkVersion]);
        ws.hasAgreedPrivacy = YES;
        [BNaviService_Instance authorizeNaviAppKey:BNAVI_APP_KEY
                                        completion:^(BOOL suc) {
                                            NSLog(@"authorizeNaviAppKey ret = %d", suc);
                                        }];
        [BNaviService_Instance authorizeTTSAppId:TTS_APP_ID
                                          apiKey:TTS_API_KEY
                                       secretKey:TTS_SECRET_KEY
                                      completion:^(BOOL suc) {
                                          NSLog(@"authorizeTTS ret = %d", suc);
                                      }];
        [ws requestAlwaysAuthorization];
    } fail:^{
        NSLog(@"initNaviSDK fail");
    }];
}

- (void)requestAlwaysAuthorization {
    if (!self.hasAgreedPrivacy) {
        __weak typeof(self) ws = self;
        UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"提示"
                                                                       message:@"请先初始化导航并同意隐私协议"
                                                                preferredStyle:UIAlertControllerStyleAlert];
        
        UIAlertAction *ok = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleCancel handler:nil];
        [alert addAction:ok];
        
        [ws presentViewController:alert animated:YES completion:nil];
        return;
    }
    self.locationManager = [[CLLocationManager alloc] init];
    self.locationManager.delegate = self;
    [self.locationManager requestAlwaysAuthorization];
}

- (void)authorizeLicense {
    
    [BNaviService_Instance authorizeLicenseNaviAK:BNAVI_APP_KEY deviceID:@"device_id" completion:^(NSError *requestError) {
        
    }];
}

- (void)locationManager:(CLLocationManager *)manager didChangeAuthorizationStatus:(CLAuthorizationStatus)status API_DEPRECATED_WITH_REPLACEMENT("-locationManagerDidChangeAuthorization:", ios(4.2, 14.0), macos(10.7, 11.0), watchos(1.0, 7.0), tvos(9.0, 14.0)) {
    if (status == kCLAuthorizationStatusAuthorizedWhenInUse || status == kCLAuthorizationStatusAuthorizedAlways) {
        [BNaviService_Location setAlwaysUpdatingLocation:YES];
    }
}


- (void)locationManagerDidChangeAuthorization:(CLLocationManager *)manager API_AVAILABLE(ios(14.0), macos(11.0), watchos(7.0), tvos(14.0)) {
    CLAuthorizationStatus status = [manager authorizationStatus];
    if (status == kCLAuthorizationStatusAuthorizedWhenInUse || status == kCLAuthorizationStatusAuthorizedAlways) {
        [BNaviService_Location setAlwaysUpdatingLocation:YES];
    }
}

- (void)enterNaviDemo {
    self.mainViewController = [[MainViewController alloc] initWithStyle:UITableViewStyleGrouped];
    self.naviViewController = [[UINavigationController alloc] initWithRootViewController:self.mainViewController];
    [UIApplication sharedApplication].keyWindow.rootViewController = self.naviViewController;
    [[UIApplication sharedApplication].keyWindow makeKeyAndVisible];
}

@end
