//
//  RouteContentView.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/14.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "RouteContentView.h"
#import "DrivePageViewController.h"

#define BarHeight (44+SAFE_AREA_INSETS_TOP)

@interface RouteContentView () <CarThreeTabPanelDelegate>
{
    CGRect _originFrame;
    CGPoint _beganPoint;
    CGPoint _oriContentOffset;
    BOOL _isUpOrDown;
    BOOL _isFull;
    BOOL _panGesInTabPanel;
}

@end

@implementation RouteContentView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        _isSlide = YES;
        _panGesInTabPanel = YES;
        _isFull = NO;
        _originFrame = frame;
        self.backgroundColor = [UIColor clearColor];
        [self addPanGesture];
    }
    return self;
}

- (void)reset {
    _panGesInTabPanel = YES;
    _isFull = NO;
    _originFrame = self.frame;
    
    // 这里需要重置frame，因为总路线数变化时高度会改变
    self.tabPanel.frame = CGRectMake(0, 0, IPHONE_SCREEN_WIDTH, self.height);
    self.carDetailContentView.frame = CGRectMake(0, self.height-SAFE_AREA_INSETS_BOTTOM, IPHONE_SCREEN_WIDTH, IPHONE_SCREEN_HEIGHT - self.height - BarHeight);
    [self showFullState:NO];
    if ([self.drivePageVc isKindOfClass:[DrivePageViewController class]]){
        if (self.drivePageVc.isTripType) {
            [self.tabPanel hiddenNaviBtn:self.drivePageVc.isTripType];
        }
    }
}

#pragma mark - PanGesture
- (void)addPanGesture {
    UIPanGestureRecognizer *ges = [[UIPanGestureRecognizer alloc] initWithTarget:self action:@selector(panGes:)];
    [self addGestureRecognizer:ges];
    self.userInteractionEnabled = YES;
}

- (void)panGes:(UIPanGestureRecognizer *)ges {
    if (!self.isSlide) {
        return;
    }
    
    if (!self.drivePageVc.carRoute || !self.drivePageVc.carRoute.carRoutes.count) {
        return;
    }
    
    UIGestureRecognizerState state = ges.state;
    
    CGPoint point = [ges locationInView:ges.view.superview];
    
    if (state == UIGestureRecognizerStateBegan) {
        CGRect rect = [self.superview convertRect:self.tabPanel.frame fromView:self];
        
        _panGesInTabPanel = CGRectContainsPoint(rect, point) || (point.y < rect.origin.y);
        _beganPoint = point;
        _isUpOrDown = NO;
        _oriContentOffset = self.carDetailContentView.detailView.contentOffset;
    } else {
        if (_panGesInTabPanel) {
            if (state == UIGestureRecognizerStateChanged) {
                if (!_isFull) { // 不是全览，即初始底部状态
                    if (_beganPoint.y - point.y > 5) {
                        _isUpOrDown = YES;
                        [self showFullState:YES];
                    }
                    
                    if (_isUpOrDown) {
                        CGFloat offset = _beganPoint.y - point.y;
                        if (offset < 0) {
                            offset = 0;
                        }
                        
                        if (offset > self.superview.height - _originFrame.size.height - BarHeight) {
                            offset = self.superview.height - _originFrame.size.height - BarHeight;
                        }
                        
                        CGRect rect = _originFrame;
                        rect.origin.y = _originFrame.origin.y - offset;
                        rect.size.height = _originFrame.size.height + offset;
                        self.frame = rect;
                    }
                } else { // 全览状态
                    if (point.y - _beganPoint.y > 5) {
                        _isUpOrDown = YES;
                    }
                    
                    if (_isUpOrDown) {
                        CGFloat offset = point.y - _beganPoint.y;
                        if (offset < 0) {
                            offset = 0;
                        }
                        
                        if (offset > self.superview.height - _originFrame.size.height - BarHeight) {
                            offset = self.superview.height - _originFrame.size.height - BarHeight;
                        }
                        
                        CGRect rect = _originFrame;
                        rect.origin.y = offset + BarHeight;
                        rect.size.height = self.superview.height - BarHeight - offset;
                        self.frame = rect;
                    }
                }
            } else if (state == UIGestureRecognizerStateEnded) {
                if (!_isFull) {
                    CGFloat offset = _beganPoint.y - point.y;
                    if (offset > 5) { // 全览
                        CGFloat maxOffset = self.superview.height - _originFrame.size.height - BarHeight;
                        CGRect rect = _originFrame;
                        rect.origin.y = _originFrame.origin.y - maxOffset;
                        rect.size.height = _originFrame.size.height + maxOffset;
                        [UIView animateWithDuration:0.25 animations:^{
                            self.frame = rect;
                        } completion:^(BOOL finished) {
                            _isFull = YES;
                        }];
                    } else { // 还原到底部初始状态
                        self.frame = _originFrame;
                        [self showFullState:NO];
                    }
                } else {
                    CGFloat offset = point.y - _beganPoint.y;
                    if (offset > 5) { // 恢复到初始底部状态
                        [UIView animateWithDuration:0.25 animations:^{
                            self.frame = _originFrame;
                        } completion:^(BOOL finished) {
                            _isFull = NO;
                            [self showFullState:NO];
                        }];
                    } else { // 还原到全览
                        CGFloat maxOffset = self.superview.height - _originFrame.size.height - BarHeight;
                        CGRect rect = _originFrame;
                        rect.origin.y = _originFrame.origin.y - maxOffset;
                        rect.size.height = _originFrame.size.height + maxOffset;
                        self.frame = rect;
                    }
                }
            }
        } else {
            CGFloat offset = _beganPoint.y - point.y;
            CGFloat maxOffset = MAX(self.carDetailContentView.detailView.contentSize.height - self.carDetailContentView.detailView.height, 0) ;
            CGFloat offsetY = _oriContentOffset.y + offset;
            
            if (state == UIGestureRecognizerStateChanged) {
                if (offsetY < 0) {
                    CGFloat offset = -offsetY;
                    if (offset < 0) {
                        offset = 0;
                    }
                    
                    if (offset > self.superview.height - _originFrame.size.height - BarHeight) {
                        offset = self.superview.height - _originFrame.size.height - BarHeight;
                    }
                    
                    CGRect rect = _originFrame;
                    rect.origin.y = offset + BarHeight;
                    rect.size.height = self.superview.height - BarHeight - offset;
                    self.frame = rect;
                } else {
                    if (self.y > BarHeight) {
                        CGFloat maxOffset = self.superview.height - _originFrame.size.height - BarHeight;
                        CGRect rect = _originFrame;
                        rect.origin.y = _originFrame.origin.y - maxOffset;
                        rect.size.height = _originFrame.size.height + maxOffset;
                        self.frame = rect;
                    }
                    
                    if (offsetY > maxOffset) {
                        offsetY = maxOffset;
                    }
                    
                    self.carDetailContentView.detailView.contentOffset = CGPointMake(0, offsetY);
                }
            } else if (state == UIGestureRecognizerStateEnded) {
                if (offsetY < 0) {
                    CGFloat offset = -offsetY;
                    if (offset > 5) {
                        [UIView animateWithDuration:0.25 animations:^{
                            self.frame = _originFrame;
                        } completion:^(BOOL finished) {
                            _isFull = NO;
                            [self showFullState:NO];
                        }];
                    } else {
                        CGFloat maxOffset = self.superview.height - _originFrame.size.height - BarHeight;
                        CGRect rect = _originFrame;
                        rect.origin.y = _originFrame.origin.y - maxOffset;
                        rect.size.height = _originFrame.size.height + maxOffset;
                        self.frame = rect;
                    }
                }
            }
        }
    }
}

#pragma mark - Private
- (NSString *)calcCapDefaultPlanPreferName:(NSInteger)index {
    NSString *capText = nil;
    if (0 <= index && index < self.drivePageVc.carRoute.carRoutes.count) {
        BNCarOneRouteModel *oneRoute = [self.drivePageVc.carRoute.carRoutes objectAtIndex:index];
        if (oneRoute.routeLabelName.length > 0) {
            capText = oneRoute.routeLabelName;
        } else {
            if(self.drivePageVc.carRoute.carRoutes.count > 1) {
                switch (index) {
                    case 0: {
                        capText = @"方案一";
                    }
                        break;
                    case 1: {
                        capText = @"方案二";
                    }
                        break;
                    case 2: {
                        capText = @"方案三";
                    }
                        break;
                    default:
                        break;
                }
            }
        }
    }
    return capText;
}

- (void)showFullState:(BOOL)isFull {
    if (isFull) {
        self.carDetailContentView.hidden = NO;
        self.backgroundColor = [UIColor whiteColor];
    } else {
        self.carDetailContentView.hidden = YES;
        self.backgroundColor = [UIColor clearColor];
    }
    
    [self.tabPanel showFullState:isFull];
}

#pragma mark - CarThreeTabPanelDelegate
- (BNCarRouteModel *)carRouteDataForThreeTabPanel:(CarThreeTabPanel *)panel {
    return self.drivePageVc.carRoute;
}

- (NSString *)capTextForThreeTabPanel:(CarThreeTabPanel *)panel atIndex:(NSInteger)index {
    return [self calcCapDefaultPlanPreferName:index];
}

- (NSUInteger)selectedIndexForTabPanel:(CarThreeTabPanel *)panel {
    return self.drivePageVc.selectIndex;
}

- (void)threeTabPanel:(CarThreeTabPanel *)panel didSelectAtIndex:(NSInteger)index {
    [self.drivePageVc carRouteDidSelectAtIndex:index];
}

- (void)threeTabPanel:(CarThreeTabPanel *)panel didClickButtonType:(TabButtonType)type {
    switch (type) {
        case TabButtonTypeNavi: {
            [self.drivePageVc enterNaviPage];
        }
            break;
        default:
            break;
    }
}

- (void)didRetryClicked {
    [self.drivePageVc retryRoutePlan];
}

#pragma mark - Lazy loading
- (CarThreeTabPanel *)tabPanel {
    if (!_tabPanel) {
        _tabPanel = [[CarThreeTabPanel alloc] initWithFrame:CGRectMake(0, 0, IPHONE_SCREEN_WIDTH, self.height)];
        _tabPanel.backgroundColor = [UIColor clearColor];
        _tabPanel.delegate = self;
        [self addSubview:_tabPanel];
    }
    return _tabPanel;
}

- (CarDetailContentView *)carDetailContentView {
    if (!_carDetailContentView) {
        _carDetailContentView = [[CarDetailContentView alloc] initWithFrame:CGRectMake(0, self.height-SAFE_AREA_INSETS_BOTTOM, IPHONE_SCREEN_WIDTH, IPHONE_SCREEN_HEIGHT - self.height - BarHeight)];
        _carDetailContentView.backgroundColor = [UIColor clearColor];
        _carDetailContentView.hidden = YES;
        [self addSubview:_carDetailContentView];
    }
    return _carDetailContentView;
}

@end

