//
//  CarThreeTabPanel.h
//  NaviDemo
//
//  Created by linbiao on 2019/5/9.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "BNCarRouteData.h"
#import "CommonDefine.h"

typedef NS_ENUM(NSInteger, TabButtonType) {
    TabButtonTypeUndefine,      // Undefine
    TabButtonTypeNavi,          // 开始导航
};

@protocol CarThreeTabPanelDelegate;

@interface CarThreeTabPanel : UIControl

@property (nonatomic, weak) id<CarThreeTabPanelDelegate> delegate;
- (void)hiddenNaviBtn:(BOOL)hid;
- (CGRect)getNaviBtnFrame;
- (void)reloadData;
- (void)selectAtIndex:(NSInteger)index;
- (void)hideLine:(BOOL)hidden;
- (void)updateArriveTimeAndJamDist;
- (BOOL)isBottomBarVisiable;
- (void)remove3TabUI;
- (void)showFullState:(BOOL)isFull;

- (void)pageInit;
- (void)pageLoading;
- (void)pageLoadedWillSuccess:(id)carRoute;
- (void)pageLoadedSuccess:(id)result;
- (void)pageLoadedFailed:(NSError *)error;

@end

@protocol CarThreeTabPanelDelegate <NSObject>

@required
- (BNCarRouteModel *)carRouteDataForThreeTabPanel:(CarThreeTabPanel *)panel;
- (NSString *)capTextForThreeTabPanel:(CarThreeTabPanel *)panel atIndex:(NSInteger)index;
- (NSUInteger)selectedIndexForTabPanel:(CarThreeTabPanel *)panel;

@optional
- (void)threeTabPanel:(CarThreeTabPanel *)panel didSelectAtIndex:(NSInteger)index;
- (void)threeTabPanel:(CarThreeTabPanel *)panel didClickButtonType:(TabButtonType)type;
- (void)threeTabPanelDidClicked:(CarThreeTabPanel *)panel;

- (void)didRetryClicked;

- (BOOL)pageStateIsWillSuccess;
- (void)setPageStateWillSuccessBottomButtonClick:(dispatch_block_t)block;
- (void)setPageStateWillSuccessRouteTabClick:(dispatch_block_t)block;

- (BOOL)isLongjounery;

- (BOOL)showNaviBtn;

@end
