//
//  AddNodeViewController.m
//  NaviDemo
//
//  Created by v_lisisi on 2023/6/16.
//  Copyright © 2023 v_qinruiguang. All rights reserved.
//

#import "AddNodeViewController.h"
#import <UIKit/UIKit.h>
#import <CoreLocation/CoreLocation.h>
#import "BNRoutePlanModel.h"
#import "BNaviService.h"

#import "SelectNodesViewController.h"
#import "MapViewDemoViewController.h"

@interface CustomView ()<UITextFieldDelegate>

@end

@implementation CustomView

- (void)setTitleArray:(NSArray *)titleArray {
    _titleArray = titleArray;
    
    for (int i = 0; i < self.titleArray.count; i++) {
        CGFloat viewHeight = 50;
        CGFloat padding = 10;
        CGFloat viewY =  (viewHeight + padding) * i;
        
        // 创建左边标题
        UILabel *leftTitleLabel = [[UILabel alloc] initWithFrame:CGRectMake(20, viewY, 100, viewHeight)];
        leftTitleLabel.text = self.titleArray[i];
        leftTitleLabel.font = [UIFont systemFontOfSize:16];
        [self addSubview:leftTitleLabel];
        
        // 创建右侧文本输入框
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(CGRectGetMaxX(leftTitleLabel.frame) + 10, viewY, CGRectGetWidth(self.frame) - 150, viewHeight)];
        textField.borderStyle = UITextBorderStyleRoundedRect;
        textField.placeholder = [NSString stringWithFormat:@"请输入%@", self.titleArray[i]];
        textField.font = [UIFont systemFontOfSize:16];
        textField.tag = 100 + i;
        textField.delegate = self;
        [self addSubview:textField];
    }
    
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    [self.dataArray removeAllObjects];
    self.dataArray = [NSMutableArray array];
    for (int i = 0; i < self.titleArray.count; i++) {
        // 设置每个文本字段的标签，假设标签从1001开始递增
        NSInteger tag = 100 + i;
        // 通过标签获取文本字段
        UITextField *textField = [self viewWithTag:tag];
        // 检查文本字段是否存在
        if (textField != nil && [textField isKindOfClass:[UITextField class]]) {
            if (textField.text.length == 0) {
                [self.dataArray addObject:@""];
            } else {
                [self.dataArray addObject:textField.text];
            }
        } else {
            NSLog(@"未找到标签为%d的文本字段", (int)tag);
        }
    }
    if (self.blcok) {
        self.blcok();
    }
}
- (void)textFieldDidBeginEditing:(UITextField *)textField {
    // 在这里处理键盘弹出事件，你可以根据当前正在编辑的 textField 做相应的处理
    NSLog(@"当前点击了 %@", textField.placeholder);
    if (self.textFieldBlock) {
        self.textFieldBlock(textField);
    }
}
// 实现UITextFieldDelegate代理方法
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    // 关闭键盘
    [textField resignFirstResponder];
    return YES;
}
@end

@interface AddNodeViewController ()

@property (nonatomic, copy) NSString *startX;
@property (nonatomic, copy) NSString *startY;
@property (nonatomic, copy) NSString *startFloodId;
@property (nonatomic, copy) NSString *startUid;
@property (nonatomic, copy) NSString *startBid;
@property (nonatomic, copy) NSString *endTitile;
@property (nonatomic, copy) NSString *endX;
@property (nonatomic, copy) NSString *endY;
@property (nonatomic, copy) NSString *endUid;

@property (nonatomic, strong) CustomView *startCustomView;
@property (nonatomic, strong) CustomView *endCustomView;
@property (nonatomic, assign) BOOL isEndView;
@end

@implementation AddNodeViewController

- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}
- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    [BNaviService_Location startUpdate];
    [self addView];
    [self cunstomViewBlock];
    // 注册键盘通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWillShow:) name:UIKeyboardWillShowNotification object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWillHide:) name:UIKeyboardWillHideNotification object:nil];
}

- (void)addView {
    NSArray *startArr = @[@"起点x", @"起点y", @"起点floodld", @"bid", @"uid"];
    CustomView *startCustomView = [[CustomView alloc] initWithFrame:CGRectMake(0, 0, CGRectGetWidth(self.view.frame), startArr.count*60)];
    startCustomView.titleArray = startArr;
    self.startCustomView = startCustomView;
    [self.view addSubview:startCustomView];
    
    // 创建自定义视图
    NSArray *endArr = @[@"终点x", @"终点y", @"uid"];
    CustomView *endCustomView = [[CustomView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(self.startCustomView.frame), CGRectGetWidth(self.view.frame), endArr.count * 60)];
    endCustomView.titleArray = endArr;
    endCustomView.isEndNodeView = YES;
    [self.view addSubview:endCustomView];
    self.endCustomView = endCustomView;
    
     UIBarButtonItem *saveButton = [[UIBarButtonItem alloc] initWithTitle:@"开始算路" style:UIBarButtonItemStylePlain target:self action:@selector(saveButtonTapped)];
     self.navigationItem.rightBarButtonItem = saveButton;
}

- (void)cunstomViewBlock {
    __weak typeof(self) ws = self;
    self.startCustomView.blcok = ^{
        for (int i = 0; i<ws.startCustomView.dataArray.count; i++) {
            NSString *str = ws.startCustomView.dataArray[i];
            if (i==0) {
                ws.startX = str;
            } else if (i == 1) {
                ws.startY = str;
            } else if (i == 2) {
                ws.startFloodId = str;
            } else if (i == 3) {
                ws.startBid = str;
            } else if (i == 4) {
                ws.startUid = str;
            }
        }
    };
    
    self.startCustomView.textFieldBlock = ^(UITextField *textField) {
        ws.isEndView = NO;
    };
    
    self.endCustomView.blcok = ^{
        for (int i = 0; i<ws.endCustomView.dataArray.count; i++) {
            NSString *str = ws.endCustomView.dataArray[i];
            if (i==0) {
                ws.endX = str;
            } else if (i == 1) {
                ws.endY = str;
            } else if (i == 2) {
                ws.endUid = str;
            }
        }
    };
    self.endCustomView.textFieldBlock = ^(UITextField *textField) {
        ws.isEndView = YES;
    };
}
- (void)keyboardWillShow:(NSNotification *)notification {
    NSDictionary *userInfo = notification.userInfo;
    CGRect keyboardFrame = [userInfo[UIKeyboardFrameEndUserInfoKey] CGRectValue];
    CGFloat keyboardHeight = keyboardFrame.size.height;
    CGFloat offsetY = keyboardHeight/2; // 如果需要保留键盘的高度空间
    if (!self.isEndView) {
        offsetY = 0;
    }
    self.view.frame = CGRectMake(self.view.frame.origin.x, self.view.frame.origin.y - offsetY, self.view.frame.size.width, self.view.frame.size.height);
}

- (void)keyboardWillHide:(NSNotification *)notification {
    // 在键盘收起时恢复视图的原始布局
    self.view.frame = CGRectMake(0, 0, self.view.frame.size.width, self.view.frame.size.height);
}

- (void)saveButtonTapped {
    
    CLLocation *myLocation = [BNaviService_Location getLastLocation];
    NodeModel *startModel = [NodeModel createSelectNodeModel:@"" x: [self.startX floatValue] y: [self.startY floatValue] eType:BNCoordinate_BaiduMapSDK uid:self.startUid];
    if (self.startY.length == 0 || self.startX.length == 0) {
        startModel = [NodeModel createSelectNodeModel:@"我的位置" x:myLocation.coordinate.longitude y:myLocation.coordinate.latitude eType:BNCoordinate_OriginalGPS];
    }
    
    NodeModel *endModel = [NodeModel createSelectNodeModel:@"" x:[self.endX floatValue] y:[self.endY floatValue] eType: BNCoordinate_BaiduMapSDK uid:self.endUid];
    
    startModel.node.floorID = self.startFloodId;
    startModel.node.buildingID = self.startBid;
     
    
    NSMutableArray *nodes = [NSMutableArray array];
    [nodes addObject:startModel.node];
    [nodes addObject:endModel.node];
     
    MapViewDemoViewController *drivePageVc = [[MapViewDemoViewController alloc] init];
    drivePageVc = [[NSClassFromString(self.vcStr) alloc] init];
    drivePageVc.nodes = nodes;
    
    [self.navigationController pushViewController:drivePageVc animated:YES];
}

@end
