//
//  ViewController.m
//  NaviDemo
//
//  Created by Baidu on 14/12/18.
//  Copyright (c) 2014年 Baidu. All rights reserved.
//
#import "PhoneGPSViewController.h"
#import "BNRoutePlanModel.h"
#import "BNaviService.h"
#import "BNaviModel.h"
#import "BNUtility.h"
#import "CustomBottomBar.h"


@interface PhoneGPSViewController ()<BNaviModelDelegate, BNNaviUIManagerDelegate,BNNaviRoutePlanDelegate, BMKMapViewDelegate>
@property(nonatomic, assign)NSInteger beforDist; //超速前 距离 当前
@property(nonatomic, assign)NSInteger lastDist; //超速前 距离 上一次
@property(nonatomic, assign) CGFloat section0Height;
@property(nonatomic, strong)CustomBottomBar *bottomView;

@end


@implementation PhoneGPSViewController

- (void)dealloc {
    NSLog(@"PhoneGPSViewController Dealloc");
}

- (UIButton*)createButton:(NSString*)title target:(SEL)selector frame:(CGRect)frame
{
    UIButton* button = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    button.frame = frame;
    [button setTitle:title forState:UIControlStateNormal];
    [button setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7) {
        [button setBackgroundColor:[UIColor whiteColor]];
    }else
    {
        [button setBackgroundColor:[UIColor clearColor]];
    }
    [button addTarget:self action:selector forControlEvents:UIControlEventTouchUpInside];
    return button;
}

- (void)setCarPlateInfo {
    //设置车牌号码
    [BNaviService_Strategy syncCarNumber:@"粤B86544"];
}

- (void)setMotorPlateInfo {
    BNMotorInfoModel *model = [[BNMotorInfoModel alloc] init];
    model.displacement = 5343;
    model.plate = @"粤BH3843";
    model.plateType = BNMotorPlateType_Yellow;
    model.powerType = BNMotorPowerType_Oil;
    [BNaviService_Strategy syncMotorInfoModel:model];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    [BNaviService_MapOverlay setDIYImageHidden:NO imageType:BN_DIYImage_StartPoint];
    [BNaviService_MapOverlay setDIYImageHidden:NO imageType:BN_DIYImage_EndPoint];

    self.view.backgroundColor = [UIColor grayColor];
    self.title = @"手机GPS导航";
    BNaviService_Strategy.yawSpecifiedRouteNavigation = 1;
    UILabel* startNodeLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 130, self.view.frame.size.width, 30)];
    startNodeLabel.backgroundColor = [UIColor clearColor];
    startNodeLabel.text = @"起点：百度国际大厦";
    startNodeLabel.textAlignment = NSTextAlignmentCenter;
    startNodeLabel.autoresizingMask = UIViewAutoresizingFlexibleWidth;
    [self.view addSubview:startNodeLabel];
    
    
    UILabel* endNodeLabel = [[UILabel alloc] initWithFrame:CGRectMake(startNodeLabel.frame.origin.x, startNodeLabel.frame.origin.y+startNodeLabel.frame.size.height, self.view.frame.size.width, startNodeLabel.frame.size.height)];
    endNodeLabel.backgroundColor = [UIColor clearColor];
    endNodeLabel.text = @"终点：腾讯大厦";
    endNodeLabel.textAlignment = NSTextAlignmentCenter;
    endNodeLabel.autoresizingMask = UIViewAutoresizingFlexibleWidth;
    [self.view addSubview:endNodeLabel];
    
    CGSize buttonSize = {240,40};
    CGRect buttonFrame = {(self.view.frame.size.width-buttonSize.width)/2,40+endNodeLabel.frame.size.height+endNodeLabel.frame.origin.y,buttonSize.width,buttonSize.height};
    UIButton* realNaviButton = [self createButton:@"开始导航" target:@selector(realNavi:)  frame:buttonFrame];
    [self.view addSubview:realNaviButton];
    if (self.naviType == BN_NaviTypeReal) {
        [self setCarPlateInfo];
    } else if (self.naviType == BN_NaviTypeMoto) {
        [self setMotorPlateInfo];
    }
    
    //设置白天黑夜模式
    //[BNCoreServices_Strategy setDayNightType:BNDayNight_CFG_Type_Auto];
    //设置停车场
    //[BNCoreServices_Strategy setParkInfo:YES];
    
    CLLocationCoordinate2D wgs84llCoordinate = [BNaviService_Location getLastLocation].coordinate;
    //assign your coordinate here...
    
    CLLocationCoordinate2D bd09McCoordinate;
    //the coordinate in bd09MC standard, which can be used to show poi on baidu map
    bd09McCoordinate = [BNUtility convertToBD09MCWithWGS84ll:wgs84llCoordinate];
    
    [[BNaviModel getInstance] addNaviModelListener:self];
    ///退出导航的时候 设置是否 销毁TTS  默认YES。设置为NO TTS 占用内存不释放。需要开发者自己手动释放内存
    BNaviService_Strategy.exitNaviDestroyTTS = YES;
    
    /// 超速回调需要将当前的VC继承代理 BNaviModelDelegate  添加到listener 才能使用。
    [[BNaviModel getInstance] addNaviModelListener:self];
}

- (void)onHandleGPSSpeedChange:(BNKMNaviSpeed *)speed speedLimit:(int)speedLimit {
    ////超过一公里 超速就提示一下。
    if (speed.speed > speedLimit) {
        if (self.lastDist == 0 || ((self.lastDist - self.beforDist) >= 1000)) {
            @synchronized (self) {
                self.lastDist = self.beforDist;
            }
            
            [self onHandleSpeedLimit];
        }
        
    }
       
}
-(void)onHandleRemainInfo:(BNaviRemainInfo *)remainInfo {
    self.beforDist = remainInfo.remainDist;
    NSLog(@"当前已经行驶的 距离%ld", (long)remainInfo.remainDist);
    
    
}
-(void)onHandleSpeedLimit {
    NSLog(@"超速");
}
//-(void)onHandleRemainInfo:(BNaviRemainInfo *)remainInfo {
//    [BNaviService_UI exitPage:EN_BNavi_ExitAllVC animated:NO extraInfo:nil];
//}
- (BOOL)checkServicesInited
{
    if(![BNaviService_Instance isServicesInited])
    {
        UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"提示"
                                                            message:@"引擎尚未初始化完成，请稍后再试"
                                                           delegate:nil
                                                  cancelButtonTitle:@"我知道了"
                                                  otherButtonTitles:nil];
        [alertView show];
        return NO;
    }
    return YES;
}

//模拟导航
- (void)simulateNavi:(UIButton*)button
{
    if (![self checkServicesInited]) return;
    [self startNavi];

}

//真实GPS导航
- (void)realNavi:(UIButton*)button
{
    if (![self checkServicesInited]) return;
    [self startNavi];
}

- (void)startNavi
{
    BOOL useMyLocation = NO;
    NSMutableArray *nodesArray = [[NSMutableArray alloc]initWithCapacity:2];
    //起点 传入的是原始的经纬度坐标，若使用的是百度地图坐标，可以使用BNTools类进行坐标转化
    CLLocation *myLocation = [BNaviService_Location getLastLocation];
    BNRoutePlanNode *startNode = [[BNRoutePlanNode alloc] init];
    startNode.pos = [[BNPosition alloc] init];
//    if (useMyLocation) {
//        startNode.pos.x = myLocation.coordinate.longitude;
//        startNode.pos.y = myLocation.coordinate.latitude;
//        startNode.pos.eType = BNCoordinate_OriginalGPS;
//    }
//    else {
        startNode.pos.x = 113.948682;
        startNode.pos.y = 22.530758;
        startNode.pos.eType = BNCoordinate_BaiduMapSDK;
//    }
    [nodesArray addObject:startNode];
    
    //也可以在此加入1到3个的途经点
    
//    BNRoutePlanNode *midNode = [[BNRoutePlanNode alloc] init];
//    midNode.pos = [[BNPosition alloc] init];
//    midNode.pos.x = 113.977004;
//    midNode.pos.y = 22.556393;
//    midNode.pos.eType = BNCoordinate_BaiduMapSDK;
//    [nodesArray addObject:midNode];
    
    //终点
    //终点：腾讯大厦
    BNRoutePlanNode *endNode = [[BNRoutePlanNode alloc] init];
    endNode.pos = [[BNPosition alloc] init];
    //113.941079,22.546103
    endNode.pos.x = 113.941079;
    endNode.pos.y = 22.546103;
    endNode.pos.eType = BNCoordinate_BaiduMapSDK;
    [nodesArray addObject:endNode];
    
    //关闭openURL,不想跳转百度地图可以设为YES
    [BNaviService_RoutePlan setDisableOpenUrl:YES];
    [BNaviService_RoutePlan startNaviRoutePlan:BNRoutePlanMode_Recommend naviNodes:nodesArray time:nil delegete:self userInfo:@{BNaviTripTypeKey:@(self.naviType)}];
}

#pragma mark - BNNaviRoutePlanDelegate
//算路成功回调
-(void)routePlanDidFinished:(NSDictionary *)userInfo
{
    NSLog(@"算路成功");
    
    //路径规划成功，开始导航
    BNaviService_Strategy.naviLocationOffset = 0;
    BNaviService_Strategy.bottomButtonHeight = 0;
    BNaviService_Strategy.toolBarViewTopSpace = 0;
    [BNaviService_UI showPage:BNaviUI_NormalNavi delegate:self extParams:@{BNaviUI_NormalNavi_TypeKey: @(self.naviType)}];
}

-(void)onHandleNaviViewDidLoad:(UIView *)naviView {
    
    
}

//算路失败回调
- (void)routePlanDidFailedWithError:(NSError *)error andUserInfo:(NSDictionary*)userInfo
{
    switch ([error code]%10000)
    {
        case BNAVI_ROUTEPLAN_ERROR_LOCATIONFAILED:
            NSLog(@"暂时无法获取您的位置,请稍后重试");
            break;
        case BNAVI_ROUTEPLAN_ERROR_ROUTEPLANFAILED:
            NSLog(@"无法发起导航");
            break;
        case BNAVI_ROUTEPLAN_ERROR_LOCATIONSERVICECLOSED:
            NSLog(@"定位服务未开启,请到系统设置中打开定位服务。");
            break;
        case BNAVI_ROUTEPLAN_ERROR_NODESTOONEAR:
            NSLog(@"起终点距离起终点太近");
            break;
        default:
            NSLog(@"算路失败");
            break;
    }
}

//算路取消回调
-(void)routePlanDidUserCanceled:(NSDictionary*)userInfo {
    NSLog(@"算路取消");
}

//自定义货车底部BottomBarView
- (UIView *)naviBottomBarView {
//    return self.bottomView;
    return nil;
}

- (CustomBottomBar *)bottomView {
    if (!_bottomView) {
        CustomBottomBar *view = [[CustomBottomBar alloc]initWithFrame:CGRectZero];
        _bottomView = view;
    }
    return _bottomView;
}


#pragma mark - 安静退出导航

- (void)exitNaviUI
{
    [BNaviService_UI exitPage:EN_BNavi_ExitTopVC animated:YES extraInfo:nil];
}

#pragma mark - BNNaviUIManagerDelegate

//退出导航页面回调
- (void)onExitPage:(BNaviUIType)pageType  extraInfo:(NSDictionary*)extraInfo
{
    if (pageType == BNaviUI_NormalNavi)
    {
        NSLog(@"退出导航");
    }
    else if (pageType == BNaviUI_Declaration)
    {
        NSLog(@"退出导航声明页面");
    }
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation
{
    return NO;
}

- (BOOL)shouldAutorotate
{
    return NO;
}

- (NSUInteger)supportedInterfaceOrientations
{
    return UIInterfaceOrientationMaskPortrait;
}

@end
